/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.execution.webui.configuration;

import com.kms.katalon.core.model.RunningMode;
import com.kms.katalon.core.setting.PropertySettingStoreUtil;
import com.kms.katalon.core.util.ApplicationRunningMode;
import com.kms.katalon.core.webui.driver.WebUIDriverType;
import com.kms.katalon.core.webui.util.WebDriverCleanerUtil;
import com.kms.katalon.core.webui.util.WebDriverPropertyUtil;
import com.kms.katalon.execution.configuration.IDriverConnector;
import com.kms.katalon.execution.configuration.IRunConfiguration;
import com.kms.katalon.execution.exception.ExecutionException;
import com.kms.katalon.execution.webui.configuration.WebDriverManagerRunConfiguration;
import com.kms.katalon.execution.webui.configuration.WebUiRunConfiguration;
import com.kms.katalon.execution.webui.driver.ChromeDriverConnector;
import com.kms.katalon.execution.webui.driver.SeleniumWebDriverProvider;
import com.kms.katalon.logging.LogUtil;
import com.kms.katalon.preferences.internal.PreferenceStoreManager;
import com.kms.katalon.preferences.internal.ScopedPreferenceStore;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class ChromeRunConfiguration
extends WebUiRunConfiguration {
    private String driverPath = this.buildChromeDriverPath();

    public ChromeRunConfiguration(String projectDir) throws IOException {
        super(projectDir, new ChromeDriverConnector(String.valueOf(projectDir) + File.separator + PropertySettingStoreUtil.INTERNAL_SETTING_ROOT_FOLDER_NAME));
    }

    private String buildChromeDriverPath() {
        String driverPath = SeleniumWebDriverProvider.getChromeDriverPath();
        ScopedPreferenceStore store = PreferenceStoreManager.getPreferenceStore((String)"com.kms.katalon.core.webui");
        boolean isUpdateDriverAllowed = store.getBoolean("webui.autoUpdateDrivers");
        if (isUpdateDriverAllowed && ApplicationRunningMode.get() == RunningMode.CONSOLE) {
            WebDriverManagerRunConfiguration webDriverManagerRunConfiguration = new WebDriverManagerRunConfiguration();
            try {
                WebDriverCleanerUtil.terminateChromedriver();
                webDriverManagerRunConfiguration.downloadDriver(WebUIDriverType.CHROME_DRIVER, SeleniumWebDriverProvider.getTempDriverDirectory());
                String tempDriverPath = SeleniumWebDriverProvider.getTempChromeDriverPath();
                if (new File(tempDriverPath).exists()) {
                    driverPath = tempDriverPath;
                }
            }
            catch (IOException | InterruptedException e) {
                LogUtil.logError((Throwable)e);
            }
            LogUtil.printOutputLine((String)("Chrome driver is located at: " + driverPath));
        } else {
            LogUtil.printOutputLine((String)String.format("chromedriver is located at default location: %s. In case your browser is updated to a newer version, please use this command to update chromdriver: --config -%s=true", driverPath, "webui.autoUpdateDrivers"));
        }
        return driverPath;
    }

    public IRunConfiguration cloneConfig() throws IOException {
        return new ChromeRunConfiguration(this.projectDir);
    }

    public boolean allowsRecording() {
        return true;
    }

    @Override
    public Map<String, IDriverConnector> getDriverConnectors() {
        Map<String, IDriverConnector> driverConnectors = super.getDriverConnectors();
        for (Map.Entry<String, IDriverConnector> entry : driverConnectors.entrySet()) {
            if (!(entry.getValue() instanceof ChromeDriverConnector)) continue;
            ChromeDriverConnector driverConnector = (ChromeDriverConnector)entry.getValue();
            driverConnector.setChromeDriverPath(this.driverPath);
        }
        return driverConnectors;
    }

    public Map<String, String> getAdditionalEnvironmentVariables() throws IOException, ExecutionException {
        HashMap<String, String> environmentVariables = new HashMap<String, String>(super.getAdditionalEnvironmentVariables());
        environmentVariables.put("KATALON_DOCKER", String.valueOf(WebDriverPropertyUtil.isRunningInDocker()));
        return environmentVariables;
    }
}

