/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.execution.webui.configuration;

import com.kms.katalon.core.model.RunningMode;
import com.kms.katalon.core.setting.PropertySettingStoreUtil;
import com.kms.katalon.core.util.ApplicationRunningMode;
import com.kms.katalon.core.webui.driver.WebUIDriverType;
import com.kms.katalon.core.webui.util.WebDriverCleanerUtil;
import com.kms.katalon.core.webui.util.WebDriverPropertyUtil;
import com.kms.katalon.execution.configuration.IDriverConnector;
import com.kms.katalon.execution.configuration.IRunConfiguration;
import com.kms.katalon.execution.exception.ExecutionException;
import com.kms.katalon.execution.webui.configuration.WebDriverManagerRunConfiguration;
import com.kms.katalon.execution.webui.configuration.WebUiRunConfiguration;
import com.kms.katalon.execution.webui.driver.EdgeChromiumDriverConnector;
import com.kms.katalon.execution.webui.driver.SeleniumWebDriverProvider;
import com.kms.katalon.logging.LogUtil;
import com.kms.katalon.preferences.internal.PreferenceStoreManager;
import com.kms.katalon.preferences.internal.ScopedPreferenceStore;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class EdgeChromiumRunConfiguration
extends WebUiRunConfiguration {
    private String edgeChromiumDriverPath = this.buildEdgeDriverPath();

    public EdgeChromiumRunConfiguration(String projectDir) throws IOException {
        super(projectDir, new EdgeChromiumDriverConnector(String.valueOf(projectDir) + File.separator + PropertySettingStoreUtil.INTERNAL_SETTING_ROOT_FOLDER_NAME));
    }

    private String buildEdgeDriverPath() {
        String driverPath = SeleniumWebDriverProvider.getEdgeChromiumDriverPath();
        ScopedPreferenceStore store = PreferenceStoreManager.getPreferenceStore((String)"com.kms.katalon.core.webui");
        boolean isUpdateDriverAllowed = store.getBoolean("webui.autoUpdateDrivers");
        if (isUpdateDriverAllowed && ApplicationRunningMode.get() == RunningMode.CONSOLE) {
            WebDriverManagerRunConfiguration webDriverManagerRunConfiguration = new WebDriverManagerRunConfiguration();
            try {
                WebDriverCleanerUtil.terminateEdgeChromiumDriver();
                webDriverManagerRunConfiguration.downloadDriver(WebUIDriverType.EDGE_CHROMIUM_DRIVER, SeleniumWebDriverProvider.getTempDriverDirectory());
                String tempDriverPath = SeleniumWebDriverProvider.getTempEdgeChromiumDriverPath();
                if (new File(tempDriverPath).exists()) {
                    driverPath = tempDriverPath;
                }
            }
            catch (IOException | InterruptedException e) {
                LogUtil.logError((Throwable)e);
            }
            LogUtil.printOutputLine((String)("Edge Chromium driver is located at: " + driverPath));
        } else {
            LogUtil.printOutputLine((String)String.format("Edge Chromium driver is located at default location: %s. In case your browser is updated to a newer version, please use this command to update Edge driver: --config -%s=true", driverPath, "webui.autoUpdateDrivers"));
        }
        return driverPath;
    }

    @Override
    public Map<String, IDriverConnector> getDriverConnectors() {
        Map<String, IDriverConnector> driverConnectors = super.getDriverConnectors();
        for (Map.Entry<String, IDriverConnector> entry : driverConnectors.entrySet()) {
            if (!(entry.getValue() instanceof EdgeChromiumDriverConnector)) continue;
            EdgeChromiumDriverConnector driverConnector = (EdgeChromiumDriverConnector)entry.getValue();
            driverConnector.setEdgeDriverPath(this.edgeChromiumDriverPath);
        }
        return driverConnectors;
    }

    public Map<String, String> getAdditionalEnvironmentVariables() throws IOException, ExecutionException {
        HashMap<String, String> environmentVariables = new HashMap<String, String>(super.getAdditionalEnvironmentVariables());
        environmentVariables.put("KATALON_DOCKER", String.valueOf(WebDriverPropertyUtil.isRunningInDocker()));
        return environmentVariables;
    }

    public IRunConfiguration cloneConfig() throws IOException, ExecutionException {
        return new EdgeChromiumRunConfiguration(this.projectDir);
    }
}

