/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.execution.webui.configuration;

import com.kms.katalon.core.model.RunningMode;
import com.kms.katalon.core.setting.PropertySettingStoreUtil;
import com.kms.katalon.core.util.ApplicationRunningMode;
import com.kms.katalon.core.webui.driver.WebUIDriverType;
import com.kms.katalon.core.webui.util.WebDriverCleanerUtil;
import com.kms.katalon.execution.configuration.IDriverConnector;
import com.kms.katalon.execution.configuration.IRunConfiguration;
import com.kms.katalon.execution.webui.configuration.WebDriverManagerRunConfiguration;
import com.kms.katalon.execution.webui.configuration.WebUiRunConfiguration;
import com.kms.katalon.execution.webui.driver.EdgeDriverConnector;
import com.kms.katalon.execution.webui.driver.SeleniumWebDriverProvider;
import com.kms.katalon.logging.LogUtil;
import com.kms.katalon.preferences.internal.PreferenceStoreManager;
import com.kms.katalon.preferences.internal.ScopedPreferenceStore;
import java.io.File;
import java.io.IOException;
import java.util.Map;

public class EdgeRunConfiguration
extends WebUiRunConfiguration {
    private String driverPath = this.buildEdgeDriverPath();

    public EdgeRunConfiguration(String projectDir) throws IOException {
        super(projectDir, new EdgeDriverConnector(String.valueOf(projectDir) + File.separator + PropertySettingStoreUtil.INTERNAL_SETTING_ROOT_FOLDER_NAME));
    }

    private String buildEdgeDriverPath() {
        String driverPath = SeleniumWebDriverProvider.getEdgeDriverPath();
        ScopedPreferenceStore store = PreferenceStoreManager.getPreferenceStore((String)"com.kms.katalon.core.webui");
        boolean isUpdateDriverAllowed = store.getBoolean("webui.autoUpdateDrivers");
        if (isUpdateDriverAllowed && ApplicationRunningMode.get() == RunningMode.CONSOLE) {
            WebDriverManagerRunConfiguration webDriverManagerRunConfiguration = new WebDriverManagerRunConfiguration();
            try {
                WebDriverCleanerUtil.terminateMicrosoftWebDriver();
                webDriverManagerRunConfiguration.downloadDriver(WebUIDriverType.EDGE_DRIVER, SeleniumWebDriverProvider.getTempDriverDirectory());
                String tempDriverPath = SeleniumWebDriverProvider.getTempEdgeDriverPath();
                if (new File(tempDriverPath).exists()) {
                    driverPath = tempDriverPath;
                }
            }
            catch (IOException | InterruptedException e) {
                LogUtil.logError((Throwable)e);
            }
            LogUtil.printOutputLine((String)("Edge driver is located at: " + driverPath));
        } else {
            LogUtil.printOutputLine((String)String.format("Edge driver is located at default location: %s. In case your browser is updated to a newer version, please use this command to update Edge driver: --config -%s=true", driverPath, "webui.autoUpdateDrivers"));
        }
        return driverPath;
    }

    @Override
    public Map<String, IDriverConnector> getDriverConnectors() {
        Map<String, IDriverConnector> driverConnectors = super.getDriverConnectors();
        for (Map.Entry<String, IDriverConnector> entry : driverConnectors.entrySet()) {
            if (!(entry.getValue() instanceof EdgeDriverConnector)) continue;
            EdgeDriverConnector driverConnector = (EdgeDriverConnector)entry.getValue();
            driverConnector.setEdgeDriverPath(this.driverPath);
        }
        return driverConnectors;
    }

    public IRunConfiguration cloneConfig() throws IOException {
        return new EdgeRunConfiguration(this.projectDir);
    }

    public boolean allowsRecording() {
        return true;
    }
}

