/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.execution.webui.configuration;

import com.kms.katalon.core.model.RunningMode;
import com.kms.katalon.core.setting.PropertySettingStoreUtil;
import com.kms.katalon.core.util.ApplicationRunningMode;
import com.kms.katalon.core.webui.driver.WebUIDriverType;
import com.kms.katalon.execution.configuration.IDriverConnector;
import com.kms.katalon.execution.configuration.IRunConfiguration;
import com.kms.katalon.execution.webui.configuration.WebDriverManagerRunConfiguration;
import com.kms.katalon.execution.webui.configuration.WebUiRunConfiguration;
import com.kms.katalon.execution.webui.driver.FirefoxHeadlessDriverConnector;
import com.kms.katalon.execution.webui.driver.SeleniumWebDriverProvider;
import com.kms.katalon.logging.LogUtil;
import com.kms.katalon.preferences.internal.PreferenceStoreManager;
import com.kms.katalon.preferences.internal.ScopedPreferenceStore;
import java.io.File;
import java.io.IOException;
import java.util.Map;

public class FirefoxHeadlessRunConfiguration
extends WebUiRunConfiguration {
    private String driverPath = this.buildGeckoDriverPath();

    public FirefoxHeadlessRunConfiguration(String projectDir) throws IOException {
        super(projectDir, new FirefoxHeadlessDriverConnector(String.valueOf(projectDir) + File.separator + PropertySettingStoreUtil.INTERNAL_SETTING_ROOT_FOLDER_NAME));
    }

    public IRunConfiguration cloneConfig() throws IOException {
        return new FirefoxHeadlessRunConfiguration(this.projectDir);
    }

    private String buildGeckoDriverPath() {
        String driverPath = "";
        try {
            driverPath = SeleniumWebDriverProvider.getGeckoDriverPath();
        }
        catch (IOException ex) {
            LogUtil.printAndLogError((Throwable)ex);
        }
        ScopedPreferenceStore store = PreferenceStoreManager.getPreferenceStore((String)"com.kms.katalon.core.webui");
        boolean isUpdateDriverAllowed = store.getBoolean("webui.autoUpdateDrivers");
        if (isUpdateDriverAllowed && ApplicationRunningMode.get() == RunningMode.CONSOLE) {
            WebDriverManagerRunConfiguration webDriverManagerRunConfiguration = new WebDriverManagerRunConfiguration();
            try {
                webDriverManagerRunConfiguration.downloadDriver(WebUIDriverType.FIREFOX_HEADLESS_DRIVER, SeleniumWebDriverProvider.getTempDriverDirectory());
                String tempDriverPath = SeleniumWebDriverProvider.getTempGeckoDriverPath();
                if (new File(tempDriverPath).exists()) {
                    driverPath = tempDriverPath;
                }
            }
            catch (IOException | InterruptedException e) {
                LogUtil.logError((Throwable)e);
            }
            LogUtil.printOutputLine((String)("gecko driver is located at: " + driverPath));
        } else {
            LogUtil.printOutputLine((String)String.format("gecko driver is located at default location: %s. In case your browser is updated to a newer version, please use this command to update gecko driver: --config -%s=true", driverPath, "webui.autoUpdateDrivers"));
        }
        return driverPath;
    }

    @Override
    public Map<String, IDriverConnector> getDriverConnectors() {
        Map<String, IDriverConnector> driverConnectors = super.getDriverConnectors();
        for (Map.Entry<String, IDriverConnector> entry : driverConnectors.entrySet()) {
            if (!(entry.getValue() instanceof FirefoxHeadlessDriverConnector)) continue;
            FirefoxHeadlessDriverConnector driverConnector = (FirefoxHeadlessDriverConnector)entry.getValue();
            driverConnector.setGeckoDriverPath(this.driverPath);
        }
        return driverConnectors;
    }
}

