/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.execution.webui.configuration;

import com.kms.katalon.core.model.RunningMode;
import com.kms.katalon.core.setting.PropertySettingStoreUtil;
import com.kms.katalon.core.util.ApplicationRunningMode;
import com.kms.katalon.core.webui.driver.WebUIDriverType;
import com.kms.katalon.execution.configuration.IDriverConnector;
import com.kms.katalon.execution.configuration.IRunConfiguration;
import com.kms.katalon.execution.webui.configuration.WebDriverManagerRunConfiguration;
import com.kms.katalon.execution.webui.configuration.WebUiRunConfiguration;
import com.kms.katalon.execution.webui.driver.HeadlessDriverConnector;
import com.kms.katalon.execution.webui.driver.SeleniumWebDriverProvider;
import com.kms.katalon.logging.LogUtil;
import com.kms.katalon.preferences.internal.PreferenceStoreManager;
import com.kms.katalon.preferences.internal.ScopedPreferenceStore;
import java.io.File;
import java.io.IOException;
import java.util.Map;

public class HeadlessRunConfiguration
extends WebUiRunConfiguration {
    private String driverPath = this.buildChromeDriverPath();

    public HeadlessRunConfiguration(String projectDir) throws IOException {
        super(projectDir, new HeadlessDriverConnector(String.valueOf(projectDir) + File.separator + PropertySettingStoreUtil.INTERNAL_SETTING_ROOT_FOLDER_NAME));
    }

    private String buildChromeDriverPath() {
        String driverPath = SeleniumWebDriverProvider.getChromeDriverPath();
        ScopedPreferenceStore store = PreferenceStoreManager.getPreferenceStore((String)"com.kms.katalon.core.webui");
        boolean isUpdateDriverAllowed = store.getBoolean("webui.autoUpdateDrivers");
        if (isUpdateDriverAllowed && ApplicationRunningMode.get() == RunningMode.CONSOLE) {
            WebDriverManagerRunConfiguration webDriverManagerRunConfiguration = new WebDriverManagerRunConfiguration();
            try {
                webDriverManagerRunConfiguration.downloadDriver(WebUIDriverType.HEADLESS_DRIVER, SeleniumWebDriverProvider.getTempDriverDirectory());
                String tempDriverPath = SeleniumWebDriverProvider.getTempChromeDriverPath();
                if (new File(tempDriverPath).exists()) {
                    driverPath = tempDriverPath;
                }
            }
            catch (IOException | InterruptedException e) {
                LogUtil.logError((Throwable)e);
            }
            LogUtil.printOutputLine((String)("chromedriver is located at: " + driverPath));
        } else {
            LogUtil.printOutputLine((String)String.format("chromedriver is located at default location: %s. In case your browser is updated to a newer version, please use this command to update chromdriver: --config -%s=true", driverPath, "webui.autoUpdateDrivers"));
        }
        return driverPath;
    }

    @Override
    public Map<String, IDriverConnector> getDriverConnectors() {
        Map<String, IDriverConnector> driverConnectors = super.getDriverConnectors();
        for (Map.Entry<String, IDriverConnector> entry : driverConnectors.entrySet()) {
            if (!(entry.getValue() instanceof HeadlessDriverConnector)) continue;
            HeadlessDriverConnector driverConnector = (HeadlessDriverConnector)entry.getValue();
            driverConnector.setChromeDriverPath(this.driverPath);
        }
        return driverConnectors;
    }

    public IRunConfiguration cloneConfig() throws IOException {
        return new HeadlessRunConfiguration(this.projectDir);
    }
}

