/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.execution.webui.driver;

import com.kms.katalon.core.driver.DriverType;
import com.kms.katalon.core.mobile.driver.MobileDriverType;
import com.kms.katalon.core.util.TestCloudPropertyUtil;
import com.kms.katalon.core.webui.driver.WebUIDriverType;
import com.kms.katalon.execution.webui.driver.WebUiDriverConnector;
import com.kms.katalon.logging.LogUtil;
import com.kms.katalon.util.CryptoUtil;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class RemoteWebDriverConnector
extends WebUiDriverConnector {
    protected String remoteServerUrl;
    protected RemoteWebDriverConnectorType remoteWebDriverConnectorType;
    protected MobileDriverType mobileDriverType;

    public RemoteWebDriverConnector(String configurationFolderPath) throws IOException {
        super(configurationFolderPath);
    }

    public DriverType getDriverType() {
        return WebUIDriverType.REMOTE_WEB_DRIVER;
    }

    public String getRemoteServerUrl() {
        return this.remoteServerUrl;
    }

    public void setRemoteServerUrl(String remoteServerUrl) {
        this.remoteServerUrl = remoteServerUrl;
    }

    public MobileDriverType getMobileDriverType() {
        return this.mobileDriverType;
    }

    public void setMobileDriverType(MobileDriverType mobileDriverType) {
        this.mobileDriverType = mobileDriverType;
    }

    public Map<String, Object> getSystemProperties() {
        Map propertyMap = super.getSystemProperties();
        String remoteServerUrl = this.getRemoteServerUrl();
        if (TestCloudPropertyUtil.getInstance().isRunFromTestCloud(this.getUserConfigProperties())) {
            try {
                remoteServerUrl = CryptoUtil.encode((CryptoUtil.CrytoInfo)CryptoUtil.getDefault((String)this.getRemoteServerUrl()));
                propertyMap.put("isEncrypted", true);
            }
            catch (UnsupportedEncodingException | GeneralSecurityException exception) {
                LogUtil.logError((Throwable)exception);
            }
        }
        propertyMap.put("remoteWebDriverUrl", remoteServerUrl);
        propertyMap.put("remoteWebDriverType", this.getRemoteWebDriverConnectorType().name());
        if (this.mobileDriverType != null) {
            propertyMap.put("remoteMobileDriver", this.mobileDriverType.name());
        }
        return propertyMap;
    }

    protected void loadDriverProperties() throws IOException {
        super.loadDriverProperties();
        this.setAllConfigProperties(null);
    }

    public Map<String, Object> getUserConfigProperties() {
        return super.getUserConfigProperties();
    }

    public void saveUserConfigProperties() throws IOException {
        if (!this.driverProperties.containsKey("remoteWebDriverUrl")) {
            this.driverProperties.put("remoteWebDriverUrl", this.getRemoteServerUrl());
        }
        if (!this.driverProperties.containsKey("remoteWebDriverType")) {
            this.driverProperties.put("remoteWebDriverType", this.getRemoteWebDriverConnectorType().name());
        }
        if (!this.driverProperties.containsKey("remoteMobileDriver") && this.getMobileDriverType() != null) {
            this.driverProperties.put("remoteMobileDriver", this.getMobileDriverType().name());
        }
        super.saveUserConfigProperties();
    }

    public String toString() {
        HashMap<String, Object> tempMap = new HashMap<String, Object>(this.getUserConfigProperties());
        tempMap.put("remoteWebDriverUrl", this.getRemoteServerUrl());
        tempMap.put("remoteWebDriverType", this.getRemoteWebDriverConnectorType().name());
        if (this.mobileDriverType != null) {
            tempMap.put("remoteMobileDriver", this.mobileDriverType.name());
        }
        return ((Object)tempMap).toString();
    }

    public RemoteWebDriverConnectorType getRemoteWebDriverConnectorType() {
        return this.remoteWebDriverConnectorType;
    }

    public void setRemoteWebDriverConnectorType(RemoteWebDriverConnectorType remoteWebDriverConnectorType) {
        this.remoteWebDriverConnectorType = remoteWebDriverConnectorType;
    }

    public RemoteWebDriverConnector clone() {
        try {
            RemoteWebDriverConnector remoteDriverConnector = new RemoteWebDriverConnector(this.getParentFolderPath());
            remoteDriverConnector.setRemoteServerUrl(this.getRemoteServerUrl());
            remoteDriverConnector.setRemoteWebDriverConnectorType(this.getRemoteWebDriverConnectorType());
            remoteDriverConnector.setMobileDriverType(this.getMobileDriverType());
            remoteDriverConnector.driverProperties = (Map)this.cloneDriverPropertyValue(this.getUserConfigProperties());
            return remoteDriverConnector;
        }
        catch (IOException e) {
            LogUtil.logError((Throwable)e);
            return null;
        }
    }

    public Map<String, Object> getAllConfigProperties() {
        HashMap<String, Object> tempMap = new HashMap<String, Object>(this.getUserConfigProperties());
        if (StringUtils.isNotBlank((CharSequence)this.remoteServerUrl)) {
            tempMap.put("remoteWebDriverUrl", this.remoteServerUrl);
        }
        tempMap.put("remoteWebDriverType", this.remoteWebDriverConnectorType.name());
        if (this.mobileDriverType != null && this.remoteWebDriverConnectorType.equals((Object)RemoteWebDriverConnectorType.Appium)) {
            tempMap.put("remoteMobileDriver", this.getMobileDriverType().name());
        }
        return tempMap;
    }

    public void setAllConfigProperties(Map<String, Object> properties) {
        super.setAllConfigProperties(properties);
        this.remoteServerUrl = this.driverProperties.get("remoteWebDriverUrl") instanceof String ? (String)this.driverProperties.get("remoteWebDriverUrl") : "";
        this.remoteWebDriverConnectorType = this.driverProperties.get("remoteWebDriverType") instanceof String ? RemoteWebDriverConnectorType.valueOf((String)this.driverProperties.get("remoteWebDriverType")) : RemoteWebDriverConnectorType.Selenium;
        this.mobileDriverType = this.driverProperties.containsKey("remoteMobileDriver") ? MobileDriverType.valueOf((String)((String)this.driverProperties.get("remoteMobileDriver"))) : null;
        this.driverProperties.remove("remoteWebDriverUrl");
        this.driverProperties.remove("remoteWebDriverType");
        this.driverProperties.remove("remoteMobileDriver");
        if (this.driverProperties.containsKey("katalon:option")) {
            TestCloudPropertyUtil.getInstance().setRunFromTestCloud(this.driverProperties);
        }
    }

    public static enum RemoteWebDriverConnectorType {
        Selenium,
        Appium;


        public static String[] stringValues() {
            RemoteWebDriverConnectorType[] values = RemoteWebDriverConnectorType.values();
            String[] stringValues = new String[values.length];
            int i = 0;
            while (i < values.length) {
                stringValues[i] = values[i].name();
                ++i;
            }
            return stringValues;
        }

        public static int indexOf(RemoteWebDriverConnectorType remoteType) {
            RemoteWebDriverConnectorType[] values = RemoteWebDriverConnectorType.values();
            int index = 0;
            while (index < values.length) {
                if (values[index] == remoteType) {
                    return index;
                }
                ++index;
            }
            return -1;
        }
    }
}

