/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.execution.webui.setting;

import com.google.gson.reflect.TypeToken;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.core.setting.BundleSettingStore;
import com.kms.katalon.core.testobject.SelectorMethod;
import com.kms.katalon.core.util.internal.JsonUtil;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.execution.constants.StringConstants;
import com.kms.katalon.util.collections.Pair;
import java.io.IOException;
import java.lang.reflect.Type;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.osgi.framework.FrameworkUtil;

public class WebUiExecutionSettingStore
extends BundleSettingStore {
    public static final boolean EXECUTION_DEFAULT_IGNORE_PAGELOAD_TIMEOUT_EXCEPTION = false;
    public static final boolean EXECUTION_DEFAULT_ENABLE_PAGE_LOAD_TIMEOUT = false;
    public static final int EXECUTION_DEFAULT_ACTION_DELAY = 0;
    public static final int EXECUTION_DEFAULT_PAGE_LOAD_TIMEOUT = 30;
    public static final int EXECUTION_DEFAULT_WAIT_FOR_IE_HANGING = 600;
    public static final String DEFAULT_SELECTING_CAPTURED_OBJECT_PROPERTIES = "id,true;name,true;alt,true;checked,true;form,true;href,true;placeholder,true;selected,true;src,true;title,true;type,true;text,true;linked_text,true";
    public static final String DEFAULT_SELECTING_CAPTURED_OBJECT_XPATHS = "xpath:attributes,true;xpath:idRelative,true;dom:name,true;xpath:link,true;xpath:neighbor,true;xpath:href,true;xpath:img,true;xpath:position,true;xpath:customAttributes,true";
    public static final String DEFAULT_SELECTING_CAPTURED_OBJECT_SELECTOR_METHOD = "XPATH";
    public static final String EXECUTION_DEFAULT_USE_ACTION_DELAY_TIME_UNIT = TimeUnit.SECONDS.toString();
    public static final String DEFAULT_METHODS_PRIORITY_ORDER = MessageFormat.format("{0},true;{1},true;{2},true;{3},true;{4},true", SelectorMethod.XPATH, SelectorMethod.SMART_LOCATOR, SelectorMethod.BASIC, SelectorMethod.CSS, SelectorMethod.IMAGE);
    public static final String DEFAULT_EXCLUDE_KEYWORDS = "[\"verifyElementPresent\",\"verifyElementNotPresent\"]";
    public static final boolean DEFAULT_IS_ENABLE_SELF_HEALING = false;
    public static final boolean DEFAULT_IS_ENABLE_TIME_CAPSULE = false;

    public static WebUiExecutionSettingStore getStore() {
        ProjectEntity projectEntity = ProjectController.getInstance().getCurrentProject();
        if (projectEntity == null) {
            return null;
        }
        return new WebUiExecutionSettingStore(projectEntity);
    }

    public WebUiExecutionSettingStore(ProjectEntity projectEntity) {
        super(projectEntity.getFolderLocation(), FrameworkUtil.getBundle(WebUiExecutionSettingStore.class).getSymbolicName(), false);
    }

    public WebUiExecutionSettingStore(String projectEntityDirection, boolean isExternal) {
        super(projectEntityDirection, FrameworkUtil.getBundle(WebUiExecutionSettingStore.class).getSymbolicName(), isExternal);
    }

    public boolean getEnablePageLoadTimeout() throws IOException {
        return this.getBoolean("execution.default.webUi.enablePageLoadTimeout", false);
    }

    public void setEnablePageLoadTimeout(boolean pageLoadTimeoutEnabled) throws IOException {
        this.setProperty("execution.default.webUi.enablePageLoadTimeout", pageLoadTimeoutEnabled);
    }

    public boolean getIgnorePageLoadTimeout() throws IOException {
        return this.getBoolean("execution.default.webUi.ignorePageLoadTimeOutException", false);
    }

    public void setIgnorePageLoadTimeout(boolean pageLoadTimeoutIgnored) throws IOException {
        this.setProperty("execution.default.webUi.ignorePageLoadTimeOutException", pageLoadTimeoutIgnored);
    }

    public int getPageLoadTimeout() throws IOException {
        return this.getInt("execution.default.webUi.pageLoadTimeout", 30);
    }

    public void setPageLoadTimeout(int pageLoadTimeout) throws IOException {
        this.setProperty("execution.default.webUi.pageLoadTimeout", pageLoadTimeout);
    }

    public int getActionDelay() throws IOException {
        return this.getInt("execution.default.webUi.actionDelay", 0);
    }

    public void setActionDelay(int actionDelay) throws IOException {
        this.setProperty("execution.default.webUi.actionDelay", actionDelay);
    }

    public int getIEHangTimeout() throws IOException {
        return this.getInt("execution.default.waitForIEHanging", 600);
    }

    public void setIEHangTimeout(int timeout) throws IOException {
        this.setProperty("execution.default.waitForIEHanging", timeout);
    }

    public void setDefaultIEHangTimeout() throws IOException {
        this.setProperty("execution.default.waitForIEHanging", 600);
    }

    public void setDefaultCapturedTestObjectAttributeLocators() throws IOException {
        this.setProperty("execution.default.selectingCapturedObjectProperties", DEFAULT_SELECTING_CAPTURED_OBJECT_PROPERTIES);
    }

    public void setCapturedTestObjectAttributeLocators(List<Pair<String, Boolean>> locators) throws IOException {
        this.setProperty("execution.default.selectingCapturedObjectProperties", this.flattenStringBooleanList(locators));
    }

    public List<Pair<String, Boolean>> getCapturedTestObjectAttributeLocators() throws IOException {
        return this.parseStringBooleanString(this.getString("execution.default.selectingCapturedObjectProperties", DEFAULT_SELECTING_CAPTURED_OBJECT_PROPERTIES));
    }

    public List<Pair<String, Boolean>> getDefaultCapturedTestObjectAttributeLocators() throws IOException {
        return this.parseStringBooleanString(this.getString(DEFAULT_SELECTING_CAPTURED_OBJECT_PROPERTIES, DEFAULT_SELECTING_CAPTURED_OBJECT_PROPERTIES));
    }

    public List<Pair<String, Boolean>> getCapturedTestObjectXpathLocators() throws IOException {
        return this.loadStringBooleanString("execution.default.selectingCapturedObjectXpaths", DEFAULT_SELECTING_CAPTURED_OBJECT_XPATHS);
    }

    public List<Pair<String, Boolean>> getDefaultCapturedObjectXpathLocators() throws IOException {
        return this.loadStringBooleanString(DEFAULT_SELECTING_CAPTURED_OBJECT_XPATHS, DEFAULT_SELECTING_CAPTURED_OBJECT_XPATHS);
    }

    public void setDefaultCapturedTestObjectXpathLocators() throws IOException {
        this.setProperty("execution.default.selectingCapturedObjectXpaths", DEFAULT_SELECTING_CAPTURED_OBJECT_XPATHS);
    }

    public void setCapturedTestObjectXpathLocators(List<Pair<String, Boolean>> locators) throws IOException {
        this.setProperty("execution.default.selectingCapturedObjectXpaths", this.flattenStringBooleanList(locators));
    }

    public void setDefaultCapturedTestObjectSelectorMethods() throws IOException {
        this.setProperty("execution.default.selectingCapturedObjectSelectorMethod", DEFAULT_SELECTING_CAPTURED_OBJECT_SELECTOR_METHOD);
    }

    public void setCapturedTestObjectSelectorMethod(SelectorMethod selectorMethod) throws IOException {
        this.setProperty("execution.default.selectingCapturedObjectSelectorMethod", selectorMethod.toString());
    }

    public void setBufferedSelectorMethod(SelectorMethod selectorMethod) throws IOException {
        this.setProperty("execution.default.bufferedSelectorMethod", selectorMethod.toString());
    }

    public void setSelectorMethodIsSmartLocator(boolean isUsingSmartLocator) throws IOException {
        this.setProperty("execution.default.isUsingSmartLocator", isUsingSmartLocator);
    }

    public SelectorMethod getCapturedTestObjectSelectorMethod() throws IOException {
        SelectorMethod chosenMethod;
        SelectorMethod bufferedMethod = this.getBufferedSelectorMethod();
        if (bufferedMethod != (chosenMethod = this.parseSelectorMethodString(this.getString("execution.default.selectingCapturedObjectSelectorMethod", DEFAULT_SELECTING_CAPTURED_OBJECT_SELECTOR_METHOD)))) {
            this.setBufferedSelectorMethod(chosenMethod);
            this.setSelectorMethodIsSmartLocator(false);
            return chosenMethod;
        }
        if (this.getSelectorMethodIsSmartLocator()) {
            return SelectorMethod.SMART_LOCATOR;
        }
        return chosenMethod;
    }

    public boolean getSelectorMethodIsSmartLocator() throws IOException {
        return this.getBoolean("execution.default.isUsingSmartLocator", false);
    }

    public SelectorMethod getBufferedSelectorMethod() throws IOException {
        return this.parseSelectorMethodString(this.getString("execution.default.bufferedSelectorMethod", DEFAULT_SELECTING_CAPTURED_OBJECT_SELECTOR_METHOD));
    }

    private String flattenStringBooleanList(List<Pair<String, Boolean>> list) {
        if (list == null || list.isEmpty()) {
            return StringConstants.EMPTY;
        }
        return list.stream().map(i -> String.valueOf((String)i.getLeft()) + "," + i.getRight()).collect(Collectors.joining(";"));
    }

    private List<Pair<String, Boolean>> parseStringBooleanString(String str) {
        if (str == null || str.isEmpty()) {
            return Collections.emptyList();
        }
        return Stream.of(str.split(";")).map(i -> i.split(",")).map(i -> new Pair((Object)i[0], (Object)Boolean.valueOf(i[1]))).collect(Collectors.toList());
    }

    private SelectorMethod parseSelectorMethodString(String str) {
        try {
            if (str == null || str.isEmpty()) {
                return SelectorMethod.BASIC;
            }
            return SelectorMethod.valueOf((String)str);
        }
        catch (Exception exception) {
            return SelectorMethod.BASIC;
        }
    }

    private List<Pair<String, Boolean>> loadStringBooleanString(String key, String defaultValue) throws IOException {
        List<Pair<String, Boolean>> allItems = this.parseStringBooleanString(this.getString(key, defaultValue));
        if (StringUtils.isNotBlank((CharSequence)defaultValue)) {
            List<Pair<String, Boolean>> defaultItems = this.parseStringBooleanString(defaultValue);
            defaultItems.forEach(itemI -> {
                if (!allItems.contains(itemI)) {
                    allItems.add((Pair<String, Boolean>)itemI);
                }
            });
        }
        return allItems;
    }

    public void setUseDelayActionTimeUnit(TimeUnit timeUnit) throws IOException {
        this.setProperty("execution.default.useDelayActionInSecond", timeUnit.toString());
    }

    public TimeUnit getUseDelayActionTimeUnit() {
        try {
            return TimeUnit.valueOf(this.getString("execution.default.useDelayActionInSecond", EXECUTION_DEFAULT_USE_ACTION_DELAY_TIME_UNIT));
        }
        catch (IOException iOException) {
            return TimeUnit.valueOf(EXECUTION_DEFAULT_USE_ACTION_DELAY_TIME_UNIT);
        }
    }

    public void setExcludeKeywordList(List<String> excludeKeywords) throws IOException {
        String jsonExcludeKeywords = JsonUtil.toJson(excludeKeywords, (boolean)false);
        this.setProperty("execution.default.webUi.excludeKeywords", jsonExcludeKeywords);
    }

    public List<String> getExcludeKeywordList() throws IOException {
        String jsonExcludeKeywords = this.getString("execution.default.webUi.excludeKeywords", DEFAULT_EXCLUDE_KEYWORDS);
        if (StringUtils.isBlank((CharSequence)jsonExcludeKeywords)) {
            return new ArrayList<String>();
        }
        Type excludeKeywordsMapType = new TypeToken<List<String>>(){}.getType();
        return (List)JsonUtil.fromJson((String)jsonExcludeKeywords, (Type)excludeKeywordsMapType);
    }

    public void setDefaultExcludeKeywordList() throws IOException {
        this.setProperty("execution.default.webUi.excludeKeywords", DEFAULT_EXCLUDE_KEYWORDS);
    }

    public void setMethodsPritorityOrder(List<Pair<SelectorMethod, Boolean>> methodsPriorityOrder) throws IOException {
        ArrayList<Pair<String, Boolean>> convertedList = new ArrayList<Pair<String, Boolean>>();
        for (Pair<SelectorMethod, Boolean> element : methodsPriorityOrder) {
            Pair convertedElement = new Pair((Object)((SelectorMethod)element.getLeft()).toString(), (Object)((Boolean)element.getRight()));
            convertedList.add((Pair<String, Boolean>)convertedElement);
        }
        this.setProperty("execution.default.webUi.methodsPriorityOrderNew", this.flattenStringBooleanList(convertedList));
    }

    public List<Pair<SelectorMethod, Boolean>> getMethodsPriorityOrder() throws IOException {
        List<Pair<String, Boolean>> rawMethodsPriorityOrder = this.parseStringBooleanString(this.getString("execution.default.webUi.methodsPriorityOrderNew", DEFAULT_METHODS_PRIORITY_ORDER));
        ArrayList<Pair<SelectorMethod, Boolean>> methodsPriorityOrder = new ArrayList<Pair<SelectorMethod, Boolean>>();
        rawMethodsPriorityOrder.forEach(rawMethod -> {
            Pair method = Pair.of((Object)SelectorMethod.valueOf((String)((String)rawMethod.getLeft())), (Object)((Boolean)rawMethod.getRight()));
            methodsPriorityOrder.add(method);
        });
        return methodsPriorityOrder;
    }

    public void setDefaultMethodsPriorityOrder() throws IOException {
        this.setProperty("execution.default.webUi.methodsPriorityOrderNew", DEFAULT_METHODS_PRIORITY_ORDER);
    }

    public boolean getSelfHealingEnabled(boolean defaultValue) {
        try {
            return this.getBoolean("execution.default.webUi.selfHealingEnabled", defaultValue);
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public void setEnableSelfHealing(boolean isEnable) throws IOException {
        this.setProperty("execution.default.webUi.selfHealingEnabled", isEnable);
    }

    public boolean getTimeCapsuleEnabled() {
        try {
            return this.getBoolean("execution.default.webUi.timeCapsuleEnabled", false);
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public void setEnableTimeCapsule(boolean isEnable) throws IOException {
        this.setProperty("execution.default.webUi.timeCapsuleEnabled", isEnable);
    }
}

