/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.integration.qtest;

import com.kms.katalon.integration.qtest.QTestIntegrationAuthenticationManager;
import com.kms.katalon.integration.qtest.credential.IQTestCredential;
import com.kms.katalon.integration.qtest.entity.QTestDefect;
import com.kms.katalon.integration.qtest.entity.QTestDefectField;
import com.kms.katalon.integration.qtest.entity.QTestRun;
import com.kms.katalon.integration.qtest.entity.QTestStepLog;
import com.kms.katalon.integration.qtest.exception.QTestException;
import com.kms.katalon.integration.qtest.exception.QTestInvalidFormatException;
import com.kms.katalon.integration.qtest.exception.QTestUnauthorizedException;
import com.kms.katalon.integration.qtest.helper.QTestAPIRequestHelper;
import java.util.ArrayList;
import java.util.List;
import org.qas.api.internal.util.json.JsonArray;
import org.qas.api.internal.util.json.JsonException;
import org.qas.api.internal.util.json.JsonObject;

public class QTestIntegrationExecutionManager {
    private QTestIntegrationExecutionManager() {
    }

    public static String numberFieldFormat(long fieldId, long fieldValue) {
        return String.format("{ \"field_id\": %s, \"field_value\": %s }", fieldId, fieldValue);
    }

    public static String stringFieldFormat(long fieldId, String fieldValue) {
        return String.format("{ \"field_id\": %s, \"field_value\": \"%s\" }", fieldId, fieldValue);
    }

    public static QTestDefect submitDefect(IQTestCredential credential, long projectId, String postBody) throws QTestException {
        String url = String.format(String.valueOf(credential.getServerUrl()) + "/api/v3/projects/%s/defects", projectId);
        String res = QTestAPIRequestHelper.sendPostRequestViaAPI(url, credential.getToken(), postBody);
        try {
            JsonObject jo = new JsonObject(res);
            QTestDefect defect = new QTestDefect(jo.getLong("id"), "");
            defect.setGid(jo.getString("pid"));
            return defect;
        }
        catch (JsonException jsonException) {
            throw QTestInvalidFormatException.createInvalidJsonFormatException(res);
        }
    }

    public static List<QTestRun> getTestRuns(IQTestCredential credential, long projectId, long testSuiteId) throws QTestException {
        if (!QTestIntegrationAuthenticationManager.validateToken(credential.getToken().getAccessTokenHeader())) {
            throw new QTestUnauthorizedException("Token is not valid");
        }
        ArrayList<QTestRun> list = new ArrayList<QTestRun>();
        String json = QTestAPIRequestHelper.sendGetRequestViaAPI(String.valueOf(credential.getServerUrl()) + "/api/v3/projects/" + projectId + "/test-runs?testSuiteId=" + testSuiteId, credential.getToken());
        try {
            List<String> testRunURLs = QTestIntegrationExecutionManager.parseJsonToGetTestRunURLs(json);
            for (String url : testRunURLs) {
                json = QTestAPIRequestHelper.sendGetRequestViaAPI(url, credential.getToken());
                JsonObject jo = new JsonObject(json);
                long runId = jo.getLong("id");
                String runName = jo.getString("name");
                QTestRun qTestRun = new QTestRun(runId, runName);
                list.add(qTestRun);
                qTestRun.setExecuted(jo.getBoolean("executed"));
                qTestRun.setStatusId(jo.getLong("status_id"));
                qTestRun.setTestCaseVersionId(jo.getLong("test_case_version_id"));
                qTestRun.setOrder(jo.getLong("order"));
                JsonArray jArr = jo.getJsonArray("links");
                int i = 0;
                while (i < jArr.length()) {
                    JsonObject objLink = jArr.getJsonObject(i);
                    String rel = objLink.getString("rel");
                    String href = objLink.getString("href");
                    if (rel.equals("self")) {
                        qTestRun.setHref(href);
                    } else if (rel.equals("test-case")) {
                        qTestRun.setTestCaseLink(href);
                        if (href != null && !href.equals("")) {
                            String strId = href.substring(href.indexOf("/test-cases/") + "/test-cases/".length(), href.indexOf("/versions/"));
                            qTestRun.setQTestCaseId(Long.parseLong(strId));
                        }
                    } else if (rel.equals("test-logs")) {
                        qTestRun.setTestLogsLink(href);
                    } else if (rel.equals("status-options")) {
                        qTestRun.setExecutionStatusesLink(href);
                    }
                    ++i;
                }
            }
            return list;
        }
        catch (JsonException jsonException) {
            throw QTestInvalidFormatException.createInvalidJsonFormatException(json);
        }
    }

    private static List<String> parseJsonToGetTestRunURLs(String jsonString) throws QTestInvalidFormatException {
        try {
            ArrayList<String> testRuns = new ArrayList<String>();
            JsonArray jarr = new JsonArray(jsonString);
            int i = 0;
            while (i < jarr.length()) {
                JsonArray links = jarr.getJsonObject(i).getJsonArray("links");
                int j = 0;
                while (j < links.length()) {
                    JsonObject link = links.getJsonObject(j);
                    if (link.getString("href") != null) {
                        testRuns.add(link.getString("href"));
                        break;
                    }
                    ++j;
                }
                ++i;
            }
            return testRuns;
        }
        catch (JsonException jsonException) {
            throw QTestInvalidFormatException.createInvalidJsonFormatException(jsonString);
        }
    }

    public static List<QTestDefectField> getDefectFields(IQTestCredential credential, long projectId) throws QTestException {
        ArrayList<QTestDefectField> list = new ArrayList<QTestDefectField>();
        String url = String.valueOf(credential.getServerUrl()) + "/api/v3/projects/" + projectId + "/defects/fields";
        String json = QTestAPIRequestHelper.sendGetRequestViaAPI(url, credential.getToken());
        try {
            JsonArray jArr = new JsonArray(json);
            int i = 0;
            while (i < jArr.length()) {
                JsonObject jo = jArr.getJsonObject(i);
                QTestDefectField field = QTestIntegrationExecutionManager.parseToGetDefectField(jo, new QTestDefectField());
                if (jo.has("allowed_values")) {
                    JsonArray allowedValues = new JsonArray(jo.getString("allowed_values"));
                    int j = 0;
                    while (j < allowedValues.length()) {
                        JsonObject valueObject = allowedValues.getJsonObject(j);
                        QTestDefectField subField = QTestIntegrationExecutionManager.parseToGetDefectField(valueObject, new QTestDefectField());
                        subField.setMainField(field);
                        field.getAllowedValues().add(subField);
                        ++j;
                    }
                }
                list.add(field);
                ++i;
            }
            return list;
        }
        catch (JsonException jsonException) {
            throw QTestInvalidFormatException.createInvalidJsonFormatException(json);
        }
    }

    private static QTestDefectField parseToGetDefectField(JsonObject jo, QTestDefectField field) throws JsonException {
        long id;
        String name = jo.getString("label");
        long l = id = jo.has("id") ? jo.getLong("id") : jo.getLong("value");
        if (field == null) {
            field = new QTestDefectField(id, name);
        } else {
            field.setId(id);
            field.setName(name);
        }
        return field;
    }

    public static List<QTestStepLog> getStepLogs(IQTestCredential credential, long qTestProjectId, long qTestRunId) throws QTestException {
        ArrayList<QTestStepLog> stepLogs = new ArrayList<QTestStepLog>();
        String url = String.format("%s/api/v3/projects/%s/test-runs/%s/test-logs/last-run?expand=teststeplog.teststep", credential.getServerUrl(), qTestProjectId, qTestRunId);
        String response = QTestAPIRequestHelper.sendGetRequestViaAPI(url, credential.getToken());
        try {
            JsonObject jo = new JsonObject(response);
            JsonArray jarrStepLogs = jo.getJsonArray("test_step_logs");
            int i = 0;
            while (i < jarrStepLogs.length()) {
                jo = jarrStepLogs.getJsonObject(i);
                QTestStepLog stepLog = new QTestStepLog();
                stepLog.setqTestStepId(jo.getLong("test_step_id"));
                stepLogs.add(stepLog);
                JsonArray jarrLinks = jo.getJsonArray("links");
                int j = 0;
                while (j < jarrLinks.length()) {
                    String rel = jarrLinks.getJsonObject(j).getString("rel");
                    if (rel.equals("self")) {
                        String href = jarrLinks.getJsonObject(j).getString("href");
                        String strId = href.substring(href.indexOf("/test-steps/") + "/test-steps/".length());
                        stepLog.setId(Long.parseLong(strId));
                        stepLog.setSelfLink(href);
                        break;
                    }
                    ++j;
                }
                ++i;
            }
            return stepLogs;
        }
        catch (JsonException jsonException) {
            throw QTestInvalidFormatException.createInvalidJsonFormatException(response);
        }
    }
}

