/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.integration.qtest.helper;

import com.kms.katalon.core.network.ProxyInformation;
import com.kms.katalon.core.util.internal.ProxyUtil;
import com.kms.katalon.execution.preferences.ProxyPreferences;
import com.kms.katalon.integration.qtest.QTestIntegrationAuthenticationManager;
import com.kms.katalon.integration.qtest.credential.IQTestToken;
import com.kms.katalon.integration.qtest.exception.QTestAPIConnectionException;
import com.kms.katalon.integration.qtest.exception.QTestException;
import com.kms.katalon.integration.qtest.exception.QTestIOException;
import com.kms.katalon.integration.qtest.exception.QTestUnauthorizedException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.commons.io.IOUtils;

public class QTestAPIRequestHelper {
    public static String sendPostOrPutRequestViaAPI(String url, IQTestToken token, String body, String type) throws QTestException {
        String string;
        OutputStream os;
        Reader reader;
        block9: {
            if (!QTestIntegrationAuthenticationManager.validateToken(token.getAccessTokenHeader())) {
                throw new QTestUnauthorizedException("Token is not valid");
            }
            HttpURLConnection con = null;
            reader = null;
            os = null;
            try {
                URL obj = new URL(url);
                con = (HttpURLConnection)obj.openConnection(QTestAPIRequestHelper.getProxy());
                con.setRequestMethod(type);
                con.setRequestProperty("User-Agent", "Mozilla/5.0");
                con.setRequestProperty("Authorization", token.getAccessTokenHeader());
                con.setRequestProperty("Content-Type", "application/json");
                con.setDoOutput(true);
                os = con.getOutputStream();
                os.write(body.getBytes());
                os.flush();
                string = QTestAPIRequestHelper.getResponse(con.getInputStream());
                if (con == null) break block9;
                con.disconnect();
            }
            catch (IOException e) {
                try {
                    if (con != null) {
                        try {
                            throw new QTestAPIConnectionException(con.getResponseCode(), String.valueOf(e.getMessage()) + "\n. Body = [" + body + "]");
                        }
                        catch (IOException ex) {
                            throw new QTestAPIConnectionException(ex.getMessage());
                        }
                    }
                    throw new QTestAPIConnectionException(e.getMessage());
                }
                catch (Throwable throwable) {
                    if (con != null) {
                        con.disconnect();
                    }
                    IOUtils.closeQuietly(reader);
                    IOUtils.closeQuietly(os);
                    throw throwable;
                }
            }
        }
        IOUtils.closeQuietly(reader);
        IOUtils.closeQuietly((OutputStream)os);
        return string;
    }

    public static String sendPostRequestViaAPI(String url, IQTestToken token, String body) throws QTestException {
        return QTestAPIRequestHelper.sendPostOrPutRequestViaAPI(url, token, body, "POST");
    }

    public static String sendGetRequestViaAPI(String url, IQTestToken token) throws QTestException {
        if (!QTestIntegrationAuthenticationManager.validateToken(token.getAccessTokenHeader())) {
            throw new QTestUnauthorizedException("Token is not valid");
        }
        HttpURLConnection con = null;
        Reader in = null;
        try {
            URL obj = new URL(url);
            con = (HttpURLConnection)obj.openConnection(QTestAPIRequestHelper.getProxy());
            con.setRequestMethod("GET");
            con.setRequestProperty("User-Agent", "Mozilla/5.0");
            con.setRequestProperty("Authorization", token.getAccessTokenHeader());
            String string = QTestAPIRequestHelper.getResponse(con.getInputStream());
            return string;
        }
        catch (IOException e) {
            if (con != null) {
                try {
                    throw new QTestAPIConnectionException(con.getResponseCode(), e.getMessage());
                }
                catch (IOException ex) {
                    throw new QTestAPIConnectionException(ex.getMessage());
                }
            }
            throw new QTestAPIConnectionException(e.getMessage());
        }
        finally {
            if (con != null) {
                con.disconnect();
            }
            IOUtils.closeQuietly(in);
        }
    }

    public static String getResponse(InputStream inputStream) throws IOException {
        BufferedReader reader = null;
        try {
            String inputLine;
            reader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
            StringBuffer response = new StringBuffer();
            while ((inputLine = reader.readLine()) != null) {
                response.append(inputLine);
            }
            String string = response.toString();
            return string;
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
    }

    public static Proxy getProxy() throws QTestIOException {
        try {
            return ProxyUtil.getProxy((ProxyInformation)ProxyPreferences.getSystemProxyInformation());
        }
        catch (IOException e) {
            throw new QTestIOException(e);
        }
        catch (URISyntaxException e) {
            throw new QTestIOException(e.getMessage());
        }
    }
}

