/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.integration.qtest.helper;

import com.kms.katalon.core.network.HttpClientProxyBuilder;
import com.kms.katalon.core.network.ProxyInformation;
import com.kms.katalon.core.util.internal.ExceptionsUtil;
import com.kms.katalon.execution.preferences.ProxyPreferences;
import com.kms.katalon.integration.qtest.credential.IQTestCredential;
import com.kms.katalon.integration.qtest.exception.QTestAPIConnectionException;
import com.kms.katalon.integration.qtest.exception.QTestException;
import com.kms.katalon.integration.qtest.exception.QTestIOException;
import com.kms.katalon.integration.qtest.helper.HttpResponseResult;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.qas.api.internal.util.json.JsonException;
import org.qas.api.internal.util.json.JsonObject;

public class QTestHttpRequestHelper {
    private QTestHttpRequestHelper() {
    }

    public static String getV7Token(String serverURL, String username, String password) throws QTestException {
        HttpResponseResult reponseResult = QTestHttpRequestHelper.internallyGetV7Token(serverURL, username, password);
        int statusCode = reponseResult.getStatusLine().getStatusCode();
        if (statusCode == 200) {
            return reponseResult.getResult();
        }
        if (statusCode == 401) {
            try {
                JsonObject jo = new JsonObject(reponseResult.getResult());
                throw new QTestAPIConnectionException(jo.getString("error_description"));
            }
            catch (JsonException jsonException) {
                throw new QTestAPIConnectionException(reponseResult.getResult());
            }
        }
        throw new QTestAPIConnectionException(reponseResult.getResult());
    }

    /*
     * Loose catch block
     */
    private static HttpResponseResult internallyGetV7Token(String serverURL, String username, String password) throws QTestIOException {
        CloseableHttpClient client = null;
        client = HttpClientProxyBuilder.create((ProxyInformation)ProxyPreferences.getSystemProxyInformation()).getClientBuilder().build();
        ArrayList<BasicNameValuePair> postParams = new ArrayList<BasicNameValuePair>();
        postParams.add(new BasicNameValuePair("grant_type", "password"));
        postParams.add(new BasicNameValuePair("username", username));
        postParams.add(new BasicNameValuePair("password", password));
        HttpPost post = new HttpPost(String.valueOf(serverURL) + "/oauth/token");
        String authEncoded = Base64.getEncoder().encodeToString("katalon-user :".getBytes());
        post.setHeader("Authorization", "Basic " + authEncoded);
        post.setHeader("Content-Type", ContentType.APPLICATION_FORM_URLENCODED.toString());
        CloseableHttpResponse response = null;
        HttpResponseResult reponseResult = new HttpResponseResult();
        post.setEntity((HttpEntity)new UrlEncodedFormEntity(postParams));
        response = client.execute((HttpUriRequest)post);
        BufferedReader rd = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
        StringBuffer result = new StringBuffer();
        String line = "";
        while ((line = rd.readLine()) != null) {
            result.append(line);
        }
        reponseResult.setHeaders(response.getAllHeaders());
        reponseResult.setResult(result.toString());
        reponseResult.setStatusLine(response.getStatusLine());
        HttpResponseResult httpResponseResult = reponseResult;
        IOUtils.closeQuietly((Closeable)response);
        IOUtils.closeQuietly((Closeable)client);
        return httpResponseResult;
        {
            catch (IOException ex) {
                try {
                    try {
                        try {
                            throw new QTestIOException(ex);
                        }
                        catch (Throwable throwable) {
                            IOUtils.closeQuietly(response);
                            throw throwable;
                        }
                    }
                    catch (IOException | URISyntaxException | GeneralSecurityException e) {
                        throw new QTestIOException(ExceptionsUtil.getStackTraceForThrowable((Throwable)e));
                    }
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(client);
                    throw throwable;
                }
            }
        }
    }

    public static String sendPostRequest(IQTestCredential credential, String url, List<NameValuePair> postParams) throws QTestException {
        String string;
        CloseableHttpClient client = null;
        try {
            client = HttpClientProxyBuilder.create((ProxyInformation)ProxyPreferences.getSystemProxyInformation()).getClientBuilder().build();
            HashMap<String, String> cookies = new HashMap<String, String>();
            QTestHttpRequestHelper.doLogin(credential, client, cookies);
            String result = QTestHttpRequestHelper.doPost(client, credential.getServerUrl(), url, postParams, cookies).getResult();
            QTestHttpRequestHelper.doLogout(credential, client, cookies);
            string = result;
        }
        catch (IOException | URISyntaxException | GeneralSecurityException e) {
            try {
                throw new QTestIOException(ExceptionsUtil.getStackTraceForThrowable((Throwable)e));
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(client);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)client);
        return string;
    }

    public static String sendGetRequest(IQTestCredential credential, String url) throws QTestException {
        CloseableHttpClient client = null;
        try {
            client = HttpClientBuilder.create().build();
            HashMap<String, String> cookies = new HashMap<String, String>();
            QTestHttpRequestHelper.doLogin(credential, client, cookies);
            String result = QTestHttpRequestHelper.doGet(client, credential.getServerUrl(), url, cookies).getResult();
            QTestHttpRequestHelper.doLogout(credential, client, cookies);
            String string = result;
            return string;
        }
        finally {
            IOUtils.closeQuietly((Closeable)client);
        }
    }

    public static String createDataBody(Map<String, Object> mapProperties, boolean useBrackets) {
        StringBuilder builder = new StringBuilder("[{");
        int index = 0;
        for (Map.Entry<String, Object> entry : mapProperties.entrySet()) {
            if (index > 0) {
                builder.append(",");
            }
            builder.append("\"").append(entry.getKey()).append("\"").append(":");
            String value = String.valueOf(entry.getValue());
            if (entry.getValue() instanceof String) {
                value = "\"" + value + "\"";
            } else if (entry.getValue() instanceof Map) {
                value = QTestHttpRequestHelper.createDataBody((Map)entry.getValue(), useBrackets);
            }
            builder.append(value);
            if (useBrackets) {
                builder.insert(0, "[").append("]");
            }
            ++index;
        }
        builder.append("}]");
        return builder.toString();
    }

    public static void doLogin(IQTestCredential credential, CloseableHttpClient client, Map<String, String> cookies) throws QTestException {
        QTestHttpRequestHelper.doGet(client, credential.getServerUrl(), "/portal/loginform", cookies);
        ArrayList<NameValuePair> postParams = new ArrayList<NameValuePair>();
        postParams.add((NameValuePair)new BasicNameValuePair("j_username", credential.getUsername()));
        postParams.add((NameValuePair)new BasicNameValuePair("j_password", credential.getPassword()));
        QTestHttpRequestHelper.doPost(client, credential.getServerUrl(), "/login?redirect=%2Fportal%2Fproject", postParams, cookies);
        QTestHttpRequestHelper.doGet(client, credential.getServerUrl(), "/portal/project", cookies);
    }

    public static void doLogout(IQTestCredential credential, CloseableHttpClient client, Map<String, String> cookies) throws QTestIOException {
        QTestHttpRequestHelper.doPost(client, credential.getServerUrl(), "/logout", new ArrayList<NameValuePair>(), cookies);
    }

    private static HttpResponseResult doPost(CloseableHttpClient client, String serverUrl, String url, List<NameValuePair> postParams, Map<String, String> cookies) throws QTestIOException {
        HttpResponseResult httpResponseResult;
        HttpPost post = new HttpPost(String.valueOf(serverUrl) + url);
        post.setHeader("Host", serverUrl.replace("http://", "").replace("https://", ""));
        post.setHeader("User-Agent", "Mozilla/5.0");
        post.setHeader("Accept", "text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8");
        post.setHeader("Accept-Language", "en-US,en;q=0.5");
        post.setHeader("Cookie", QTestHttpRequestHelper.cookiesString(cookies));
        post.setHeader("Connection", "keep-alive");
        post.setHeader("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
        post.setHeader("X-CSRF-Token", "0.0");
        HttpResponseResult reponseResult = new HttpResponseResult();
        CloseableHttpResponse response = null;
        try {
            post.setEntity((HttpEntity)new UrlEncodedFormEntity(postParams));
            response = client.execute((HttpUriRequest)post);
            BufferedReader rd = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
            StringBuffer result = new StringBuffer();
            String line = "";
            while ((line = rd.readLine()) != null) {
                result.append(line);
            }
            QTestHttpRequestHelper.addCookies((HttpResponse)response, cookies);
            reponseResult.setHeaders(response.getAllHeaders());
            reponseResult.setResult(result.toString());
            reponseResult.setStatusLine(response.getStatusLine());
            httpResponseResult = reponseResult;
        }
        catch (IOException ex) {
            try {
                throw new QTestIOException(ex);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(response);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)response);
        return httpResponseResult;
    }

    private static HttpResponseResult doGet(CloseableHttpClient client, String serverUrl, String url, Map<String, String> cookies) throws QTestIOException {
        HttpGet request = new HttpGet(String.valueOf(serverUrl) + url);
        request.setHeader("User-Agent", "Mozilla/5.0");
        request.setHeader("Accept", "text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8");
        request.setHeader("Accept-Language", "en-US,en;q=0.5");
        request.setHeader("Cookie", QTestHttpRequestHelper.cookiesString(cookies));
        request.setHeader("Connection", "keep-alive");
        request.setHeader("X-CSRF-Token", "0.0");
        HttpResponseResult reponseResult = new HttpResponseResult();
        CloseableHttpResponse response = null;
        try {
            response = client.execute((HttpUriRequest)request);
            BufferedReader rd = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
            StringBuffer result = new StringBuffer();
            String line = "";
            while ((line = rd.readLine()) != null) {
                result.append(line);
            }
            QTestHttpRequestHelper.addCookies((HttpResponse)response, cookies);
            reponseResult.setHeaders(response.getAllHeaders());
            reponseResult.setResult(result.toString());
            reponseResult.setStatusLine(response.getStatusLine());
            HttpResponseResult httpResponseResult = reponseResult;
            return httpResponseResult;
        }
        catch (IOException ex) {
            throw new QTestIOException(ex);
        }
        finally {
            IOUtils.closeQuietly((Closeable)response);
        }
    }

    private static String cookiesString(Map<String, String> cookies) {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, String> cookie : cookies.entrySet()) {
            builder.append(cookie.getKey()).append("=").append(cookie.getValue()).append(";");
        }
        return builder.toString();
    }

    private static void addCookies(HttpResponse response, Map<String, String> cookies) {
        Header[] headerArray = response.getHeaders("Set-Cookie");
        int n = headerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Header header = headerArray[n2];
            String[] stringArray = header.getValue().trim().split(";");
            int n3 = stringArray.length;
            int n4 = 0;
            while (n4 < n3) {
                String composedValue = stringArray[n4];
                int seperatingIndex = composedValue.indexOf("=");
                if (seperatingIndex == -1) {
                    cookies.put(composedValue, "");
                } else {
                    String name = composedValue.substring(0, seperatingIndex);
                    String value = composedValue.substring(seperatingIndex + 1);
                    cookies.put(name, value);
                }
                ++n4;
            }
            ++n2;
        }
    }
}

