/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.integration.qtest.setting;

import com.kms.katalon.integration.qtest.credential.IQTestCredential;
import com.kms.katalon.integration.qtest.credential.IQTestToken;
import com.kms.katalon.integration.qtest.credential.QTestTokenManager;
import com.kms.katalon.integration.qtest.exception.QTestInvalidFormatException;
import com.kms.katalon.integration.qtest.setting.QTestSettingStore;
import com.kms.katalon.integration.qtest.setting.QTestVersion;

public class QTestSettingCredential
implements IQTestCredential {
    private String fProjectDir;
    private QTestVersion fVersion;

    private QTestSettingCredential(String projectDir) {
        this.setProjectDir(projectDir);
    }

    public static QTestSettingCredential getCredential(String projectDir) {
        return new QTestSettingCredential(projectDir);
    }

    @Override
    public String getServerUrl() {
        return QTestSettingStore.getServerUrl(QTestSettingStore.isEncryptionEnabled(this.fProjectDir), this.fProjectDir);
    }

    @Override
    public String getUsername() {
        return QTestSettingStore.getUsername(QTestSettingStore.isEncryptionEnabled(this.fProjectDir), this.fProjectDir);
    }

    @Override
    public String getPassword() {
        return QTestSettingStore.getPassword(this.isEncryptionEnabled(), this.fProjectDir);
    }

    @Override
    public IQTestToken getToken() {
        try {
            return QTestTokenManager.getToken(QTestSettingStore.getRawToken(this.isEncryptionEnabled(), this.fProjectDir));
        }
        catch (QTestInvalidFormatException qTestInvalidFormatException) {
            return null;
        }
    }

    public String getProjectDir() {
        return this.fProjectDir;
    }

    private void setProjectDir(String fProjectDir) {
        this.fProjectDir = fProjectDir;
    }

    @Override
    public QTestVersion getVersion() {
        if (this.fVersion == null) {
            this.fVersion = QTestSettingStore.getQTestVersion(this.fProjectDir);
        }
        return this.fVersion;
    }

    public void setVersion(QTestVersion version) {
        this.fVersion = version;
    }

    @Override
    public boolean isEncryptionEnabled() {
        return QTestSettingStore.isEncryptionEnabled(this.fProjectDir);
    }
}

