/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.dsl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.eclipse.GroovyLogManager;
import org.codehaus.groovy.eclipse.TraceCategory;
import org.codehaus.groovy.eclipse.dsl.DSLDStore;
import org.codehaus.groovy.eclipse.dsl.GroovyDSLCoreActivator;
import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.SuggestionsLoader;
import org.codehaus.groovy.eclipse.dsl.script.DSLDScriptExecutor;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IParent;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

public class RefreshDSLDJob
extends Job {
    private final List<IProject> projects;

    @Deprecated
    public RefreshDSLDJob(IProject project) {
        this(Collections.singletonList(project));
    }

    @Deprecated
    public RefreshDSLDJob(List<IProject> projects) {
        super("Refresh DSLD scripts");
        this.projects = GroovyDSLCoreActivator.getDefault().getContextStoreManager().addInProgress(projects);
    }

    public boolean belongsTo(Object family) {
        return family == RefreshDSLDJob.class;
    }

    private static boolean isDSLD(IStorage file) {
        return RefreshDSLDJob.isFile(file, "dsld");
    }

    private static boolean isSuggestionFile(IStorage file) {
        return RefreshDSLDJob.isFile(file, "xdsl");
    }

    private static boolean isFile(IStorage file, String extension) {
        if (file instanceof IFile) {
            IFile iFile = (IFile)file;
            return !iFile.isDerived() && extension.equals(iFile.getFileExtension());
        }
        String name = file.getName();
        return name != null && name.endsWith(extension);
    }

    public IStatus run(IProgressMonitor monitor) {
        try {
            if (GroovyDSLCoreActivator.getDefault().isDSLDDisabled()) {
                if (GroovyLogManager.manager.hasLoggers()) {
                    GroovyLogManager.manager.log(TraceCategory.DSL, "DSLD support is currently disabled, so not refreshing DSLDs.");
                }
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            SubMonitor submon = SubMonitor.convert((IProgressMonitor)monitor);
            submon.beginTask("Refresh DSLD scripts", this.projects.size() * 9);
            ArrayList<IStatus> errorStatuses = new ArrayList<IStatus>();
            for (IProject project : this.projects) {
                IStatus res = Status.OK_STATUS;
                try {
                    res = this.refreshProject(project, (IProgressMonitor)submon.split(9));
                }
                finally {
                    GroovyDSLCoreActivator.getDefault().getContextStoreManager().removeInProgress(project);
                }
                if (!res.isOK()) {
                    errorStatuses.add(res);
                    continue;
                }
                if (res != Status.CANCEL_STATUS) continue;
                IStatus iStatus = res;
                return iStatus;
            }
            if (errorStatuses.isEmpty()) {
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            MultiStatus multi = new MultiStatus("org.codehaus.groovy.eclipse.dsl", 0, "Error refreshing DSLDs.", null);
            errorStatuses.forEach(arg_0 -> ((MultiStatus)multi).add(arg_0));
            MultiStatus multiStatus = multi;
            return multiStatus;
        }
        finally {
            this.projects.forEach(GroovyDSLCoreActivator.getDefault().getContextStoreManager()::removeInProgress);
        }
    }

    private IStatus refreshProject(IProject project, IProgressMonitor monitor) {
        String event = null;
        if (GroovyLogManager.manager.hasLoggers()) {
            GroovyLogManager.manager.log(TraceCategory.DSL, "Refreshing inferencing scripts for " + project.getName());
            event = "Refreshing inferencing scripts: " + project.getName();
            GroovyLogManager.manager.logStart(event);
        }
        monitor.beginTask("Refreshing DSLD files for project " + project.getName(), 9);
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        monitor.worked(1);
        if (GroovyLogManager.manager.hasLoggers()) {
            GroovyLogManager.manager.log(TraceCategory.DSL, "Purging old state");
        }
        DSLDStore store = GroovyDSLCoreActivator.getDefault().getContextStoreManager().getDSLDStore(project);
        store.purgeAll();
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        monitor.worked(1);
        if (GroovyLogManager.manager.hasLoggers()) {
            GroovyLogManager.manager.log(TraceCategory.DSL, "Finding inferencing DSL scripts");
        }
        Collection<IStorage> findDSLDFiles = new DSLDResourceVisitor(project).findFiles(monitor);
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        monitor.worked(1);
        for (IStorage file : findDSLDFiles) {
            if (GroovyLogManager.manager.hasLoggers()) {
                GroovyLogManager.manager.log(TraceCategory.DSL, "Processing " + file.getName() + " in project " + project.getName());
            }
            monitor.subTask("Processing " + file.getName() + " in project " + project.getName());
            if (RefreshDSLDJob.isDSLD(file)) {
                DSLDScriptExecutor executor = new DSLDScriptExecutor(JavaCore.create((IProject)project));
                executor.executeScript(file);
            } else if (RefreshDSLDJob.isSuggestionFile(file)) {
                new SuggestionsLoader((IFile)file).loadExistingSuggestions();
            }
            if (!monitor.isCanceled()) continue;
            return Status.CANCEL_STATUS;
        }
        monitor.worked(6);
        if (event != null) {
            GroovyLogManager.manager.logEnd(event, TraceCategory.DSL);
        }
        return Status.OK_STATUS;
    }

    private class DSLDResourceVisitor
    implements IResourceVisitor {
        private final Map<String, IStorage> dsldFiles = new HashMap<String, IStorage>();
        private final IProject project;

        DSLDResourceVisitor(IProject project) {
            this.project = project;
        }

        public boolean visit(IResource resource) throws CoreException {
            IFile file;
            if (resource.isDerived()) {
                return false;
            }
            if (resource.getType() == 1 && (RefreshDSLDJob.isDSLD((IStorage)(file = (IFile)resource)) || RefreshDSLDJob.isSuggestionFile((IStorage)file)) && this.dsldFiles.putIfAbsent(file.getName(), (IStorage)file) != null) {
                GroovyDSLCoreActivator.logWarning("DSLD File " + file.getFullPath() + " already added, so skipping.");
            }
            return true;
        }

        public Collection<IStorage> findFiles(IProgressMonitor monitor) {
            block2: {
                try {
                    this.project.accept((IResourceVisitor)this);
                    this.findDSLDsInLibraries(monitor);
                }
                catch (CoreException e) {
                    if (e.getStatus().getCode() == 368) break block2;
                    GroovyDSLCoreActivator.logException(e);
                }
            }
            return this.dsldFiles.values();
        }

        protected void findDSLDsInLibraries(IProgressMonitor monitor) throws JavaModelException {
            IPackageFragmentRoot[] iPackageFragmentRootArray = this.getPackageFragmentRoots(monitor);
            int n = iPackageFragmentRootArray.length;
            int n2 = 0;
            while (n2 < n) {
                IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                try {
                    if (root.getKind() == 2 || this.isSourceFolderFromOtherProject(root)) {
                        if (root.getElementName().equals("global_dsld_support") || root.getElementName().equals("plugin_dsld_support")) {
                            LinkedList<Object> containers = new LinkedList<Object>();
                            containers.add(root);
                            do {
                                IParent container = (IParent)containers.remove(0);
                                IJavaElement[] iJavaElementArray = container.getChildren();
                                int n3 = iJavaElementArray.length;
                                int n4 = 0;
                                while (n4 < n3) {
                                    IJavaElement child = iJavaElementArray[n4];
                                    if (child instanceof IPackageFragment) {
                                        containers.add((IPackageFragment)child);
                                    }
                                    ++n4;
                                }
                                Object[] resources = container instanceof IPackageFragment ? ((IPackageFragment)container).getNonJavaResources() : ((IPackageFragmentRoot)container).getNonJavaResources();
                                Object[] objectArray = resources;
                                int n5 = resources.length;
                                n3 = 0;
                                while (n3 < n5) {
                                    Object resource = objectArray[n3];
                                    if (resource instanceof IStorage && RefreshDSLDJob.isDSLD((IStorage)resource) && this.dsldFiles.putIfAbsent(((IStorage)resource).getName(), (IStorage)resource) != null) {
                                        GroovyLogManager.manager.log(TraceCategory.DSL, "DSLD file " + ((IStorage)resource).getFullPath() + " already added, so skipping.");
                                    }
                                    ++n3;
                                }
                            } while (!containers.isEmpty());
                        } else if (root.getPackageFragment("dsld").exists()) {
                            IFolder dsldFolder;
                            if (root.getResource() instanceof IFolder && (dsldFolder = ((IFolder)root.getResource()).getFolder("dsld")).exists()) {
                                IResource[] iResourceArray = dsldFolder.members();
                                int n6 = iResourceArray.length;
                                int resources = 0;
                                while (resources < n6) {
                                    IResource resource = iResourceArray[resources];
                                    if (resource.getType() == 1 && RefreshDSLDJob.isDSLD((IStorage)resource) && this.dsldFiles.putIfAbsent(resource.getName(), (IStorage)resource) != null) {
                                        GroovyLogManager.manager.log(TraceCategory.DSL, "DSLD file " + resource.getFullPath() + " already added, so skipping.");
                                    }
                                    ++resources;
                                }
                            } else {
                                Object[] resources;
                                Object[] objectArray = resources = root.getPackageFragment("dsld").getNonJavaResources();
                                int n7 = resources.length;
                                int n8 = 0;
                                while (n8 < n7) {
                                    IStorage file;
                                    Object resource = objectArray[n8];
                                    if (resource instanceof IStorage && RefreshDSLDJob.isDSLD(file = (IStorage)resource) && this.dsldFiles.putIfAbsent(file.getName(), file) != null) {
                                        GroovyLogManager.manager.log(TraceCategory.DSL, "DSLD file " + file.getFullPath() + " already added, so skipping.");
                                    }
                                    ++n8;
                                }
                            }
                        }
                    }
                }
                catch (CoreException e) {
                    switch (e.getStatus().getCode()) {
                        case 969: 
                        case 1006: {
                            break;
                        }
                        default: {
                            GroovyDSLCoreActivator.logException(e);
                        }
                    }
                }
                ++n2;
            }
        }

        private boolean isSourceFolderFromOtherProject(IPackageFragmentRoot root) {
            if (root.isReadOnly()) {
                return false;
            }
            IResource resource = root.getResource();
            if (resource == null) {
                return false;
            }
            return !resource.getProject().equals((Object)this.project);
        }

        private IPackageFragmentRoot[] getPackageFragmentRoots(IProgressMonitor monitor) throws JavaModelException {
            IPackageFragmentRoot[][] roots;
            block2: {
                roots = new IPackageFragmentRoot[1][];
                try {
                    JavaCore.run(pm -> {
                        iPackageFragmentRootArray[0] = JavaCore.create((IProject)this.project).getAllPackageFragmentRoots();
                    }, (ISchedulingRule)this.project, (IProgressMonitor)monitor);
                }
                catch (CoreException e) {
                    if (e.getStatus().getCode() == 969) break block2;
                    GroovyDSLCoreActivator.logException(e);
                }
            }
            return roots[0] != null ? roots[0] : new IPackageFragmentRoot[]{};
        }
    }
}

