/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.dsl.inferencing.suggestions;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.groovy.eclipse.dsl.GroovyDSLCoreActivator;
import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.GroovySuggestionDeclaringType;
import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.IGroovySuggestion;
import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.SuggestionDescriptor;
import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.SuggestionsLoader;
import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.writer.SuggestionsFile;
import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.writer.SuggestionsTransform;
import org.codehaus.jdt.groovy.model.GroovyNature;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class InferencingSuggestionsManager {
    private Map<IProject, ProjectSuggestions> perProjectSuggestions;
    private static InferencingSuggestionsManager manager;
    private IProject lastModifiedProject;

    private InferencingSuggestionsManager() {
    }

    public static InferencingSuggestionsManager getInstance() {
        if (manager == null) {
            manager = new InferencingSuggestionsManager();
        }
        return manager;
    }

    public boolean commitChanges(IProject project) {
        if (!this.isValidProject(project)) {
            return false;
        }
        this.lastModifiedProject = project;
        ProjectSuggestions suggestions = this.getSuggestions(project);
        SuggestionsTransform transform = new SuggestionsTransform(suggestions);
        String result = transform.transform();
        if (result != null) {
            SuggestionsFile suggestionsFile = new SuggestionsFile(project);
            IFile file = suggestionsFile.createFile();
            this.writeToFile(file, result);
            return true;
        }
        return false;
    }

    public boolean restoreSuggestions(IProject project) {
        SuggestionsFile suggestionFile;
        IFile file;
        if (this.isValidProject(project) && (file = (suggestionFile = new SuggestionsFile(project)).getFile()) != null && file.exists()) {
            return new SuggestionsLoader(file).loadExistingSuggestions();
        }
        ProjectSuggestions suggestions = this.getSuggestions(project);
        if (suggestions != null) {
            suggestions.removeAll();
            return true;
        }
        return false;
    }

    public boolean isValidProject(IProject project) {
        return project != null && project.isAccessible() && GroovyNature.hasGroovyNature((IProject)project);
    }

    public IProject getlastModifiedProject() {
        if (this.isValidProject(this.lastModifiedProject)) {
            return this.lastModifiedProject;
        }
        this.lastModifiedProject = null;
        return null;
    }

    protected void writeToFile(IFile file, String value) {
        if (file != null) {
            try {
                file.setContents((InputStream)new ByteArrayInputStream(value.getBytes()), true, true, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                GroovyDSLCoreActivator.logException(e);
            }
        }
    }

    public ProjectSuggestions getSuggestions(IProject project) {
        ProjectSuggestions projectSuggestions;
        if (!this.isValidProject(project)) {
            return null;
        }
        if (this.perProjectSuggestions == null) {
            this.perProjectSuggestions = new HashMap<IProject, ProjectSuggestions>();
        }
        if ((projectSuggestions = this.perProjectSuggestions.get(project)) == null) {
            projectSuggestions = new ProjectSuggestions(project);
            this.perProjectSuggestions.put(project, projectSuggestions);
        }
        return projectSuggestions;
    }

    public class ProjectSuggestions {
        private Map<String, GroovySuggestionDeclaringType> suggestions = new HashMap<String, GroovySuggestionDeclaringType>();
        private IProject project;

        protected ProjectSuggestions(IProject project) {
            this.project = project;
        }

        public ProjectSuggestions registerNewProjectSuggestion() {
            this.suggestions.clear();
            ProjectSuggestions cleanProjectSuggestions = new ProjectSuggestions(this.project);
            InferencingSuggestionsManager.this.perProjectSuggestions.put(this.project, cleanProjectSuggestions);
            return cleanProjectSuggestions;
        }

        public GroovySuggestionDeclaringType getExactDeclaringType(String declaringTypeName) {
            return this.suggestions.get(declaringTypeName);
        }

        public IGroovySuggestion addSuggestion(SuggestionDescriptor descriptor) {
            IGroovySuggestion createdSuggestion;
            String declaringTypeName = descriptor.getDeclaringTypeName();
            GroovySuggestionDeclaringType declaringType = this.suggestions.get(declaringTypeName);
            if (declaringType == null) {
                declaringType = new GroovySuggestionDeclaringType(declaringTypeName);
            }
            if ((createdSuggestion = declaringType.createSuggestion(descriptor)) != null && !this.suggestions.containsKey(declaringType.getName())) {
                this.suggestions.put(declaringTypeName, declaringType);
            }
            return createdSuggestion;
        }

        public void removeDeclaringType(GroovySuggestionDeclaringType declaringType) {
            this.suggestions.remove(declaringType.getName());
        }

        public void removeAll() {
            this.suggestions.clear();
        }

        public Collection<GroovySuggestionDeclaringType> getDeclaringTypes() {
            return this.suggestions.values();
        }
    }
}

