/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.dsl.lookup;

import java.util.List;
import java.util.Set;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MapEntryExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.eclipse.dsl.DSLDStore;
import org.codehaus.groovy.eclipse.dsl.DSLDStoreManager;
import org.codehaus.groovy.eclipse.dsl.DSLPreferences;
import org.codehaus.groovy.eclipse.dsl.GroovyDSLCoreActivator;
import org.codehaus.groovy.eclipse.dsl.contributions.IContributionElement;
import org.codehaus.groovy.eclipse.dsl.lookup.ResolverCache;
import org.codehaus.groovy.eclipse.dsl.pointcuts.GroovyDSLDContext;
import org.codehaus.jdt.groovy.internal.compiler.ast.JDTResolver;
import org.codehaus.jdt.groovy.model.GroovyCompilationUnit;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.groovy.search.AbstractSimplifiedTypeLookup;
import org.eclipse.jdt.groovy.search.ITypeLookup;
import org.eclipse.jdt.groovy.search.ITypeResolver;
import org.eclipse.jdt.groovy.search.TypeLookupResult;
import org.eclipse.jdt.groovy.search.VariableScope;

public class DSLDTypeLookup
extends AbstractSimplifiedTypeLookup
implements ITypeLookup,
ITypeResolver {
    private DSLDStore store;
    private ModuleNode module;
    private JDTResolver resolver;
    private GroovyDSLDContext context;
    private Set<String> disabledScripts;

    public void setResolverInformation(ModuleNode module, JDTResolver resolver) {
        this.module = module;
        this.resolver = resolver;
    }

    public void initialize(GroovyCompilationUnit unit, VariableScope topLevelScope) {
        DSLDStoreManager storeManager = GroovyDSLCoreActivator.getDefault().getContextStoreManager();
        if (!GroovyDSLCoreActivator.getDefault().isDSLDDisabled()) {
            storeManager.ensureInitialized(unit.getJavaProject().getProject(), true);
        }
        this.disabledScripts = DSLPreferences.getDisabledScriptsAsSet();
        try {
            this.context = new GroovyDSLDContext(unit, this.module, this.resolver);
            this.context.setCurrentScope(topLevelScope);
        }
        catch (CoreException e) {
            GroovyDSLCoreActivator.logException(e);
        }
        this.store = storeManager.getDSLDStore(unit.getJavaProject().getProject());
        this.store = this.store.createSubStore(this.context);
    }

    protected AbstractSimplifiedTypeLookup.TypeAndDeclaration lookupTypeAndDeclaration(ClassNode declaringType, String name, VariableScope scope) {
        boolean notMapKey;
        boolean bl = notMapKey = !this.isMapKey(scope);
        if (notMapKey || this.inPointcutExpression(scope)) {
            this.context.setStatic(this.isStatic());
            this.context.setCurrentScope(scope);
            this.context.setTargetType(declaringType);
            List<IContributionElement> contributions = this.store.findContributions(this.context, this.disabledScripts);
            if (notMapKey) {
                declaringType = this.context.getCurrentType();
                ResolverCache resolverCache = this.context.getResolverCache();
                for (IContributionElement contribution : contributions) {
                    AbstractSimplifiedTypeLookup.TypeAndDeclaration td = contribution.resolve(name, declaringType, resolverCache, scope);
                    if (td == null) continue;
                    return td;
                }
            }
        }
        return null;
    }

    public void lookupInBlock(BlockStatement node, VariableScope scope) {
        this.context.setCurrentScope(scope);
        this.context.setPrimaryNode(true);
        this.context.setStatic(scope.isStatic());
        this.context.setTargetType(scope.getDelegateOrThis());
        this.store.findContributions(this.context, this.disabledScripts);
    }

    protected TypeLookupResult.TypeConfidence checkConfidence(Expression node, TypeLookupResult.TypeConfidence confidence, ASTNode declaration, String extraDoc) {
        if (confidence == null) {
            confidence = this.confidence();
        }
        if (declaration instanceof MethodNode && extraDoc != null && extraDoc.contains("Provided by Grails ORM DSL")) {
            confidence = TypeLookupResult.TypeConfidence.LOOSELY_INFERRED;
        }
        return confidence;
    }

    protected TypeLookupResult.TypeConfidence confidence() {
        return TypeLookupResult.TypeConfidence.INFERRED;
    }

    private boolean isMapKey(VariableScope scope) {
        return scope.getCurrentNode() instanceof ConstantExpression && scope.getEnclosingNode() instanceof MapEntryExpression && scope.getCurrentNode() == ((MapEntryExpression)scope.getEnclosingNode()).getKeyExpression();
    }

    private boolean inPointcutExpression(VariableScope scope) {
        return this.context.simpleFileName != null && this.context.simpleFileName.endsWith(".dsld") && (scope.getEnclosingClosure() == null || scope.getAllEnclosingMethodCallExpressions().stream().noneMatch(cat -> cat.call.getMethodAsString().matches("accept|contribute")));
    }
}

