/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.dsl.pointcuts.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.eclipse.dsl.pointcuts.AbstractPointcut;
import org.codehaus.groovy.eclipse.dsl.pointcuts.GroovyDSLDContext;
import org.codehaus.groovy.eclipse.dsl.pointcuts.IPointcut;
import org.codehaus.groovy.eclipse.dsl.pointcuts.PointcutVerificationException;
import org.eclipse.core.resources.IStorage;

public abstract class FilteringPointcut<T>
extends AbstractPointcut {
    protected final Class<T> filterBy;

    public FilteringPointcut(IStorage containerIdentifier, String pointcutName, Class<T> filterBy) {
        super(containerIdentifier, pointcutName);
        this.filterBy = filterBy;
    }

    @Override
    public Collection<?> matches(GroovyDSLDContext pattern, Object toMatch) {
        Collection<T> explodedList = this.explodeObject(toMatch);
        if (explodedList != null && !explodedList.isEmpty()) {
            Object first = this.getFirstArgument();
            if (first instanceof IPointcut) {
                return this.matchOnPointcutArgument((IPointcut)first, pattern, explodedList);
            }
            Collection<?> filtered = this.filterResult(explodedList, pattern);
            if (filtered != null) {
                return filtered;
            }
        }
        return null;
    }

    protected Collection<?> filterResult(Collection<T> results, GroovyDSLDContext context) {
        Object o = this.getFirstArgument();
        String firstArg = this.asString(o);
        ArrayList<T> filtered = new ArrayList<T>(results.size());
        for (T obj : results) {
            T maybe = this.filterObject(obj, context, firstArg);
            if (maybe == null) continue;
            filtered.add(maybe);
        }
        return this.reduce(filtered);
    }

    protected String asString(Object o) {
        if (o instanceof String) {
            return (String)o;
        }
        if (o instanceof Class) {
            return ((Class)o).getName();
        }
        if (o instanceof ClassNode) {
            return ((ClassNode)o).getName();
        }
        if (o instanceof ClassExpression) {
            return ((ClassExpression)o).getType().getName();
        }
        return null;
    }

    protected Collection<T> reduce(Collection<T> filtered) {
        if (filtered == null || filtered.size() == 0) {
            return null;
        }
        return filtered;
    }

    protected abstract T filterObject(T var1, GroovyDSLDContext var2, String var3);

    protected Collection<T> explodeObject(Object toMatch) {
        if (toMatch instanceof Collection) {
            ArrayList objs = new ArrayList();
            for (Object obj : (Collection)toMatch) {
                if (!this.filterBy.isInstance(obj)) continue;
                objs.add(obj);
            }
            if (!objs.isEmpty()) {
                return objs;
            }
        } else if (this.filterBy.isInstance(toMatch)) {
            return Collections.singletonList(toMatch);
        }
        return null;
    }

    @Override
    public void verify() throws PointcutVerificationException {
        String hasNoArgs;
        super.verify();
        String oneStringOrOnePointcutArg = this.oneStringOrOnePointcutOrOneClassArg();
        if (oneStringOrOnePointcutArg != null && (hasNoArgs = this.hasNoArgs()) != null) {
            throw new PointcutVerificationException("This pointcut expects either no arguments or 1 String or 1 pointcut argument", this);
        }
    }
}

