/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.integration.testcloud.configuration;

import com.kms.katalon.constants.GlobalStringConstants;
import com.kms.katalon.core.mobile.driver.MobileDriverType;
import com.kms.katalon.execution.configuration.IDriverConnector;
import com.kms.katalon.execution.configuration.IRunConfiguration;
import com.kms.katalon.execution.constants.ExecutionMessageConstants;
import com.kms.katalon.execution.webui.configuration.RemoteWebRunConfiguration;
import com.kms.katalon.execution.webui.driver.RemoteWebDriverConnector;
import com.kms.katalon.integration.testcloud.driver.TestCloudDriverConnector;
import com.kms.katalon.integration.testcloud.entity.TestCloudEntity;
import com.kms.katalon.integration.testcloud.entity.TestCloudMobileDevice;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public class TestCloudRunConfiguration
extends RemoteWebRunConfiguration {
    private TestCloudDriverConnector testCloudDriverConnector;

    public TestCloudRunConfiguration(String projectDir) throws IOException {
        super(projectDir, (RemoteWebDriverConnector)new TestCloudDriverConnector(projectDir));
        this.testCloudDriverConnector = (TestCloudDriverConnector)this.remoteDriverConnector;
    }

    public String getName() {
        return String.valueOf(GlobalStringConstants.TESTCLOUD_NAME) + " - " + this.testCloudDriverConnector.getTestCloudEntity().getDisplayName();
    }

    public Map<String, IDriverConnector> getDriverConnectors() {
        LinkedHashMap<String, IDriverConnector> driverCollector = new LinkedHashMap<String, IDriverConnector>();
        driverCollector.put("Remote", (IDriverConnector)this.testCloudDriverConnector);
        return driverCollector;
    }

    public void setTestCloudEnvironment(TestCloudEntity environment) {
        if (environment instanceof TestCloudMobileDevice) {
            if ("android".equalsIgnoreCase(environment.getOs())) {
                this.testCloudDriverConnector.setMobileDriverType(MobileDriverType.ANDROID_DRIVER);
            } else {
                this.testCloudDriverConnector.setMobileDriverType(MobileDriverType.IOS_DRIVER);
            }
        }
        this.testCloudDriverConnector.setTestCloudEntity(environment);
    }

    public void setToken(String token) {
        this.testCloudDriverConnector.setToken(token);
    }

    public IRunConfiguration cloneConfig() throws IOException {
        TestCloudRunConfiguration clone = new TestCloudRunConfiguration(this.projectDir);
        clone.testCloudDriverConnector = this.testCloudDriverConnector;
        return clone;
    }

    public String getReportDriverName() {
        return GlobalStringConstants.TESTCLOUD_NAME;
    }

    public Map<String, String> getAdditionalInfo() {
        Map info = super.getAdditionalInfo();
        info.put("isUsingTestCloudTunnel", Boolean.toString(this.testCloudDriverConnector.getTestCloudEntity().isUsingTunnel()));
        info.put(ExecutionMessageConstants.TEST_CLOUD_RUN_CONFIGURATION_KEY, this.getTestCloudRunConfiguration());
        return info;
    }

    public String getTestCloudRunConfiguration() {
        MobileDriverType mobileDriverType = this.getRemoteDriverConnector().getMobileDriverType();
        if (mobileDriverType == null) {
            return "desktop";
        }
        return "mobile";
    }
}

