/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.integration.testcloud.entity;

import com.kms.katalon.integration.testcloud.entity.TestCloudEntity;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class TestCloudMobileDevice
extends TestCloudEntity {
    private String id;
    private boolean isTablet;
    private List<String> manufacturer;
    private String name;
    private String osVersion;
    private String mobileDeviceId;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public boolean isTablet() {
        return this.isTablet;
    }

    public void setTablet(boolean isTablet) {
        this.isTablet = isTablet;
    }

    public List<String> getManufacturer() {
        return this.manufacturer;
    }

    public void setManufacturer(List<String> manufacturer) {
        this.manufacturer = manufacturer;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getOsVersion() {
        return this.osVersion;
    }

    public void setOsVersion(String osVersion) {
        this.osVersion = osVersion;
    }

    private String getBrowserName() {
        return "android".equalsIgnoreCase(this.getOs()) ? "chrome" : "safari";
    }

    private String getDisplayBrowserName() {
        String browserName = this.getBrowserName();
        return String.valueOf(Character.toUpperCase(browserName.charAt(0))) + browserName.substring(1, browserName.length());
    }

    @Override
    public Map<String, Object> toDesireCapabilitiesMap() {
        String browserName = this.getBrowserName();
        LinkedHashMap<String, Object> desiredCapabilities = new LinkedHashMap<String, Object>();
        desiredCapabilities.put("browserName", browserName);
        desiredCapabilities.put("platformName", this.getOs());
        desiredCapabilities.put("browserVersion", "latest");
        desiredCapabilities.put("deviceName", this.getDeviceName());
        desiredCapabilities.put("platformVersion", this.getOsVersion());
        desiredCapabilities.put("deviceId", this.getId());
        HashMap<String, Object> katalonOption = new HashMap<String, Object>();
        katalonOption.put("usingTunnel", this.isUsingTunnel());
        katalonOption.put("deviceId", this.getId());
        katalonOption.put("deviceVersion", this.getOsVersion());
        desiredCapabilities.put("katalon:option", katalonOption);
        return desiredCapabilities;
    }

    @Override
    public Map<String, Object> getSystemPropertiesMap() {
        HashMap<String, Object> systemProperties = new HashMap<String, Object>();
        systemProperties.put("readTimeout", Integer.toString(this.getTimeout()));
        systemProperties.put("testCloudRemoteOS", this.getOs());
        return systemProperties;
    }

    private String getDeviceName() {
        return String.valueOf(this.getManufacturer().get(0)) + ' ' + this.getName();
    }

    @Override
    public String getDisplayName() {
        return String.valueOf(this.getDeviceName()) + ", version=" + this.getOsVersion() + ", " + this.getDisplayBrowserName() + ", Tunnel=" + this.isUsingTunnel();
    }

    @Override
    public boolean isEmpty() {
        return StringUtils.isEmpty((CharSequence)this.getOs()) && StringUtils.isEmpty((CharSequence)this.getOsVersion()) && StringUtils.isEmpty((CharSequence)this.getId());
    }

    public void setMobileDeviceId(String mobileDeviceId) {
        this.mobileDeviceId = mobileDeviceId;
    }

    public String getMobileDeviceId() {
        return this.mobileDeviceId;
    }
}

