/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.integration.testcloud.entity;

import com.kms.katalon.integration.testcloud.entity.TestCloudMobileCapabilitiy;
import com.kms.katalon.integration.testcloud.entity.TestCloudMobileOSVersion;
import com.kms.katalon.integration.testcloud.model.APITestCloudMobileDevice;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;

public class TestCloudMobileOS {
    private String os;
    private List<TestCloudMobileOSVersion> osVersion = new ArrayList<TestCloudMobileOSVersion>();

    public TestCloudMobileOS(APITestCloudMobileDevice environment) {
        this.setOs(environment.getOs());
        this.addOsVersionBasedOnOS(environment);
    }

    public String getOs() {
        return this.os;
    }

    public void setOs(String os) {
        this.os = os;
    }

    public List<TestCloudMobileOSVersion> getOsVersion() {
        return this.osVersion;
    }

    public void setOsVersion(List<TestCloudMobileOSVersion> osVersion) {
        this.osVersion = osVersion;
    }

    public void addOsVersionBasedOnOS(APITestCloudMobileDevice device) {
        for (TestCloudMobileCapabilitiy capabilitiy : device.getCapabilities()) {
            capabilitiy.setOs(device.getOs());
            capabilitiy.setManufacturer(device.getManufacturer());
            capabilitiy.setId(device.getId());
            Optional<TestCloudMobileOSVersion> mappedOSVersion = this.osVersion.stream().filter(e -> e.getOsVersion().equalsIgnoreCase(capabilitiy.getVersion())).findFirst();
            if (mappedOSVersion.isPresent()) {
                mappedOSVersion.get().addDeviceList(capabilitiy);
                continue;
            }
            this.osVersion.add(new TestCloudMobileOSVersion(capabilitiy));
            Collections.sort(this.osVersion, new Comparator<TestCloudMobileOSVersion>(){

                @Override
                public int compare(TestCloudMobileOSVersion os1, TestCloudMobileOSVersion os2) {
                    int major2;
                    String[] v1 = os1.getOsVersion().split("\\.");
                    String[] v2 = os2.getOsVersion().split("\\.");
                    int major1 = this.major(v1);
                    if (major1 == (major2 = this.major(v2))) {
                        int minorCompare = this.minor(v2).compareTo(this.minor(v1));
                        if (minorCompare == 0) {
                            return this.miniMinor(v2).compareTo(this.miniMinor(v1));
                        }
                        return minorCompare;
                    }
                    return major2 > major1 ? 1 : -1;
                }

                private int major(String[] version) {
                    return Integer.parseInt(version[0]);
                }

                private Integer minor(String[] version) {
                    return version.length > 1 ? Integer.parseInt(version[1]) : -1;
                }

                private Integer miniMinor(String[] version) {
                    return version.length > 2 ? Integer.parseInt(version[2]) : -1;
                }
            });
        }
    }
}

