/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.integration.testcloud.provider;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.kms.katalon.integration.testcloud.exception.TestCloudAPIException;
import com.kms.katalon.integration.testcloud.model.APITestCloudConfiguration;
import com.kms.katalon.integration.testcloud.model.UserInfo;
import com.kms.katalon.integration.testcloud.provider.TestCloudService;
import com.kms.katalon.integration.testcloud.util.TestCloudModelParser;
import java.util.Base64;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;

public class TestCloudConfigurationProvider {
    private String token;
    private APITestCloudConfiguration[] testCloudConfigurations;
    private static TestCloudConfigurationProvider instance;

    public TestCloudConfigurationProvider() throws TestCloudAPIException {
        this.fetchToken();
        this.fetchConfigurations(this.token);
    }

    public static TestCloudConfigurationProvider getInstance() throws TestCloudAPIException {
        if (instance == null) {
            instance = new TestCloudConfigurationProvider();
        }
        return instance;
    }

    public String getToken() throws TestCloudAPIException {
        UserInfo userInfo;
        boolean validTokenExpirationDate;
        if (StringUtils.isBlank((CharSequence)this.token)) {
            this.fetchToken();
        }
        if (!(validTokenExpirationDate = (userInfo = this.parseTokenInfo(this.token)).getTokenExpirationDate().after(new Date()))) {
            this.fetchToken();
            this.fetchConfigurations(this.token);
        }
        TestCloudService.getInstance().requestTestCloudToken();
        return this.token;
    }

    private UserInfo parseTokenInfo(String token) {
        String[] chunk = token.split("\\.");
        Base64.Decoder decoder = Base64.getUrlDecoder();
        String payload = new String(decoder.decode(chunk[1]));
        Gson gson = new GsonBuilder().create();
        return (UserInfo)gson.fromJson(payload, UserInfo.class);
    }

    public APITestCloudConfiguration[] getTestCloudConfigurations() throws TestCloudAPIException {
        if (this.testCloudConfigurations == null || this.testCloudConfigurations.length <= 0) {
            this.fetchConfigurations(this.getToken());
        }
        return this.testCloudConfigurations;
    }

    public void setTestCloudConfigurations(APITestCloudConfiguration[] testCloudConfigurations) {
        this.testCloudConfigurations = testCloudConfigurations;
    }

    public int getOSTimeout(String os) throws TestCloudAPIException {
        return TestCloudModelParser.getOSTimeout(this.testCloudConfigurations, os);
    }

    public String getGATrialMessage() {
        return TestCloudModelParser.getGATrialMessageNote(this.testCloudConfigurations);
    }

    private String fetchToken() throws TestCloudAPIException {
        this.token = TestCloudService.getInstance().requestTestCloudToken().getAccessToken();
        return this.token;
    }

    private APITestCloudConfiguration[] fetchConfigurations(String token) throws TestCloudAPIException {
        this.testCloudConfigurations = TestCloudService.getInstance().getConfigurations(token);
        return this.testCloudConfigurations;
    }
}

