/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.integration.testcloud.util;

import com.kms.katalon.integration.testcloud.entity.TestCloudEnvironment;
import com.kms.katalon.integration.testcloud.entity.TestCloudMobileCapabilitiy;
import com.kms.katalon.integration.testcloud.entity.TestCloudMobileDevice;
import com.kms.katalon.integration.testcloud.entity.TestCloudMobileOS;
import com.kms.katalon.integration.testcloud.entity.TestCloudOS;
import com.kms.katalon.integration.testcloud.exception.TestCloudAPIException;
import com.kms.katalon.integration.testcloud.model.APITestCloudConfiguration;
import com.kms.katalon.integration.testcloud.model.APITestCloudEnvironment;
import com.kms.katalon.integration.testcloud.model.APITestCloudMobileDevice;
import com.kms.katalon.integration.testcloud.provider.TestCloudConfigurationProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class TestCloudModelParser {
    private static final int DEFAULT_CONNECT_TIMEOUT_IN_MINUTE = 2;

    public static TestCloudEnvironment parseAPITestCloudEnvironmentToTestCloudBrowser(APITestCloudEnvironment environment) {
        TestCloudEnvironment result = new TestCloudEnvironment();
        result.setId(environment.getId());
        result.setOs(environment.getOs());
        result.setBrowserName(environment.getBrowser());
        result.setBrowserVersion(environment.getBrowserVersion());
        result.setOsDisplayName(environment.getOsDisplayName());
        result.setBrowserDisplayName(environment.getBrowserDisplayName());
        return result;
    }

    public static TestCloudMobileDevice parseAPITestCloudMobileDeviceToTestCloudMobileDevice(TestCloudMobileCapabilitiy mobile) {
        TestCloudMobileDevice result = new TestCloudMobileDevice();
        result.setId(mobile.getId());
        result.setMobileDeviceId(mobile.getDeviceId());
        result.setManufacturer(mobile.getManufacturer());
        result.setOs(mobile.getOs());
        result.setName(mobile.getDeviceName());
        result.setOsVersion(mobile.getVersion());
        result.setManufacturer(mobile.getManufacturer());
        return result;
    }

    public static TestCloudMobileDevice parseAPITestCloudMobileDeviceToTestCloudMobileDevice(APITestCloudMobileDevice mobile, TestCloudMobileCapabilitiy mobileCaps, boolean isUsingTunnel) throws TestCloudAPIException {
        TestCloudMobileDevice result = new TestCloudMobileDevice();
        result.setUsingTunnel(isUsingTunnel);
        result.setOs(mobile.getOs());
        result.setManufacturer(mobile.getManufacturer());
        result.setTablet(mobile.isTablet());
        result.setId(mobile.getId());
        result.setMobileDeviceId(mobileCaps.getDeviceId());
        result.setTimeout(TestCloudConfigurationProvider.getInstance().getOSTimeout(mobile.getOs()));
        result.setOsVersion(mobileCaps.getVersion());
        result.setName(mobileCaps.getDeviceName());
        return result;
    }

    public static List<TestCloudOS> parseArrayAPITestCloudEnvironmentToTestCloudOSList(APITestCloudEnvironment[] environments) {
        ArrayList<TestCloudOS> osList = new ArrayList<TestCloudOS>();
        APITestCloudEnvironment[] aPITestCloudEnvironmentArray = environments;
        int n = environments.length;
        int n2 = 0;
        while (n2 < n) {
            APITestCloudEnvironment environment = aPITestCloudEnvironmentArray[n2];
            Optional<TestCloudOS> mappedOS = osList.stream().filter(e -> e.getOs().equalsIgnoreCase(environment.getOs())).findFirst();
            if (mappedOS.isPresent()) {
                mappedOS.get().addBrowser(environment);
            } else {
                osList.add(new TestCloudOS(environment));
            }
            ++n2;
        }
        return osList;
    }

    public static List<TestCloudMobileOS> parseArrayAPITestCloudMobileDevideToTestMobileDeviceList(APITestCloudMobileDevice[] environments) {
        ArrayList<TestCloudMobileOS> mobileDeviceList = new ArrayList<TestCloudMobileOS>();
        APITestCloudMobileDevice[] aPITestCloudMobileDeviceArray = environments;
        int n = environments.length;
        int n2 = 0;
        while (n2 < n) {
            APITestCloudMobileDevice environment = aPITestCloudMobileDeviceArray[n2];
            if (environment.getOs().equalsIgnoreCase("android") || environment.getOs().equalsIgnoreCase("ios")) {
                Optional<TestCloudMobileOS> mappedOS = mobileDeviceList.stream().filter(e -> e.getOs().equalsIgnoreCase(environment.getOs())).findFirst();
                if (mappedOS.isPresent()) {
                    mappedOS.get().addOsVersionBasedOnOS(environment);
                } else {
                    mobileDeviceList.add(new TestCloudMobileOS(environment));
                }
            }
            ++n2;
        }
        return mobileDeviceList;
    }

    public static int getOSTimeout(APITestCloudConfiguration[] configurations, String os) throws TestCloudAPIException {
        if (configurations == null || configurations.length <= 0) {
            return 2;
        }
        String osTimeoutConfigName = os.concat("NodePreparationTime");
        APITestCloudConfiguration[] aPITestCloudConfigurationArray = configurations;
        int n = configurations.length;
        int n2 = 0;
        while (n2 < n) {
            APITestCloudConfiguration configuration = aPITestCloudConfigurationArray[n2];
            if (configuration.getName().equalsIgnoreCase(osTimeoutConfigName)) {
                int timeout = Integer.valueOf(configuration.getValue());
                return timeout;
            }
            ++n2;
        }
        return 2;
    }

    public static String getGATrialMessageNote(APITestCloudConfiguration[] configurations) {
        if (configurations == null || configurations.length <= 0) {
            return "";
        }
        String noteConfigName = "GATrialMessage";
        APITestCloudConfiguration[] aPITestCloudConfigurationArray = configurations;
        int n = configurations.length;
        int n2 = 0;
        while (n2 < n) {
            APITestCloudConfiguration configuration = aPITestCloudConfigurationArray[n2];
            if (configuration.getName().equalsIgnoreCase(noteConfigName)) {
                String note = configuration.getValue();
                return note;
            }
            ++n2;
        }
        return "";
    }
}

