/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.execution.configuration;

import com.google.gson.Gson;
import com.katalon.platform.api.Plugin;
import com.katalon.platform.api.service.ApplicationManager;
import com.kms.katalon.application.utils.LicenseUtil;
import com.kms.katalon.application.utils.VersionUtil;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.controller.ReportController;
import com.kms.katalon.core.configuration.RunConfiguration;
import com.kms.katalon.core.model.RunningMode;
import com.kms.katalon.core.setting.PropertySettingStoreUtil;
import com.kms.katalon.core.util.ApplicationRunningMode;
import com.kms.katalon.core.util.LogbackUtil;
import com.kms.katalon.custom.improvement.factory.NewPluginTestListenerFactory;
import com.kms.katalon.entity.file.FileEntity;
import com.kms.katalon.entity.file.SystemFileEntity;
import com.kms.katalon.entity.global.ExecutionProfileEntity;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import com.kms.katalon.entity.testsuite.TestSuiteEntity;
import com.kms.katalon.execution.collector.ExecutionPropertiesCollector;
import com.kms.katalon.execution.configuration.IDriverConnector;
import com.kms.katalon.execution.configuration.IExecutionSetting;
import com.kms.katalon.execution.configuration.IHostConfiguration;
import com.kms.katalon.execution.configuration.IRunConfiguration;
import com.kms.katalon.execution.configuration.impl.DefaultExecutionSetting;
import com.kms.katalon.execution.configuration.impl.LocalHostConfiguration;
import com.kms.katalon.execution.constants.StringConstants;
import com.kms.katalon.execution.entity.DefaultRerunSetting;
import com.kms.katalon.execution.entity.IExecutedEntity;
import com.kms.katalon.execution.entity.TestCaseBindingExecutedEntity;
import com.kms.katalon.execution.entity.TestCaseExecutedEntity;
import com.kms.katalon.execution.entity.TestSuiteExecutedEntity;
import com.kms.katalon.execution.exception.ExecutionException;
import com.kms.katalon.execution.generator.FeatureFileScriptGenerator;
import com.kms.katalon.execution.generator.TestCaseBindingScriptGenerator;
import com.kms.katalon.execution.generator.TestCaseScriptGenerator;
import com.kms.katalon.execution.generator.TestSuiteScriptGenerator;
import com.kms.katalon.execution.session.ExecutionSessionSocketServer;
import com.kms.katalon.execution.util.ExecutionUtil;
import com.kms.katalon.feature.FeatureServiceConsumer;
import com.kms.katalon.feature.IFeatureService;
import com.kms.katalon.feature.KSEFeature;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.runtime.Platform;

public abstract class AbstractRunConfiguration
implements IRunConfiguration {
    protected IHostConfiguration hostConfiguration;
    protected DefaultExecutionSetting executionSetting;
    private ExecutionProfileEntity executionProfile;
    private Map<String, Object> overridingParameters = new HashMap<String, Object>();
    private Map<String, String> environmentVariables = new HashMap<String, String>();
    private List<String> vmArgs = new ArrayList<String>();
    private Map<String, String> additionalData = new HashMap<String, String>();
    private Map<String, String> additionalInfo = new HashMap<String, String>();
    private String executionUUID;
    private String executionSessionId;
    private boolean isDebugLaunchMode = false;
    private IFeatureService featureService = FeatureServiceConsumer.getServiceInstance();

    public AbstractRunConfiguration() {
        this.doInitExecutionSetting();
        this.initVmArguments();
    }

    protected void doInitExecutionSetting() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd_HHmmss");
        this.executionSessionId = dateFormat.format(new Date());
        this.initExecutionSetting();
    }

    protected void initVmArguments() {
        if (this.featureService.canUse(KSEFeature.LAUNCH_ARGUMENTS_SETTINGS)) {
            this.vmArgs.addAll(Arrays.asList(ExecutionUtil.getVmArgs()));
        }
    }

    @Override
    public final IExecutionSetting build(FileEntity fileEntity, IExecutedEntity executedEntity) throws IOException, ExecutionException {
        this.init(fileEntity);
        this.executionSetting.setExecutedEntity(executedEntity);
        this.hostConfiguration = new LocalHostConfiguration();
        this.generateLogFolder(fileEntity);
        File scriptFile = this.generateTempScriptFile(fileEntity);
        this.generateExecutionProperties();
        this.executionSetting.setScriptFile(scriptFile);
        return this.executionSetting;
    }

    protected File generateTempScriptFile(FileEntity fileEntity) throws ExecutionException {
        try {
            if (fileEntity instanceof TestSuiteEntity) {
                String retryFailedExecutionsTcBindings;
                TestSuiteExecutedEntity t = (TestSuiteExecutedEntity)this.getExecutionSetting().getExecutedEntity();
                if (this.shouldRetryFailedExecutionsOnly(t, retryFailedExecutionsTcBindings = this.additionalData.getOrDefault("retryFailedExecutionsOnlyTcBinding", ""))) {
                    return this.generateTempScriptFileWithCustomRetry(fileEntity, retryFailedExecutionsTcBindings);
                }
                return this.generateTempScriptFileWithDefaultRetry(fileEntity);
            }
            if (fileEntity instanceof TestCaseEntity) {
                TestCaseEntity testCase = (TestCaseEntity)fileEntity;
                if (this.getExecutionSetting().getExecutedEntity() instanceof TestCaseExecutedEntity) {
                    return new TestCaseScriptGenerator(testCase, this).generateScriptFile();
                }
                TestCaseBindingExecutedEntity executedEntity = (TestCaseBindingExecutedEntity)this.getExecutionSetting().getExecutedEntity();
                return new TestCaseBindingScriptGenerator(testCase, this, executedEntity).generateScriptFile();
            }
            if (fileEntity instanceof SystemFileEntity) {
                return new FeatureFileScriptGenerator((SystemFileEntity)fileEntity, this).generateScriptFile();
            }
            throw new ExecutionException("The execution is not supported for this file");
        }
        catch (Exception ex) {
            throw new ExecutionException(ex);
        }
    }

    private File generateTempScriptFileWithDefaultRetry(FileEntity fileEntity) throws Exception {
        return new TestSuiteScriptGenerator((TestSuiteEntity)fileEntity, this, (TestSuiteExecutedEntity)this.getExecutionSetting().getExecutedEntity()).generateScriptFile();
    }

    private File generateTempScriptFileWithCustomRetry(FileEntity fileEntity, String retryImmediatelyTcBindings) throws Exception {
        return new TestSuiteScriptGenerator((TestSuiteEntity)fileEntity, this, (TestSuiteExecutedEntity)this.getExecutionSetting().getExecutedEntity()).generateScriptFile(retryImmediatelyTcBindings);
    }

    private boolean shouldRetryFailedExecutionsOnly(TestSuiteExecutedEntity t, String retryFailedExecutionsTcBindings) {
        return DefaultRerunSetting.RetryStrategyValue.FAILED_EXECUTIONS.equals((Object)t.getRetryStrategy()) && !"".equals(retryFailedExecutionsTcBindings);
    }

    protected void init(FileEntity fileEntity) throws IOException {
        if (fileEntity == null) {
            return;
        }
        int timeOut = fileEntity instanceof TestSuiteEntity && !((TestSuiteEntity)fileEntity).isPageLoadTimeoutDefault() ? (int)((TestSuiteEntity)fileEntity).getPageLoadTimeout().shortValue() : ExecutionUtil.getDefaultImplicitTimeout();
        this.executionSetting.setTimeout(timeOut);
    }

    protected void initExecutionSetting() {
        this.executionSetting = new DefaultExecutionSetting();
    }

    protected String getTemporaryLogFolderLocation(FileEntity testCase) {
        try {
            return ReportController.getInstance().generateTemporaryExecutionFolder(testCase);
        }
        catch (Exception exception) {
            return "";
        }
    }

    protected String getLogFolderLocation(TestSuiteEntity testSuite) {
        try {
            return ReportController.getInstance().generateReportFolder(testSuite, this.executionSessionId);
        }
        catch (Exception exception) {
            return "";
        }
    }

    public void generateLogFolder(FileEntity fileEntity) {
        String logFolderPath = "";
        if (fileEntity instanceof TestCaseEntity || fileEntity instanceof SystemFileEntity) {
            logFolderPath = this.getTemporaryLogFolderLocation(fileEntity);
        } else if (fileEntity instanceof TestSuiteEntity) {
            logFolderPath = this.getLogFolderLocation((TestSuiteEntity)fileEntity);
        }
        this.executionSetting.setFolderPath(logFolderPath);
    }

    @Override
    public String getProjectFolderLocation() {
        return ProjectController.getInstance().getCurrentProject().getFolderLocation().replace(File.separator, "/");
    }

    @Override
    public Map<String, Object> getProperties() {
        LinkedHashMap<String, Object> propertyMap = new LinkedHashMap<String, Object>();
        boolean restrictCustomKeywords = LicenseUtil.isFreeLicense() && ApplicationRunningMode.get() == RunningMode.GUI;
        propertyMap.put("restrictCustomKeywords", restrictCustomKeywords);
        propertyMap.put(StringConstants.NAME, this.getName());
        propertyMap.put("projectDir", this.getProjectFolderLocation());
        propertyMap.put("host", this.hostConfiguration.getProperties());
        if (this.executionSetting == null) {
            return propertyMap;
        }
        propertyMap.putAll(ExecutionUtil.getExecutionProperties(this.executionSetting, this.getDriverConnectors(), this.executionProfile));
        IExecutedEntity executedEntity = this.executionSetting.getExecutedEntity();
        if (executedEntity == null) {
            return propertyMap;
        }
        if (!this.overridingParameters.isEmpty()) {
            propertyMap.put("overridingGlobalVariables", this.overridingParameters);
        }
        propertyMap.put("id", executedEntity.getSourceId());
        propertyMap.put("name", executedEntity.getSourceName());
        propertyMap.put("description", executedEntity.getSourceDescription());
        propertyMap.put("source", executedEntity.getSourcePath());
        ExecutionSessionSocketServer sessionServer = ExecutionSessionSocketServer.getInstance();
        propertyMap.put("sessionServer.host", sessionServer.getServerHost());
        propertyMap.put("sessionServer.port", sessionServer.getServerPort());
        propertyMap.put("isDebugLaunchMode", this.isDebugLaunchMode);
        this.additionalInfo.forEach((key, value) -> propertyMap.put((String)key, value));
        String logbackConfigFileLocation = this.getLogbackConfigFileLocation();
        if (logbackConfigFileLocation != null) {
            propertyMap.put("logbackConfigFileLocation", logbackConfigFileLocation);
        }
        propertyMap.put("katalon.versionNumber", VersionUtil.getCurrentVersion().getVersion());
        propertyMap.put("katalon.buildNumber", String.valueOf(VersionUtil.getCurrentVersion().getBuildNumber()));
        propertyMap.put("runningMode", ApplicationRunningMode.get().name());
        propertyMap.put("pluginTestListeners", NewPluginTestListenerFactory.getInstance().getListeners());
        propertyMap.put("allowUsingSelfHealing", this.featureService.canUse(KSEFeature.SELF_HEALING));
        propertyMap.put("allowUsingTimeCapsule", true);
        propertyMap.put("allowCustomizeRequestTimeout", this.featureService.canUse(KSEFeature.CUSTOM_WEB_SERVICE_REQUEST_TIMEOUT));
        propertyMap.put("allowCustomizeRequestResponseSizeLimit", this.featureService.canUse(KSEFeature.CUSTOM_WEB_SERVICE_RESPONSE_SIZE_LIMIT));
        propertyMap.put("maxFailedTests", executedEntity.getFailedThreshold());
        propertyMap.put("appiumDirectory", RunConfiguration.getInstance().getAppiumDirectoryDefinedWithArgument());
        AbstractRunConfiguration.setHttpsProtocol(propertyMap);
        ExecutionPropertiesCollector.getInstance().getPropertiesContributors().forEach(contributor -> propertyMap.put(contributor.getKey(), contributor.getExecutionProperties()));
        return propertyMap;
    }

    public static void setHttpsProtocol(Map<String, Object> propertyMap) {
        try {
            String path = new URL(Platform.getInstallLocation().getURL() + "katalon.ini").getPath();
            String protocol = PropertySettingStoreUtil.getSettings((String)path).getProperty("-https.protocol");
            if (protocol != null) {
                propertyMap.put("httpsProtocol", protocol);
            }
        }
        catch (IOException iOException) {}
    }

    private boolean initializePluginPresence(String pluginID, Map<String, Object> propertyMap) {
        Plugin plugin = ApplicationManager.getInstance().getPluginManager().getPlugin(pluginID);
        if (plugin != null) {
            propertyMap.put(pluginID, true);
            return true;
        }
        return false;
    }

    private String getLogbackConfigFileLocation() {
        String logbackConfigFileLocation = null;
        try {
            File logbackConfigFile = LogbackUtil.getLogbackConfigFile();
            if (logbackConfigFile != null && logbackConfigFile.exists()) {
                logbackConfigFileLocation = logbackConfigFile.getAbsolutePath();
            }
        }
        catch (IOException iOException) {}
        return logbackConfigFileLocation;
    }

    @Override
    public String getName() {
        StringBuilder nameStringBuilder = new StringBuilder();
        boolean isFirst = true;
        for (IDriverConnector driverConnector : this.getDriverConnectors().values()) {
            if (!isFirst) {
                nameStringBuilder.append(" + ");
            }
            nameStringBuilder.append(driverConnector.getDriverType().toString());
            isFirst = false;
        }
        return nameStringBuilder.toString();
    }

    @Override
    public String getReportDriverName() {
        return this.getName();
    }

    @Override
    public IHostConfiguration getHostConfiguration() {
        return this.hostConfiguration;
    }

    @Override
    public IExecutionSetting getExecutionSetting() {
        return this.executionSetting;
    }

    @Override
    public final void generateExecutionProperties() throws IOException {
        File settingFile = new File(this.executionSetting.getSettingFilePath());
        Gson gsonObj = new Gson();
        String strJson = gsonObj.toJson(this.getProperties());
        FileUtils.writeStringToFile((File)settingFile, (String)strJson);
    }

    @Override
    public Map<String, String> getAdditionalEnvironmentVariables() throws IOException, ExecutionException {
        return Collections.unmodifiableMap(this.environmentVariables);
    }

    @Override
    public boolean allowsRecording() {
        return false;
    }

    @Override
    public ExecutionProfileEntity getExecutionProfile() {
        return this.executionProfile;
    }

    public void setExecutionProfile(ExecutionProfileEntity executionProfile) {
        this.executionProfile = executionProfile;
    }

    @Override
    public void setOverridingGlobalVariables(Map<String, Object> overridingGlobalVariables) {
        if (overridingGlobalVariables == null) {
            return;
        }
        this.overridingParameters.putAll(overridingGlobalVariables);
    }

    @Override
    public Map<String, Object> getOverridingGlobalVariables() {
        return this.overridingParameters;
    }

    @Override
    public Map<String, String> getTestSuiteAdditionalData() {
        return Collections.unmodifiableMap(this.additionalData);
    }

    @Override
    public void setTestSuiteAdditionalData(Map<String, String> data) {
        if (data != null) {
            this.additionalData.putAll(data);
        }
    }

    @Override
    public String[] getVmArgs() {
        return this.vmArgs.toArray(new String[0]);
    }

    @Override
    public void setVmArgs(String[] args) {
        if (args == null) {
            return;
        }
        this.vmArgs.addAll(Arrays.asList(args));
    }

    @Override
    public void setAdditionalEnvironmentVariables(Map<String, String> addtionalEnv) {
        if (addtionalEnv != null) {
            this.environmentVariables.putAll(addtionalEnv);
        }
    }

    @Override
    public String getExecutionUUID() {
        return this.executionUUID;
    }

    @Override
    public void setExecutionUUID(String executionUUID) {
        this.executionUUID = executionUUID;
    }

    @Override
    public String getExecutionSessionId() {
        return this.executionSessionId;
    }

    @Override
    public void setExecutionSessionId(String executionSessionId) {
        this.executionSessionId = executionSessionId;
    }

    @Override
    public void setAdditionalInfo(Map<String, String> data) {
        if (data != null) {
            this.additionalInfo.putAll(data);
        }
    }

    @Override
    public Map<String, String> getAdditionalInfo() {
        return this.additionalInfo;
    }

    public void setFailedTestThreshold(int value) {
        IExecutedEntity executedEntity = this.executionSetting.getExecutedEntity();
        if (executedEntity instanceof TestSuiteExecutedEntity) {
            TestSuiteExecutedEntity testSuiteEntity = (TestSuiteExecutedEntity)executedEntity;
            testSuiteEntity.setFailedThreshold(value);
        }
    }

    public void setDebugLaunchMode(boolean isDebugMode) {
        this.isDebugLaunchMode = isDebugMode;
    }
}

