/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.execution.entity;

import com.kms.katalon.execution.console.entity.BooleanConsoleOption;
import com.kms.katalon.execution.console.entity.ConsoleOption;
import com.kms.katalon.execution.console.entity.ConsoleOptionContributor;
import com.kms.katalon.execution.console.entity.IntegerConsoleOption;
import com.kms.katalon.execution.console.entity.StringConsoleOption;
import com.kms.katalon.execution.entity.Rerunable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class DefaultRerunSetting
implements Rerunable,
ConsoleOptionContributor {
    public static final int DEFAULT_RERUN_TIME = 0;
    private static final int DEFAULT_PREVIOUS_RUN_TIME = 0;
    public static final boolean DEFAULT_RERUN_FAILED_TEST_CASE_ONLY = false;
    public static final boolean DEFAULT_RERUN_FAILED_TEST_CASE_TEST_DATA_ONLY = false;
    public static final boolean DEFAULT_RERUN_IMMEDIATELY = false;
    public static final String RETRY_OPTION = "retry";
    public static final String RETRY_FAIL_TEST_CASE_ONLY_OPTION = "retryFailedTestCases";
    public static final String RETRY_FAIL_TEST_CASE_TEST_DATA_ONLY_OPTION = "retryFailedTestCasesTestData";
    public static final String RETRY_STRATEGY = "retryStrategy";
    private int previousRerunTimes;
    private int remainingRerunTimes;
    private boolean rerunFailedTestCaseOnly;
    private boolean rerunFailedTestCaseWithTestDataOnly;
    private boolean rerunImmediately;
    private boolean overrideRerunFailedTestCaseOnly;
    private boolean overrideRerunFailedTestCaseWithTestDataOnly;
    private boolean overrideRerunImmediately;
    private boolean overrideRemainingRerunTimes;
    public static final IntegerConsoleOption RETRY_CONSOLE_OPTION = new IntegerConsoleOption(){

        @Override
        public String getOption() {
            return DefaultRerunSetting.RETRY_OPTION;
        }

        @Override
        public String getDefaultArgumentValue() {
            return String.valueOf(0);
        }
    };
    public static final BooleanConsoleOption LEGACY_RERUN_FAIL_TEST_CASE_ONLY_CONSOLE_OPTION = new BooleanConsoleOption(){

        @Override
        public String getOption() {
            return DefaultRerunSetting.RETRY_FAIL_TEST_CASE_ONLY_OPTION;
        }
    };
    public static final BooleanConsoleOption LEGACY_RERUN_FAIL_TEST_CASE__TEST_DATA_ONLY_CONSOLE_OPTION = new BooleanConsoleOption(){

        @Override
        public String getOption() {
            return DefaultRerunSetting.RETRY_FAIL_TEST_CASE_TEST_DATA_ONLY_OPTION;
        }
    };
    public static final StringConsoleOption RERUN_STRATEGY_CONSOLE_OPTION = new StringConsoleOption(){

        @Override
        public String getOption() {
            return DefaultRerunSetting.RETRY_STRATEGY;
        }
    };

    public DefaultRerunSetting() {
        this(0, false);
    }

    public DefaultRerunSetting(DefaultRerunSetting defaultRerunSetting) {
        this.setPreviousRerunTimes(defaultRerunSetting.getPreviousRerunTimes());
        this.setRemainingRerunTimes(defaultRerunSetting.getRemainingRerunTimes());
        this.setRerunFailedTestCaseOnly(defaultRerunSetting.isRerunFailedTestCasesOnly());
        this.setRerunImmediately(defaultRerunSetting.isRerunImmediately());
        this.setRerunFailedTestCaseAndTestDataOnly(defaultRerunSetting.isRerunFailedTestCasesAndTestDataOnly());
        this.setOverrideRemainingRerunTimes(defaultRerunSetting.isOverrideRemainingRerunTimes());
        this.setOverrideRerunFailedTestCaseOnly(defaultRerunSetting.isOverrideRerunFailedTestCaseOnly());
        this.setOverrideRerunFailedTestCaseWithTestDataOnly(defaultRerunSetting.isOverrideRerunFailedTestCaseWithTestDataOnly());
        this.setOverrideRerunImmediately(defaultRerunSetting.isOverrideRerunImmediately());
    }

    public DefaultRerunSetting(int remainingRerunTime, boolean rerunFailedTestCaseOnly) {
        this(0, remainingRerunTime, rerunFailedTestCaseOnly);
    }

    public DefaultRerunSetting(int previousRerunTimes, int remainingRerunTime, boolean rerunFailedTestCaseOnly) {
        this(previousRerunTimes, remainingRerunTime, rerunFailedTestCaseOnly, false);
    }

    public DefaultRerunSetting(int previousRerunTimes, int remainingRerunTime, boolean rerunFailedTestCasesOnly, boolean rerunImmediately) {
        this.setPreviousRerunTimes(previousRerunTimes);
        this.setRemainingRerunTimes(remainingRerunTime);
        this.setRerunFailedTestCaseOnly(rerunFailedTestCasesOnly);
        this.setRerunImmediately(rerunImmediately);
    }

    @Override
    public boolean isRerunFailedTestCasesOnly() {
        return this.rerunFailedTestCaseOnly;
    }

    public void setRerunFailedTestCaseOnly(boolean rerunFailedTestCaseOnly) {
        this.rerunFailedTestCaseOnly = rerunFailedTestCaseOnly;
    }

    @Override
    public int getPreviousRerunTimes() {
        return this.previousRerunTimes;
    }

    @Override
    public int getRemainingRerunTimes() {
        return this.remainingRerunTimes;
    }

    public void setPreviousRerunTimes(int previousRerunTimes) {
        this.previousRerunTimes = previousRerunTimes;
    }

    public void setRemainingRerunTimes(int remainingRerunTimes) {
        this.remainingRerunTimes = remainingRerunTimes;
    }

    @Override
    public List<ConsoleOption<?>> getConsoleOptionList() {
        ArrayList consoleOptionList = new ArrayList();
        consoleOptionList.add(RETRY_CONSOLE_OPTION);
        consoleOptionList.add(LEGACY_RERUN_FAIL_TEST_CASE_ONLY_CONSOLE_OPTION);
        consoleOptionList.add(LEGACY_RERUN_FAIL_TEST_CASE__TEST_DATA_ONLY_CONSOLE_OPTION);
        consoleOptionList.add(RERUN_STRATEGY_CONSOLE_OPTION);
        return consoleOptionList;
    }

    @Override
    public void setArgumentValue(ConsoleOption<?> consoleOption, String argumentValue) throws Exception {
        if (StringUtils.isBlank((String)argumentValue)) {
            return;
        }
        if (consoleOption == RETRY_CONSOLE_OPTION) {
            this.setRemainingRerunTimes(Integer.valueOf(argumentValue));
            this.overrideRemainingRerunTimes = true;
        } else if (consoleOption == LEGACY_RERUN_FAIL_TEST_CASE_ONLY_CONSOLE_OPTION) {
            this.setRerunFailedTestCaseOnly(Boolean.valueOf(argumentValue));
            this.overrideRerunFailedTestCaseOnly = true;
            this.setRerunImmediately(false);
            this.overrideRerunImmediately = true;
        } else if (consoleOption == LEGACY_RERUN_FAIL_TEST_CASE__TEST_DATA_ONLY_CONSOLE_OPTION) {
            this.setRerunFailedTestCaseAndTestDataOnly(Boolean.valueOf(argumentValue));
            this.overrideRerunFailedTestCaseWithTestDataOnly = true;
            this.setRerunImmediately(false);
            this.overrideRerunImmediately = true;
        } else if (consoleOption == RERUN_STRATEGY_CONSOLE_OPTION) {
            RetryStrategyValue strategyValue = RetryStrategyValue.getEnum(argumentValue);
            this.resetAllLegacyRetrySettings();
            switch (strategyValue) {
                case IMMEDIATELY: {
                    this.setRerunFailedTestCaseOnly(false);
                    this.overrideRerunFailedTestCaseOnly = true;
                    this.setRerunFailedTestCaseAndTestDataOnly(false);
                    this.overrideRerunFailedTestCaseWithTestDataOnly = true;
                    this.setRerunImmediately(true);
                    this.overrideRerunImmediately = true;
                    break;
                }
                case FAILED_EXECUTIONS: {
                    this.setRerunFailedTestCaseOnly(true);
                    this.overrideRerunFailedTestCaseOnly = true;
                    this.setRerunFailedTestCaseAndTestDataOnly(true);
                    this.overrideRerunFailedTestCaseWithTestDataOnly = true;
                    this.setRerunImmediately(false);
                    this.overrideRerunImmediately = true;
                    break;
                }
                case ALL_EXECUTIONS: {
                    this.setRerunFailedTestCaseOnly(false);
                    this.overrideRerunFailedTestCaseOnly = true;
                    this.setRerunFailedTestCaseAndTestDataOnly(false);
                    this.overrideRerunFailedTestCaseWithTestDataOnly = true;
                    this.setRerunImmediately(false);
                    this.overrideRerunImmediately = true;
                    break;
                }
            }
        }
    }

    private void resetAllLegacyRetrySettings() {
        this.setRerunImmediately(false);
        this.overrideRerunImmediately = false;
        this.setRerunFailedTestCaseOnly(false);
        this.overrideRerunFailedTestCaseOnly = false;
        this.setRerunFailedTestCaseAndTestDataOnly(false);
        this.overrideRerunFailedTestCaseWithTestDataOnly = false;
    }

    @Override
    public Rerunable mergeWith(Rerunable rerunable) {
        if (rerunable == null) {
            return this;
        }
        if (!this.overrideRemainingRerunTimes) {
            this.setRemainingRerunTimes(rerunable.getRemainingRerunTimes());
        }
        if (!this.overrideRerunFailedTestCaseOnly) {
            this.setRerunFailedTestCaseOnly(rerunable.isRerunFailedTestCasesOnly());
        }
        if (!this.overrideRerunFailedTestCaseWithTestDataOnly) {
            this.setRerunFailedTestCaseAndTestDataOnly(rerunable.isRerunFailedTestCasesAndTestDataOnly());
        }
        if (!this.overrideRerunImmediately) {
            this.setRerunImmediately(rerunable.isRerunImmediately());
        }
        return this;
    }

    public void setRerunFailedTestCaseAndTestDataOnly(boolean val) {
        this.rerunFailedTestCaseWithTestDataOnly = val;
    }

    @Override
    public boolean isRerunFailedTestCasesAndTestDataOnly() {
        return this.rerunFailedTestCaseWithTestDataOnly;
    }

    @Override
    public boolean isRerunImmediately() {
        return this.rerunImmediately;
    }

    public void setRerunImmediately(boolean val) {
        this.rerunImmediately = val;
    }

    public boolean isOverrideRerunFailedTestCaseOnly() {
        return this.overrideRerunFailedTestCaseOnly;
    }

    public void setOverrideRerunFailedTestCaseOnly(boolean overrideRerunFailedTestCaseOnly) {
        this.overrideRerunFailedTestCaseOnly = overrideRerunFailedTestCaseOnly;
    }

    public boolean isOverrideRerunFailedTestCaseWithTestDataOnly() {
        return this.overrideRerunFailedTestCaseWithTestDataOnly;
    }

    public void setOverrideRerunFailedTestCaseWithTestDataOnly(boolean overrideRerunFailedTestCaseWithTestDataOnly) {
        this.overrideRerunFailedTestCaseWithTestDataOnly = overrideRerunFailedTestCaseWithTestDataOnly;
    }

    public boolean isOverrideRerunImmediately() {
        return this.overrideRerunImmediately;
    }

    public void setOverrideRerunImmediately(boolean overrideRerunImmediately) {
        this.overrideRerunImmediately = overrideRerunImmediately;
    }

    public boolean isOverrideRemainingRerunTimes() {
        return this.overrideRemainingRerunTimes;
    }

    public void setOverrideRemainingRerunTimes(boolean overrideRemainingRerunTimes) {
        this.overrideRemainingRerunTimes = overrideRemainingRerunTimes;
    }

    public static enum RetryStrategyValue {
        IMMEDIATELY,
        ALL_EXECUTIONS,
        FAILED_EXECUTIONS;

        private static final String FAILED_EXECUTIONS_CONSOLE_ARG = "failedExecutions";
        private static final String ALL_EXECUTIONS_CONSOLE_ARG = "allExecutions";
        private static final String IMMEDIATELY_CONSOLE_ARG = "immediately";

        public static RetryStrategyValue getEnum(String value) {
            if (IMMEDIATELY_CONSOLE_ARG.equals(value)) {
                return IMMEDIATELY;
            }
            if (ALL_EXECUTIONS_CONSOLE_ARG.equals(value)) {
                return ALL_EXECUTIONS;
            }
            if (FAILED_EXECUTIONS_CONSOLE_ARG.equals(value)) {
                return FAILED_EXECUTIONS;
            }
            return ALL_EXECUTIONS;
        }

        public String getUserFacingValue() {
            if (this.equals((Object)IMMEDIATELY)) {
                return IMMEDIATELY_CONSOLE_ARG;
            }
            if (this.equals((Object)ALL_EXECUTIONS)) {
                return ALL_EXECUTIONS_CONSOLE_ARG;
            }
            if (this.equals((Object)FAILED_EXECUTIONS)) {
                return FAILED_EXECUTIONS_CONSOLE_ARG;
            }
            return ALL_EXECUTIONS_CONSOLE_ARG;
        }

        public String toString() {
            if (this.equals((Object)IMMEDIATELY)) {
                return "Immediately";
            }
            if (this.equals((Object)FAILED_EXECUTIONS)) {
                return "Failed excecutions";
            }
            return "All executions";
        }
    }
}

