/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.execution.entity;

import com.kms.katalon.controller.TestDataController;
import com.kms.katalon.core.testdata.TestData;
import com.kms.katalon.entity.file.FileEntity;
import com.kms.katalon.entity.link.TestCaseTestDataLink;
import com.kms.katalon.entity.link.TestDataCombinationType;
import com.kms.katalon.execution.constants.StringConstants;
import com.kms.katalon.execution.entity.IExecutedEntity;
import com.kms.katalon.execution.entity.TestCaseExecutedEntity;
import com.kms.katalon.execution.entity.TestDataExecutedEntity;
import java.io.IOException;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;

public abstract class ExecutedEntity
implements IExecutedEntity {
    private String id;
    private FileEntity entity;

    public FileEntity getEntity() {
        return this.entity;
    }

    protected ExecutedEntity() {
        this.entity = null;
    }

    protected ExecutedEntity(FileEntity entity) {
        this.updateEntity(entity);
    }

    protected void updateEntity(FileEntity entity) {
        this.entity = (FileEntity)entity.clone();
    }

    @Override
    public String getId() {
        if (this.id == null) {
            this.id = new SimpleDateFormat("yyyyMMdd_HHmmss").format(new Date());
        }
        return this.id;
    }

    @Override
    public String getSourceName() {
        return this.entity.getName();
    }

    @Override
    public String getSourceId() {
        return this.entity.getIdForDisplay();
    }

    @Override
    public String getSourceDescription() {
        return this.entity.getDescription();
    }

    @Override
    public String getSourcePath() {
        return this.entity.getLocation();
    }

    @Override
    public Map<String, Object> getAttributes() {
        LinkedHashMap<String, Object> attributes = new LinkedHashMap<String, Object>();
        attributes.put(StringConstants.ID.toLowerCase(), this.getSourceId());
        attributes.put(StringConstants.NAME.toLowerCase(), this.getSourceName());
        attributes.put(StringConstants.DESCRIPTION.toLowerCase(), this.getSourceDescription());
        return attributes;
    }

    @Override
    public Map<String, String> getCollectedDataInfo() {
        return Collections.emptyMap();
    }

    protected TestData findTestData(String projectDir, Map<String, TestData> testDataUsedMap, TestCaseTestDataLink testDataLink) throws Exception {
        TestData testData = testDataUsedMap.get(testDataLink.getTestDataId());
        if (testData == null) {
            testData = TestDataController.getInstance().getTestDataInstance(testDataLink.getTestDataId(), projectDir);
        }
        if (testData == null || testData.getRowNumbers() < 1) {
            throw new IllegalArgumentException(MessageFormat.format(StringConstants.UTIL_EXC_TD_DATA_SRC_X_UNAVAILABLE, testDataLink.getTestDataId()));
        }
        return testData;
    }

    protected static TestDataExecutedEntity getTestDataExecutedEntity(String testCaseId, TestCaseTestDataLink testDataLink, TestData testData) throws Exception {
        TestDataExecutedEntity testDataExecutedEntity = new TestDataExecutedEntity(testDataLink.getId(), testDataLink.getTestDataId());
        testDataExecutedEntity.setType(testDataLink.getCombinationType());
        int[] rowIndexes = new int[]{};
        switch (testDataLink.getIterationEntity().getIterationType()) {
            case ALL: {
                rowIndexes = ExecutedEntity.getRowIndexesForAllIterationType(testData, testDataLink);
                break;
            }
            case RANGE: {
                rowIndexes = ExecutedEntity.getRowIndexesForRangeIterationType(testCaseId, testDataLink, testData);
                break;
            }
            case SPECIFIC: {
                rowIndexes = ExecutedEntity.getRowIndexesForSpecificIterationType(testCaseId, testDataLink, testData);
            }
        }
        testDataExecutedEntity.setRowIndexes(rowIndexes);
        return testDataExecutedEntity;
    }

    private static int[] getRowIndexesForAllIterationType(TestData testData, TestCaseTestDataLink testDataLink) throws IOException {
        int rowCount = testData.getRowNumbers();
        if (rowCount <= 0) {
            throw new IllegalArgumentException(MessageFormat.format(StringConstants.UTIL_EXC_TD_X_DOES_NOT_CONTAIN_ANY_RECORDS, testDataLink.getTestDataId()));
        }
        int[] rowIndexes = new int[rowCount];
        int index = 0;
        while (index < rowCount) {
            rowIndexes[index] = index + 1;
            ++index;
        }
        return rowIndexes;
    }

    private static int[] getRowIndexesForRangeIterationType(String testCaseId, TestCaseTestDataLink testDataLink, TestData testData) throws IOException {
        int rowStart = testDataLink.getIterationEntity().getFrom();
        int rowEnd = testDataLink.getIterationEntity().getTo();
        int totalRowCount = testData.getRowNumbers();
        if (rowStart > totalRowCount) {
            throw new IllegalArgumentException(MessageFormat.format(StringConstants.UTIL_EXC_TD_X_HAS_ONLY_Y_ROWS_BUT_TC_Z_START_AT_ROW_IDX, testDataLink.getTestDataId(), totalRowCount, testCaseId, rowStart));
        }
        if (rowEnd > totalRowCount) {
            throw new IllegalArgumentException(MessageFormat.format(StringConstants.UTIL_EXC_TD_X_HAS_ONLY_Y_ROWS_BUT_TC_Z_ENDS_AT_ROW_IDX, testDataLink.getTestDataId(), totalRowCount, testCaseId, rowEnd));
        }
        int rowCount = rowEnd - rowStart + 1;
        int[] rowIndexes = new int[rowCount];
        int index = 0;
        while (index < rowCount) {
            rowIndexes[index] = index + rowStart;
            ++index;
        }
        return rowIndexes;
    }

    private static int[] getRowIndexesForSpecificIterationType(String testCaseId, TestCaseTestDataLink testDataLink, TestData testData) throws IOException {
        String[] rowIndexesString = testDataLink.getIterationEntity().getValue().replace(" ", "").split(",");
        int totalRowCount = testData.getRowNumbers();
        ArrayList<Integer> rowIndexArray = new ArrayList<Integer>();
        int index = 0;
        while (index < rowIndexesString.length) {
            String rowIndexString = rowIndexesString[index];
            if (!rowIndexString.isEmpty()) {
                if (rowIndexString.contains("-")) {
                    String[] rowIndexStartEndString = rowIndexString.split("-");
                    int rowStart = Integer.parseInt(rowIndexStartEndString[0]);
                    int rowEnd = Integer.parseInt(rowIndexStartEndString[1]);
                    if (rowStart > totalRowCount) {
                        throw new IllegalArgumentException(MessageFormat.format(StringConstants.UTIL_EXC_TD_X_HAS_ONLY_Y_ROWS_BUT_TC_Z_START_AT_ROW_IDX, testDataLink.getTestDataId(), Integer.toString(totalRowCount), testCaseId, Integer.toString(rowStart)));
                    }
                    if (rowEnd > totalRowCount) {
                        throw new IllegalArgumentException(MessageFormat.format(StringConstants.UTIL_EXC_TD_X_HAS_ONLY_Y_ROWS_BUT_TC_Z_ENDS_AT_ROW_IDX, testDataLink.getTestDataId(), Integer.toString(totalRowCount), testCaseId, Integer.toString(rowEnd)));
                    }
                    int rowIndex = rowStart;
                    while (rowIndex <= rowEnd) {
                        rowIndexArray.add(rowIndex);
                        ++rowIndex;
                    }
                } else {
                    int rowIndex = Integer.parseInt(rowIndexString);
                    if (rowIndex < 1 || rowIndex > totalRowCount) {
                        throw new IllegalArgumentException(MessageFormat.format(StringConstants.UTIL_EXC_IDX_X_INVALID_TC_Y_TD_Z, rowIndexString, testCaseId, testDataLink.getTestDataId()));
                    }
                    rowIndexArray.add(rowIndex);
                }
            }
            ++index;
        }
        return ArrayUtils.toPrimitive((Integer[])rowIndexArray.toArray(new Integer[rowIndexArray.size()]));
    }

    protected int updateNumberTestCaseUsedOnce(int numberTestCaseUsedOnce, int rowCount) {
        if (numberTestCaseUsedOnce < 1) {
            return rowCount;
        }
        return Math.min(numberTestCaseUsedOnce, rowCount);
    }

    protected void updateMultiplierForSibblingTestDataExecuted(int rowCount, List<TestDataExecutedEntity> testDataExecutions) {
        for (TestDataExecutedEntity siblingDataExecuted : testDataExecutions) {
            if (siblingDataExecuted.getType() != TestDataCombinationType.MANY) continue;
            siblingDataExecuted.setMultiplier(siblingDataExecuted.getMultiplier() * rowCount);
        }
    }

    protected void prepareTestCaseExecutedEntityBody(IExecutedEntity executedEntity, List<TestDataExecutedEntity> testDataExecutions, String testCaseId, List<TestCaseTestDataLink> testDataLinkUsedList, String projectDir, Map<String, TestData> testDataMap) throws Exception {
        int numberTestCaseUsedOnce = 0;
        int numTestDataRowUsedManyTimes = 1;
        for (TestCaseTestDataLink testDataLink : testDataLinkUsedList) {
            TestData testData = this.findTestData(projectDir, testDataMap, testDataLink);
            testDataMap.put(testDataLink.getTestDataId(), testData);
            TestDataExecutedEntity testDataExecutedEntity = ExecutedEntity.getTestDataExecutedEntity(testCaseId, testDataLink, testData);
            int rowCount = testDataExecutedEntity.getRowIndexes().length;
            if (testDataLink.getCombinationType() == TestDataCombinationType.ONE) {
                numberTestCaseUsedOnce = this.updateNumberTestCaseUsedOnce(numberTestCaseUsedOnce, rowCount);
            } else {
                numTestDataRowUsedManyTimes *= rowCount;
                this.updateMultiplierForSibblingTestDataExecuted(rowCount, ExecutedEntity.getTestDataExecutedEntities(executedEntity));
            }
            testDataExecutions.add(testDataExecutedEntity);
        }
        int times = numTestDataRowUsedManyTimes * Math.max(numberTestCaseUsedOnce, 1);
        if (executedEntity instanceof TestCaseExecutedEntity) {
            ((TestCaseExecutedEntity)executedEntity).setLoopTimes(times);
        }
        ExecutedEntity.cutRedundantIndexes(executedEntity, Math.max(numberTestCaseUsedOnce, 1));
    }

    private static void cutRedundantIndexes(IExecutedEntity testCaseExecutedEntity, int numberTestCaseUsedOnce) {
        if (numberTestCaseUsedOnce <= 1) {
            return;
        }
        for (TestDataExecutedEntity siblingDataExecuted : ExecutedEntity.getTestDataExecutedEntities(testCaseExecutedEntity)) {
            if (siblingDataExecuted.getType() != TestDataCombinationType.ONE || siblingDataExecuted.getRowIndexes().length <= numberTestCaseUsedOnce) continue;
            int[] newRowIndexs = ArrayUtils.remove((int[])siblingDataExecuted.getRowIndexes(), (int)numberTestCaseUsedOnce);
            siblingDataExecuted.setRowIndexes(newRowIndexs);
        }
    }

    private static List<TestDataExecutedEntity> getTestDataExecutedEntities(IExecutedEntity executedEntity) {
        if (executedEntity instanceof TestCaseExecutedEntity) {
            return ((TestCaseExecutedEntity)executedEntity).getTestDataExecutions();
        }
        return null;
    }

    public TestDataExecutedEntity getTestDataExecuted(String testDataLinkId, List<TestDataExecutedEntity> testDataExecutions) {
        for (TestDataExecutedEntity executedEntity : testDataExecutions) {
            if (!executedEntity.getTestDataLinkId().equals(testDataLinkId)) continue;
            return executedEntity;
        }
        return null;
    }
}

