/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.execution.finders;

import com.kms.katalon.core.configuration.RunConfiguration;
import com.kms.katalon.core.util.ConsoleCommandExecutor;
import com.kms.katalon.logging.LogUtil;
import com.kms.katalon.preferences.internal.PreferenceStoreManager;
import com.kms.katalon.preferences.internal.ScopedPreferenceStore;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.Platform;

public class AppiumDirectoryFinder {
    public static final String MOBILE_QUALIFIER = "com.kms.katalon.composer.mobile";
    public static final String MOBILE_APPIUM_DIRECTORY = "mobile.appiumDirectory";
    public static final String MOBILE_APPIUM_LOG_LEVEL = "mobile.appiumLogLevel";
    private static final String ENV_APPIUM_HOME_DIRECTORY = System.getenv("APPIUM_HOME");
    private static final String[] APPIUM_HOME_DIRS_MACOS = new String[]{"/usr/local/lib/node_modules/appium", "/opt/homebrew/lib/node_modules/appium"};

    public static String findAppiumDir() {
        ScopedPreferenceStore mobilePreferenceStore = PreferenceStoreManager.getPreferenceStore((String)MOBILE_QUALIFIER);
        String appiumDir = mobilePreferenceStore.getString(MOBILE_APPIUM_DIRECTORY);
        if (StringUtils.isNotEmpty((String)appiumDir)) {
            return appiumDir;
        }
        if (StringUtils.isNotBlank((String)ENV_APPIUM_HOME_DIRECTORY)) {
            appiumDir = ENV_APPIUM_HOME_DIRECTORY;
        }
        if (StringUtils.isEmpty((String)appiumDir) || !new File(appiumDir).exists()) {
            appiumDir = AppiumDirectoryFinder.findAppiumFromDefaultLocation();
        }
        if (StringUtils.isNotEmpty((String)appiumDir) && new File(appiumDir).exists()) {
            mobilePreferenceStore.setValue(MOBILE_APPIUM_DIRECTORY, appiumDir);
            try {
                mobilePreferenceStore.save();
            }
            catch (IOException error) {
                LogUtil.logError((Throwable)error);
            }
        }
        return appiumDir;
    }

    private static String findAppiumFromDefaultLocation() {
        switch (Platform.getOS()) {
            case "macosx": {
                return AppiumDirectoryFinder.findAppiumHome(APPIUM_HOME_DIRS_MACOS);
            }
            case "linux": {
                return AppiumDirectoryFinder.findAppiumHome("/usr/lib/node_modules/appium/");
            }
            case "win32": {
                return AppiumDirectoryFinder.findAppiumHome(String.valueOf(System.getProperty("user.home")) + "\\AppData\\Roaming\\npm\\node_modules\\appium");
            }
        }
        return null;
    }

    private static String findAppiumHome(String ... defaultLocations) {
        String validAppiumDir = "";
        String appiumBin = ConsoleCommandExecutor.safeWhere((String)"appium");
        if (StringUtils.isNotBlank((String)appiumBin)) {
            File parent = new File(appiumBin);
            if (StringUtils.equals((String)parent.getName(), (String)"appium")) {
                parent = new File(parent.getParentFile(), "node_modules/appium");
            }
            while (parent.exists()) {
                if (parent.isDirectory() && StringUtils.equals((String)parent.getName(), (String)"appium")) {
                    validAppiumDir = parent.getAbsolutePath();
                    break;
                }
                parent = parent.getParentFile();
            }
        }
        if (StringUtils.isBlank((String)validAppiumDir)) {
            validAppiumDir = Arrays.stream(defaultLocations).filter(appiumHomeDir -> new File((String)appiumHomeDir).exists()).findFirst().orElse(null);
        }
        return validAppiumDir;
    }

    public static String findAppiumDirForConsoleLaucher() {
        if (StringUtils.isNotBlank((String)RunConfiguration.getInstance().getAppiumDirectoryDefinedWithArgument())) {
            return RunConfiguration.getInstance().getAppiumDirectoryDefinedWithArgument();
        }
        return AppiumDirectoryFinder.findAppiumDir();
    }
}

