/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.execution.launcher;

import com.kms.katalon.application.utils.ActivationInfoCollector;
import com.kms.katalon.application.utils.ApplicationInfo;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.controller.exception.ControllerException;
import com.kms.katalon.core.appium.util.AppiumVersionUtil;
import com.kms.katalon.core.logging.XmlLogRecord;
import com.kms.katalon.core.logging.model.TestStatus;
import com.kms.katalon.core.mobile.util.MobileRunConfigurationUtil;
import com.kms.katalon.core.util.FailedTestThreshold;
import com.kms.katalon.entity.testsuite.FilteringTestSuiteEntity;
import com.kms.katalon.execution.classpath.ClassPathResolver;
import com.kms.katalon.execution.collector.ExecutionInfo;
import com.kms.katalon.execution.collector.ExecutionInfoCollector;
import com.kms.katalon.execution.collector.SelfHealingExecutionReport;
import com.kms.katalon.execution.collector.SelfHealingExecutionReportCollector;
import com.kms.katalon.execution.configuration.IRunConfiguration;
import com.kms.katalon.execution.constants.ExecutionMessageConstants;
import com.kms.katalon.execution.entity.TestSuiteExecutedEntity;
import com.kms.katalon.execution.exception.ExecutionException;
import com.kms.katalon.execution.finders.AppiumDirectoryFinder;
import com.kms.katalon.execution.launcher.IConsoleLauncher;
import com.kms.katalon.execution.launcher.ReportableLauncher;
import com.kms.katalon.execution.launcher.manager.LauncherManager;
import com.kms.katalon.execution.launcher.process.ConsoleProcess;
import com.kms.katalon.execution.launcher.process.ILaunchProcess;
import com.kms.katalon.execution.launcher.process.LaunchProcessor;
import com.kms.katalon.execution.util.ExecutionUtil;
import com.kms.katalon.execution.util.MailUtil;
import com.kms.katalon.tracking.model.TestEntityTrackingInfo;
import com.kms.katalon.tracking.model.TestSuiteTrackingInfo;
import com.kms.katalon.tracking.service.Trackings;
import java.io.File;
import java.io.IOException;
import java.util.List;

public class ConsoleLauncher
extends ReportableLauncher
implements IConsoleLauncher {
    public ConsoleLauncher(LauncherManager manager, IRunConfiguration runConfig) {
        super(manager, runConfig);
    }

    @Override
    public ReportableLauncher clone(IRunConfiguration runConfig) {
        return new ConsoleLauncher(this.getManager(), runConfig);
    }

    @Override
    protected ILaunchProcess launch() throws ExecutionException {
        try {
            Process systemProcess = this.executeProcess();
            if (systemProcess == null) {
                throw new ExecutionException(ExecutionMessageConstants.CONSOLE_CANNOT_START_EXECUTION);
            }
            return new ConsoleProcess(systemProcess);
        }
        catch (IOException ex) {
            throw new ExecutionException(ex);
        }
    }

    protected Process executeProcess() throws IOException, ExecutionException {
        try {
            return new LaunchProcessor(ClassPathResolver.getClassPaths(ProjectController.getInstance().getCurrentProject()), this.runConfig.getAdditionalEnvironmentVariables(), this.runConfig.getVmArgs()).execute(this.getRunConfig().getExecutionSetting().getScriptFile());
        }
        catch (ControllerException e) {
            throw new ExecutionException(e);
        }
    }

    @Override
    public synchronized void addLogRecords(List<XmlLogRecord> records) {
        super.addLogRecords(records);
        this.clearRecords();
    }

    @Override
    public String getStatusMessage(int consoleWidth) {
        return this.getDefaultStatusMessage(consoleWidth);
    }

    @Override
    protected void postExecutionComplete() {
        super.postExecutionComplete();
        if (this.getExecutedEntity() instanceof TestSuiteExecutedEntity) {
            File reportFolder = this.getReportFolder();
            SelfHealingExecutionReport selfHealingReport = SelfHealingExecutionReportCollector.getInstance().collect(this.runConfig, reportFolder);
            ExecutionInfo executionInfo = ExecutionInfoCollector.getInstance().collect(this.runConfig, this.getTestSuiteLogRecord(), this.getLogRecords());
            TestSuiteExecutedEntity tsExecutedEntity = (TestSuiteExecutedEntity)this.getExecutedEntity();
            Trackings.trackExecuteTestSuiteInConsoleMode((TestSuiteTrackingInfo)this.buildTestSuiteTrackingInfo(tsExecutedEntity, selfHealingReport, executionInfo, this.getTestCloudRunConfiguration()));
        }
    }

    private Boolean isTestCloudTunnelEnabled(IRunConfiguration runConfiguration) {
        Boolean isUsingTestCloudTunnel = null;
        if (runConfiguration.getAdditionalInfo().containsKey("isUsingTestCloudTunnel")) {
            isUsingTestCloudTunnel = Boolean.valueOf(runConfiguration.getAdditionalInfo().get("isUsingTestCloudTunnel"));
        }
        return isUsingTestCloudTunnel;
    }

    protected String getExecutionResult() {
        String resultExecution = null;
        resultExecution = this.getResult().getNumFailures() > 0 ? TestStatus.TestStatusValue.FAILED.toString() : (this.getResult().getNumErrors() > 0 ? TestStatus.TestStatusValue.ERROR.toString() : TestStatus.TestStatusValue.PASSED.toString());
        return resultExecution;
    }

    @Override
    protected void onStartExecution() {
        super.onStartExecution();
    }

    private TestSuiteTrackingInfo buildTestSuiteTrackingInfo(TestSuiteExecutedEntity tsExecutedEntity, SelfHealingExecutionReport selfHealingExecutionReport, ExecutionInfo executionInfo, String testCloudRunConfiguration) {
        boolean isInTestSuiteCollection = tsExecutedEntity.isInCollection();
        String result = this.getExecutionResult();
        boolean usedMaxFailedTests = FailedTestThreshold.getInstance().isThresholdAvailable();
        boolean isDynamicTestSuite = tsExecutedEntity.getEntity() != null ? tsExecutedEntity.getEntity() instanceof FilteringTestSuiteEntity : false;
        int numberOfEmailsSent = MailUtil.getNumberOfEmailsSentForTestSuite(this.getAreEmailsSent(), (TestSuiteExecutedEntity)this.getExecutedEntity(), this.getTestSuiteLogRecord());
        TestSuiteTrackingInfo trackingInfo = new TestSuiteTrackingInfo();
        trackingInfo.setAnonymous(!ActivationInfoCollector.isActivated());
        trackingInfo.setDriverType(this.runConfig.getReportDriverName());
        trackingInfo.setResult(result);
        trackingInfo.setDuration(this.getEndTime().getTime() - this.getStartTime().getTime());
        trackingInfo.setRetryStrategy(this.getRetryStrategy());
        trackingInfo.setNumberOfRetry(this.getNumberOfRetry());
        trackingInfo.setEnableSelfHealing(selfHealingExecutionReport.isEnabled());
        trackingInfo.setTriggerSelfHealing(selfHealingExecutionReport.isTriggered());
        trackingInfo.setHealingInfo(selfHealingExecutionReport.getHealingInfo());
        trackingInfo.setTotalTestCases(this.getResult().getTotalTestCases());
        trackingInfo.setPassedTestCases(this.getResult().getNumPasses());
        trackingInfo.setFailedTestCases(this.getResult().getNumFailures());
        trackingInfo.setErrorTestCases(this.getResult().getNumErrors());
        trackingInfo.setSkippedTestCases(this.getResult().getNumSkips());
        trackingInfo.setIncompleteTestCases(this.getResult().getNumIncomplete());
        trackingInfo.setOrgId(ApplicationInfo.getOrganization().getId());
        trackingInfo.setInCollection(isInTestSuiteCollection);
        trackingInfo.setEnableScreenshot(executionInfo.isEnableScreenshot());
        trackingInfo.setEnableHideHostname(ExecutionUtil.isEnabledHideHostname().booleanValue());
        trackingInfo.setEnableVideo(executionInfo.isEnableScreenshot());
        trackingInfo.setVideoRecordingLevel(executionInfo.getVideoRecordingLevel());
        trackingInfo.setNumTestSteps(this.getNumTestSteps());
        trackingInfo.setAdditionalProps(this.getIntegratedContributionsTrackingData());
        trackingInfo.setKeywordsUsage(executionInfo.getKeywordsUsage());
        trackingInfo.setUsedMaxFailedTestParam(usedMaxFailedTests);
        trackingInfo.setUsingApplitools(executionInfo.isUsingApplitools());
        trackingInfo.setUseDataBinding(tsExecutedEntity.isUseDdtAtTCLevel());
        trackingInfo.setDynamicTestSuite(isDynamicTestSuite);
        trackingInfo.setIsTestCloudTunnelEnabled((Object)this.isTestCloudTunnelEnabled(this.runConfig));
        trackingInfo.setNumberOfEmailsSent(numberOfEmailsSent);
        trackingInfo.setTestCloudRunConfiguration(testCloudRunConfiguration);
        trackingInfo.setTestSuiteCollectionId(tsExecutedEntity.getTestSuiteCollectionId());
        this.addAppiumInfoForTracking((TestEntityTrackingInfo)trackingInfo);
        return trackingInfo;
    }

    private void addAppiumInfoForTracking(TestEntityTrackingInfo trackInfo) {
        String runConfigClazzName = this.runConfig.getClass().getSimpleName();
        boolean isMobileRunConfig = runConfigClazzName.equals("AndroidRunConfiguration") || runConfigClazzName.equals("IosRunConfiguration");
        boolean isMobileCustomRunConfig = MobileRunConfigurationUtil.usingCustomRunConfigurationId((String)this.runConfig.getName(), (String)ProjectController.getInstance().getCurrentProject().getFolderLocation());
        if (isMobileCustomRunConfig || isMobileRunConfig) {
            String appiumDir = AppiumDirectoryFinder.findAppiumDirForConsoleLaucher();
            String appiumVersion = AppiumVersionUtil.readVersionFromFile((String)appiumDir);
            trackInfo.setAppiumVersion(appiumVersion);
        }
    }
}

