/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.execution.launcher;

import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.controller.exception.ControllerException;
import com.kms.katalon.execution.classpath.ClassPathResolver;
import com.kms.katalon.execution.configuration.IRunConfiguration;
import com.kms.katalon.execution.constants.ExecutionMessageConstants;
import com.kms.katalon.execution.exception.ExecutionException;
import com.kms.katalon.execution.launcher.ConsoleLauncher;
import com.kms.katalon.execution.launcher.manager.LauncherManager;
import com.kms.katalon.execution.launcher.process.ILaunchProcess;
import com.kms.katalon.execution.launcher.process.LaunchProcessor;
import com.kms.katalon.execution.launcher.process.RecordingProcess;
import com.kms.katalon.logging.LogUtil;
import java.io.IOException;

public class RecordingScriptLauncher
extends ConsoleLauncher {
    private ILaunchProcess launchProcess;
    private Runnable processFinishedRunnable;

    public RecordingScriptLauncher(LauncherManager manager, IRunConfiguration runConfig, Runnable processFinishedRunnable) {
        super(manager, runConfig);
        this.processFinishedRunnable = processFinishedRunnable;
    }

    @Override
    protected ILaunchProcess launch() throws ExecutionException {
        try {
            final Process systemProcess = this.executeProcess();
            if (systemProcess == null) {
                throw new ExecutionException(ExecutionMessageConstants.CONSOLE_CANNOT_START_EXECUTION);
            }
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        try {
                            systemProcess.waitFor();
                        }
                        catch (InterruptedException interruptedException) {
                            RecordingScriptLauncher.this.processFinishedRunnable.run();
                        }
                    }
                    finally {
                        RecordingScriptLauncher.this.processFinishedRunnable.run();
                    }
                }
            });
            thread.start();
            return this.onCreateLaunchProcess(systemProcess);
        }
        catch (IOException ex) {
            LogUtil.logError((Throwable)ex);
            throw new ExecutionException(ex);
        }
    }

    protected ILaunchProcess onCreateLaunchProcess(Process systemProcess) {
        this.launchProcess = new RecordingProcess(systemProcess);
        return this.launchProcess;
    }

    @Override
    protected Process executeProcess() throws IOException, ExecutionException {
        try {
            return new LaunchProcessor(ClassPathResolver.getClassPaths(ProjectController.getInstance().getCurrentProject()), this.runConfig.getAdditionalEnvironmentVariables(), this.runConfig.getVmArgs()).execute(this.getRunConfig().getExecutionSetting().getScriptFile());
        }
        catch (ControllerException e) {
            throw new ExecutionException(e);
        }
    }
}

