/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.execution.launcher.process;

import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.execution.classpath.ClassPathResolver;
import com.kms.katalon.execution.launcher.ILaunchProcessor;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public class LaunchProcessor
implements ILaunchProcessor {
    private static final String STARTER_CLASS = "org.codehaus.groovy.tools.GroovyStarter";
    private static final String MAIN_CLASS = "groovy.ui.GroovyMain";
    private static final String GROOVY_BUNDLE_NAME = "org.codehaus.groovy";
    private String[] fClasspaths;
    private Map<String, String> environmentVariables;
    private String[] vmArgs;

    public LaunchProcessor(String[] classPaths) {
        this(classPaths, new HashMap<String, String>(), new String[0]);
    }

    public LaunchProcessor(String[] classPaths, Map<String, String> environmentVariables, String[] vmArgs) {
        this.fClasspaths = classPaths;
        this.environmentVariables = environmentVariables;
        this.vmArgs = vmArgs;
    }

    @Override
    public Process execute(File scripFile) throws IOException {
        ArrayList<String> args = new ArrayList<String>();
        args.add(ClassPathResolver.getInstalledJRE(true));
        if (this.vmArgs != null) {
            args.addAll(Arrays.asList(this.vmArgs));
        }
        args.addAll(Arrays.asList("-cp", String.valueOf(File.pathSeparator) + FilenameUtils.separatorsToSystem((String)this.getGroovyLibs()) + File.pathSeparator + this.getClasspaths(), STARTER_CLASS, "--main", MAIN_CLASS, FilenameUtils.separatorsToSystem((String)scripFile.getAbsolutePath())));
        ProcessBuilder pb = new ProcessBuilder(args.toArray(new String[0]));
        pb.environment().putAll(this.getEnviromentVariables());
        pb.directory(new File(ProjectController.getInstance().getCurrentProject().getFolderLocation()));
        return pb.start();
    }

    @Override
    public String[] getClasspath() {
        return this.fClasspaths;
    }

    @Override
    public Map<String, String> getEnviromentVariables() throws IOException {
        return this.environmentVariables;
    }

    private String getGroovyHome() throws IOException {
        return FileLocator.getBundleFile((Bundle)Platform.getBundle((String)GROOVY_BUNDLE_NAME)).getAbsolutePath();
    }

    private String getGroovyLibs() throws IOException {
        return String.valueOf(this.getGroovyHome()) + "/lib/*";
    }

    private String getClasspaths() {
        StringBuilder cpBuilder = new StringBuilder();
        String[] stringArray = this.getClasspath();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String cp = stringArray[n2];
            cpBuilder.append(FilenameUtils.separatorsToSystem((String)cp)).append(File.pathSeparator);
            ++n2;
        }
        return cpBuilder.toString();
    }
}

