/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.execution.logging;

import com.kms.katalon.core.logging.XMLLoggerParser;
import com.kms.katalon.execution.logging.AbstractLogWatcher;
import com.kms.katalon.execution.logging.ILogCollection;
import com.kms.katalon.logging.LogUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.List;
import javax.net.ServerSocketFactory;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.io.IOUtils;

public class SocketWatcher
extends AbstractLogWatcher {
    protected BufferedReader reader;
    protected InputStreamReader is;
    private int port;
    private ILogCollection logCollection;

    public SocketWatcher(int port, int delayInMillis, ILogCollection logCollection) {
        super(delayInMillis);
        this.port = port;
        this.logCollection = logCollection;
    }

    @Override
    public void run() {
        ServerSocket serverSocket = null;
        Socket socket = null;
        try {
            try {
                serverSocket = ServerSocketFactory.getDefault().createServerSocket(this.port);
                socket = serverSocket.accept();
                this.is = new InputStreamReader(socket.getInputStream());
                this.reader = new BufferedReader(this.is);
                block7: while (!this.isStopSignal() || this.reader.ready()) {
                    StringBuilder builder = new StringBuilder();
                    Thread.sleep(this.delayInMillis);
                    while (this.reader.ready()) {
                        String line = this.reader.readLine();
                        if (line == null || this.isIgnoredLine(line)) continue block7;
                        builder.append(String.valueOf(LINE_SEPERATOR) + line);
                        if (!"</record>".equals(line.trim()) || builder.length() <= 0) continue;
                        List records = XMLLoggerParser.readFromString((String)this.prepareString(builder));
                        this.logCollection.addLogRecords(records);
                        continue block7;
                    }
                }
                this.logCollection.finish();
            }
            catch (IOException | InterruptedException exception) {
                IOUtils.closeQuietly((Reader)this.reader);
                IOUtils.closeQuietly((Reader)this.is);
                IOUtils.closeQuietly((Socket)socket);
                IOUtils.closeQuietly((ServerSocket)serverSocket);
            }
            catch (XMLStreamException e) {
                LogUtil.logError((Throwable)e);
                IOUtils.closeQuietly((Reader)this.reader);
                IOUtils.closeQuietly((Reader)this.is);
                IOUtils.closeQuietly((Socket)socket);
                IOUtils.closeQuietly((ServerSocket)serverSocket);
            }
        }
        finally {
            IOUtils.closeQuietly((Reader)this.reader);
            IOUtils.closeQuietly((Reader)this.is);
            IOUtils.closeQuietly((Socket)socket);
            IOUtils.closeQuietly((ServerSocket)serverSocket);
        }
    }
}

