/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.execution.setting;

import com.kms.katalon.core.logging.model.TestCaseLogRecord;
import com.kms.katalon.core.logging.model.TestSuiteCollectionLogRecord;
import com.kms.katalon.core.logging.model.TestSuiteLogRecord;
import com.kms.katalon.core.util.internal.DateUtil;
import com.kms.katalon.entity.global.ExecutionProfileEntity;
import com.kms.katalon.entity.testsuite.TestSuiteCollectionEntity;
import com.kms.katalon.entity.testsuite.TestSuiteEntity;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EmailVariableBinding {
    public static Map<String, Object> getVariablesForTestSuiteEmail(TestSuiteLogRecord logRecord, ExecutionProfileEntity executionProfile) {
        HashMap<String, Object> binding = new HashMap<String, Object>();
        binding.put("hostName", logRecord.getHostName());
        binding.put("os", logRecord.getOs());
        binding.put("browser", logRecord.getBrowser());
        binding.put("suiteId", logRecord.getId());
        binding.put("suiteName", logRecord.getName());
        binding.put("deviceId", logRecord.getDeviceId());
        binding.put("deviceName", logRecord.getDeviceName());
        long startTime = logRecord.getStartTime();
        TestCaseLogRecord lastTestCaseLogRecord = logRecord.getLastTestCaseLogRecord();
        long endTime = lastTestCaseLogRecord.getEndTime();
        binding.put("startTime", DateUtil.getDateTimeFormatted((long)startTime));
        binding.put("duration", DateUtil.getElapsedTime((long)startTime, (long)endTime));
        binding.put("totalPassed", logRecord.getTotalPassedTestCases());
        binding.put("totalFailed", logRecord.getTotalFailedTestCases());
        binding.put("totalError", logRecord.getTotalErrorTestCases());
        binding.put("totalTestCases", logRecord.getTotalTestCases());
        binding.put("executionProfile", executionProfile.getName());
        return binding;
    }

    public static Map<String, Object> getVariablesForTestSuiteCollectionEmail(TestSuiteCollectionLogRecord logRecord) {
        List testSuiteRecords = logRecord.getTestSuiteRecords();
        if (testSuiteRecords == null || testSuiteRecords.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> binding = new HashMap<String, Object>();
        TestSuiteLogRecord childRecord = (TestSuiteLogRecord)testSuiteRecords.get(0);
        if (testSuiteRecords != null && testSuiteRecords.size() > 0) {
            childRecord = (TestSuiteLogRecord)testSuiteRecords.get(0);
        }
        binding.put("hostName", childRecord != null ? childRecord.getHostName() : "");
        binding.put("os", childRecord != null ? childRecord.getOs() : "");
        long startTime = logRecord.getStartTime();
        long endTime = logRecord.getEndTime();
        binding.put("startTime", DateUtil.getDateTimeFormatted((long)startTime));
        binding.put("duration", DateUtil.getElapsedTime((long)startTime, (long)endTime));
        binding.put("suiteCollectionName", logRecord.getName());
        binding.put("totalPassed", logRecord.getTotalPassedTestCases());
        binding.put("totalFailed", logRecord.getTotalFailedTestCases());
        binding.put("totalError", logRecord.getTotalErrorTestCases());
        binding.put("totalTestCases", logRecord.getTotalTestCases());
        return binding;
    }

    public static Map<String, Object> getTestEmailVariables() {
        HashMap<String, Object> binding = new HashMap<String, Object>();
        binding.put("hostName", "localhost");
        binding.put("os", "Windows 7");
        binding.put("browser", "Chrome 59.0");
        binding.put("suiteId", "Test Suites/Sample Suite");
        binding.put("suiteName", "Sample Suite");
        binding.put("suiteCollectionName", "");
        binding.put("deviceName", "My device");
        binding.put("deviceId", "------");
        binding.put("startTime", DateUtil.getDateTimeFormatted((long)Calendar.getInstance().getTimeInMillis()));
        binding.put("duration", "10s");
        binding.put("totalPassed", 1);
        binding.put("totalFailed", 0);
        binding.put("totalError", 0);
        binding.put("totalTestCases", 1);
        binding.put("executionProfile", "default");
        return binding;
    }

    public static Map<String, Object> getVariablesForTestSuiteEmailSettings(TestSuiteEntity entity) {
        HashMap<String, Object> binding = new HashMap<String, Object>();
        binding.put("suiteId", entity.getId());
        binding.put("suiteName", entity.getName());
        binding.put("suiteCollectionName", "");
        return binding;
    }

    public static Map<String, Object> getVariablesForTestSuiteCollectionEmailSettings(TestSuiteCollectionEntity entity) {
        HashMap<String, Object> binding = new HashMap<String, Object>();
        binding.put("suiteCollectionId", entity.getId());
        binding.put("suiteCollectionName", entity.getName());
        binding.put("suiteName", "");
        return binding;
    }
}

