/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.execution.util;

import com.google.gson.Gson;
import com.kms.katalon.application.utils.LicenseUtil;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.controller.TestSuiteController;
import com.kms.katalon.core.configuration.RunConfiguration;
import com.kms.katalon.core.logging.model.ILogRecord;
import com.kms.katalon.core.logging.model.TestCaseLogRecord;
import com.kms.katalon.core.logging.model.TestStatus;
import com.kms.katalon.core.logging.model.TestStepLogRecord;
import com.kms.katalon.core.setting.LinkedProperties;
import com.kms.katalon.core.webui.util.OSUtil;
import com.kms.katalon.entity.global.ExecutionProfileEntity;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import com.kms.katalon.entity.testsuite.TestSuiteEntity;
import com.kms.katalon.execution.collector.RunConfigurationCollector;
import com.kms.katalon.execution.configuration.IDriverConnector;
import com.kms.katalon.execution.configuration.IExecutionSetting;
import com.kms.katalon.execution.configuration.IRunConfiguration;
import com.kms.katalon.execution.configuration.contributor.IRunConfigurationContributor;
import com.kms.katalon.execution.entity.DefaultRerunSetting;
import com.kms.katalon.execution.entity.ExecutedEntity;
import com.kms.katalon.execution.entity.IExecutedEntity;
import com.kms.katalon.execution.entity.TestCaseBindingExecutedEntity;
import com.kms.katalon.execution.entity.TestCaseExecutedEntity;
import com.kms.katalon.execution.entity.TestSuiteExecutedEntity;
import com.kms.katalon.execution.launcher.result.ILauncherResult;
import com.kms.katalon.execution.setting.ExecutionDefaultSettingStore;
import com.kms.katalon.feature.FeatureServiceConsumer;
import com.kms.katalon.feature.IFeatureService;
import com.kms.katalon.feature.KSEFeature;
import com.kms.katalon.groovy.util.GroovyStringUtil;
import com.kms.katalon.logging.LogUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;

public class ExecutionUtil {
    private static IFeatureService featureService = FeatureServiceConsumer.getServiceInstance();
    private static final String BIT = "bit";
    private static final String OS_ARCHITECTURE_PROPERTY = "sun.arch.data.model";
    private static final String OS_NAME_PROPERTY = "os.name";
    private static final String UNKNOW_HOST = "Unknow host";
    private static final int REPEAT_TIMES = 10;
    private static String hostname;

    public static boolean isRunningInKatalonC() {
        Properties props = System.getProperties();
        String launcherName = props.getProperty("eclipse.launcher.name");
        return "katalonc".equalsIgnoreCase(launcherName);
    }

    public static String getLocalHostAddress() {
        try {
            return ExecutionUtil.isEnabledHideHostname() != false ? StringUtils.repeat((String)"*", (int)10) : InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            return "127.0.0.1";
        }
    }

    public static String getLocalHostName() {
        try {
            hostname = ExecutionUtil.isEnabledHideHostname() != false ? StringUtils.repeat((String)"*", (int)10) : String.valueOf(System.getProperty("user.name")) + " - " + InetAddress.getLocalHost().getCanonicalHostName();
            return hostname;
        }
        catch (UnknownHostException unknownHostException) {
            return UNKNOW_HOST;
        }
    }

    public static String getLocalOS() {
        return String.valueOf(System.getProperty(OS_NAME_PROPERTY)) + " " + System.getProperty(OS_ARCHITECTURE_PROPERTY) + BIT;
    }

    private static ExecutionDefaultSettingStore getStore() {
        return ExecutionDefaultSettingStore.getStore();
    }

    public static IRunConfigurationContributor getDefaultExecutionConfiguration() {
        IRunConfigurationContributor[] allBuiltinRunConfigurationContributor;
        String selectedRunConfiguration = ExecutionUtil.getStore().getExecutionConfiguration();
        IRunConfigurationContributor[] iRunConfigurationContributorArray = allBuiltinRunConfigurationContributor = RunConfigurationCollector.getInstance().getAllBuiltinRunConfigurationContributors();
        int n = allBuiltinRunConfigurationContributor.length;
        int n2 = 0;
        while (n2 < n) {
            IRunConfigurationContributor runConfigurationContributor = iRunConfigurationContributorArray[n2];
            if (runConfigurationContributor.getId().equals(selectedRunConfiguration)) {
                return runConfigurationContributor;
            }
            ++n2;
        }
        return null;
    }

    public static Boolean isEnabledHideHostname() {
        return ExecutionUtil.getStore().getHideHostName();
    }

    public static Boolean getAutoApplyNeighborXpaths() {
        return ExecutionUtil.getStore().isAutoApplyNeighborXpathsEnabled();
    }

    public static Boolean getDefaultSmartWaitMode() {
        return ExecutionUtil.getStore().getDefaultSmartWaitMode();
    }

    public static Boolean getLogTestSteps() {
        return ExecutionUtil.getStore().getLogTestSteps();
    }

    public static int getDefaultImplicitTimeout() {
        return ExecutionUtil.getStore().getElementTimeout();
    }

    public static boolean openReportAfterExecuting() {
        return ExecutionUtil.getStore().isPostExecOpenReport();
    }

    public static boolean isQuitDriversAfterExecutingTestCase() {
        return ExecutionUtil.getStore().isPostTestCaseExecQuitDriver();
    }

    public static boolean isQuitDriversAfterExecutingTestSuite() {
        return ExecutionUtil.getStore().isPostTestSuiteExecQuitDriver();
    }

    public static String[] getVmArgs() {
        String vmArgsString = ExecutionUtil.getStore().getVmArgs();
        return StringUtils.split((String)vmArgsString);
    }

    public static Map<String, Object> escapeGroovy(Map<String, Object> propertiesMap) {
        for (Map.Entry<String, Object> entry : propertiesMap.entrySet()) {
            if (!(entry.getValue() instanceof String)) continue;
            entry.setValue(GroovyStringUtil.escapeGroovy((String)((String)entry.getValue())));
        }
        return propertiesMap;
    }

    public static Map<String, Object> getExecutionProperties(IExecutionSetting executionSetting, Map<String, IDriverConnector> driverConnectors, ExecutionProfileEntity executionProfile) {
        LinkedHashMap<String, Object> propertyMap = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, Object> executionProperties = new LinkedHashMap<String, Object>();
        Map<String, Object> generalProperties = executionSetting.getGeneralProperties();
        if (executionProfile != null) {
            generalProperties.put("executionProfile", executionProfile.getName());
        }
        executionProperties.put("general", generalProperties);
        executionProperties.put("drivers", ExecutionUtil.getDriverExecutionProperties(driverConnectors));
        executionProperties.put("globalSmartWaitEnabled", ExecutionUtil.getDefaultSmartWaitMode());
        executionProperties.put("smartLocatorEnabled", LicenseUtil.isNotFreeLicense());
        boolean doLogTestStep = featureService.canUse(KSEFeature.CONSOLE_LOG_CUSTOMIZATION) ? ExecutionUtil.getLogTestSteps() : true;
        boolean isHideHostname = featureService.canUse(KSEFeature.HIDE_HOSTNAME) ? ExecutionUtil.isEnabledHideHostname() : false;
        executionProperties.put("logTestSteps", doLogTestStep);
        executionProperties.put("hideHostname", isHideHostname);
        propertyMap.put("execution", executionProperties);
        return propertyMap;
    }

    private static Map<String, Object> getDriverExecutionProperties(Map<String, IDriverConnector> driverConnectors) {
        LinkedHashMap<String, Object> driverProperties = new LinkedHashMap<String, Object>();
        HashMap<String, Map<String, Object>> driverSystemProperties = new HashMap<String, Map<String, Object>>();
        HashMap<String, Map<String, Object>> driverPerferencesProperties = new HashMap<String, Map<String, Object>>();
        for (Map.Entry<String, IDriverConnector> kwDriverConnector : driverConnectors.entrySet()) {
            if (kwDriverConnector == null) continue;
            driverSystemProperties.put(kwDriverConnector.getKey(), kwDriverConnector.getValue().getSystemProperties());
            driverPerferencesProperties.put(kwDriverConnector.getKey(), kwDriverConnector.getValue().getUserConfigProperties());
        }
        driverProperties.put("system", driverSystemProperties);
        driverProperties.put("preferences", driverPerferencesProperties);
        return driverProperties;
    }

    public static File writeRunConfigToFile(IRunConfiguration runConfig) throws IOException {
        IExecutionSetting setting = runConfig.getExecutionSetting();
        File executionFile = new File(setting.getSettingFilePath());
        if (!executionFile.exists()) {
            executionFile.createNewFile();
        }
        Gson gsonObj = new Gson();
        String strJson = gsonObj.toJson(setting.getGeneralProperties());
        FileUtils.writeStringToFile((File)executionFile, (String)strJson);
        return executionFile;
    }

    public static Map<String, Object> readRunConfigSettingFromFile(String executionConfigFilePath) throws IOException {
        Map preferenceProps;
        RunConfiguration.setExecutionSettingFile((String)executionConfigFilePath);
        LinkedHashMap<String, Object> executionProps = new LinkedHashMap<String, Object>();
        Map generalProps = RunConfiguration.getExecutionGeneralProperties();
        if (generalProps != null && !generalProps.values().isEmpty()) {
            executionProps.putAll(RunConfiguration.getExecutionGeneralProperties());
        }
        if ((preferenceProps = RunConfiguration.getDriverPreferencesProperties()) != null && !preferenceProps.values().isEmpty()) {
            executionProps.putAll(RunConfiguration.getDriverPreferencesProperties());
        }
        return executionProps;
    }

    public static TestSuiteExecutedEntity getRerunExecutedEntity(TestSuiteExecutedEntity prevExecuted, ILauncherResult prevResult) throws IOException, Exception {
        TestSuiteEntity testSuite = null;
        try {
            testSuite = TestSuiteController.getInstance().getTestSuiteByDisplayId(prevExecuted.getSourceId(), ProjectController.getInstance().getCurrentProject());
        }
        catch (Exception e) {
            LogUtil.logError((Throwable)e);
            return null;
        }
        DefaultRerunSetting rerunSetting = new DefaultRerunSetting(prevExecuted.getPreviousRerunTimes() + 1, prevExecuted.getRemainingRerunTimes() - 1, prevExecuted.isRerunFailedTestCasesOnly());
        rerunSetting.setRerunFailedTestCaseAndTestDataOnly(prevExecuted.getRerunSetting().isRerunFailedTestCasesAndTestDataOnly());
        rerunSetting.setRerunImmediately(prevExecuted.getRerunSetting().isRerunImmediately());
        TestSuiteExecutedEntity newExecutedEntity = new TestSuiteExecutedEntity(testSuite, rerunSetting);
        newExecutedEntity.setReportLocation(prevExecuted.getReportLocationSetting());
        newExecutedEntity.setTestDataMap(prevExecuted.getTestDataMap());
        newExecutedEntity.setFailedThreshold(prevExecuted.getFailedThreshold());
        newExecutedEntity.setEmailConfig(prevExecuted.getEmailConfig(ProjectController.getInstance().getCurrentProject()));
        List<IExecutedEntity> prevTestCaseExecutedEntities = prevExecuted.getExecutedItems();
        ArrayList<IExecutedEntity> newTestCaseExecutedEntities = new ArrayList<IExecutedEntity>();
        if (prevExecuted.isRerunFailedTestCasesOnly()) {
            TestStatus.TestStatusValue[] prevResultValues = prevResult.getResultValues();
            int rsIdx = 0;
            for (IExecutedEntity prevExecutedItem : prevTestCaseExecutedEntities) {
                TestCaseExecutedEntity prevExecutedTC = null;
                if (prevExecutedItem instanceof TestCaseExecutedEntity) {
                    prevExecutedTC = (TestCaseExecutedEntity)prevExecutedItem;
                }
                if (prevExecutedItem instanceof TestCaseBindingExecutedEntity) {
                    TestCaseBindingExecutedEntity prevExecutedBindingTC = (TestCaseBindingExecutedEntity)prevExecutedItem;
                    prevExecutedTC = (TestCaseExecutedEntity)prevExecutedBindingTC.getExecutedItems().get(0);
                }
                int failedIterationsNumber = 0;
                int i = rsIdx;
                while (i < rsIdx + prevExecutedTC.getLoopTimes()) {
                    if (prevResultValues[i] == TestStatus.TestStatusValue.FAILED || prevResultValues[i] == TestStatus.TestStatusValue.ERROR) {
                        ++failedIterationsNumber;
                    }
                    ++i;
                }
                if (failedIterationsNumber > 0) {
                    TestCaseExecutedEntity updatedExecutedEntity = new TestCaseExecutedEntity((TestCaseEntity)prevExecutedTC.getEntity());
                    updatedExecutedEntity.setLoopTimes(failedIterationsNumber);
                    ExecutedEntity executedEntityToRerun = updatedExecutedEntity;
                    if (prevExecutedItem instanceof TestCaseBindingExecutedEntity) {
                        TestCaseBindingExecutedEntity prevExecutedBindingTC = (TestCaseBindingExecutedEntity)prevExecutedItem;
                        TestCaseBindingExecutedEntity updatedExecutedBindingEntity = new TestCaseBindingExecutedEntity((TestCaseEntity)prevExecutedBindingTC.getEntity());
                        updatedExecutedBindingEntity.setTestCaseExecutedEntity(updatedExecutedEntity);
                        executedEntityToRerun = updatedExecutedBindingEntity;
                    }
                    newTestCaseExecutedEntities.add(executedEntityToRerun);
                }
                rsIdx += prevExecutedTC.getLoopTimes();
            }
            newExecutedEntity.setTestCaseExecutedEntities(newTestCaseExecutedEntities);
        } else {
            newExecutedEntity.setTestCaseExecutedEntities(prevTestCaseExecutedEntities);
        }
        return newExecutedEntity;
    }

    public static void savePropertiesFile(Map<String, String> propertiesMap, String fileLocation) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (FileOutputStream output = new FileOutputStream(fileLocation);){
            LinkedProperties prop = new LinkedProperties();
            for (Map.Entry<String, String> propertyEntry : propertiesMap.entrySet()) {
                prop.setProperty(propertyEntry.getKey(), propertyEntry.getValue());
            }
            prop.store((Writer)new BufferedWriter(new OutputStreamWriter((OutputStream)output, "UTF-8".toLowerCase())), null);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static int countNumTestSteps(ILogRecord[] records) {
        return ExecutionUtil.recursiveCountNumTestSteps(records);
    }

    private static int recursiveCountNumTestSteps(ILogRecord[] records) {
        if (records == null || records.length <= 0) {
            return 0;
        }
        int numTestSteps = Arrays.stream(records).mapToInt(recordI -> ExecutionUtil.recursiveCountNumTestSteps(recordI)).reduce(0, (totalSteps, numStepsOfRecordI) -> totalSteps + numStepsOfRecordI);
        return numTestSteps;
    }

    private static int recursiveCountNumTestSteps(ILogRecord record) {
        if (record == null) {
            return 0;
        }
        if (record instanceof TestCaseLogRecord) {
            return ExecutionUtil.recursiveCountNumTestSteps(record.getChildRecords());
        }
        if (!(record instanceof TestStepLogRecord)) {
            return 0;
        }
        if (((TestStepLogRecord)record).getIndex() <= 0) {
            int numChildSteps = ExecutionUtil.recursiveCountNumTestSteps(record.getChildRecords());
            return numChildSteps;
        }
        if (!record.hasChildRecords()) {
            return 1;
        }
        int numChildSteps = ExecutionUtil.recursiveCountNumTestSteps(record.getChildRecords());
        return numChildSteps == 0 ? 1 : numChildSteps;
    }

    public static void resetHostName() {
        hostname = null;
    }

    public static String getTestSuiteCollectionId(String testSuiteCollectionFullPath) {
        String splitPosition = OSUtil.isWindows() ? "\\Test Suite" : "/Test Suite";
        int startingIndex = testSuiteCollectionFullPath.indexOf(splitPosition);
        String testSuiteCollectionId = "";
        if (startingIndex != -1) {
            testSuiteCollectionId = testSuiteCollectionFullPath.substring(++startingIndex, testSuiteCollectionFullPath.length() - 3);
        }
        return OSUtil.isWindows() ? testSuiteCollectionId.replace("\\", "/") : testSuiteCollectionId;
    }
}

