/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.execution.util;

import com.kms.katalon.controller.GlobalVariableController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.core.logging.model.TestSuiteLogRecord;
import com.kms.katalon.core.setting.ReportFormatType;
import com.kms.katalon.core.util.StrSubstitutor;
import com.kms.katalon.entity.global.ExecutionProfileEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.report.ReportCollectionEntity;
import com.kms.katalon.entity.report.ReportItemDescription;
import com.kms.katalon.execution.constants.ExecutionMessageConstants;
import com.kms.katalon.execution.entity.EmailConfig;
import com.kms.katalon.execution.entity.TestSuiteExecutedEntity;
import com.kms.katalon.execution.setting.EmailSettingStore;
import com.kms.katalon.execution.setting.EmailVariableBinding;
import com.kms.katalon.execution.webservice.VariableEvaluator;
import com.kms.katalon.groovy.util.GroovyStringUtil;
import com.kms.katalon.logging.LogUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.net.URISyntaxException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Authenticator;
import javax.mail.Session;
import net.lingala.zip4j.core.ZipFile;
import net.lingala.zip4j.model.ZipParameters;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.mail.DefaultAuthenticator;
import org.apache.commons.mail.EmailAttachment;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.HtmlEmail;
import org.testng.collections.Maps;

public class MailUtil {
    private static final long EMAIL_WARNING_SIZE = 0xA00000L;
    private static final int EMAIL_TIMEOUT = 600000;
    public static final String EMAIL_SEPARATOR = ";";

    public static String[][] getMailSecurityProtocolTypeArrayValues() {
        MailSecurityProtocolType[] allSecurityProtocolTypes = MailSecurityProtocolType.values();
        String[][] arrayValues = new String[allSecurityProtocolTypes.length][2];
        int i = 0;
        while (i < allSecurityProtocolTypes.length) {
            arrayValues[i][0] = allSecurityProtocolTypes[i].toString();
            arrayValues[i][1] = allSecurityProtocolTypes[i].toString();
            ++i;
        }
        return arrayValues;
    }

    public static void sendTestMail(EmailConfig conf) throws Exception {
        HtmlEmail email = MailUtil.initEmail(conf);
        String htmlBody = MailUtil.overrideGlobalVariableEmailBody(conf, null, conf.getHtmlTemplateForTestSuite(), GlobalVariableController.getInstance().getDefaultExecutionProfile(ProjectController.getInstance().getCurrentProject()));
        email.setHtmlMsg("<html>" + GroovyStringUtil.evaluate((String)htmlBody, EmailVariableBinding.getTestEmailVariables()) + "</html>");
        MailUtil.sendEmail(email);
    }

    private static void sendEmail(HtmlEmail email) throws EmailException {
        Thread.currentThread().setContextClassLoader(Session.class.getClassLoader());
        email.send();
        String msg = String.format("Sent email to the server : %s : %s", email.getHostName(), email.getSmtpPort());
        LogUtil.logInfo((String)msg);
    }

    private static HtmlEmail initEmail(EmailConfig conf) throws EmailException {
        String bcc;
        HtmlEmail email = new HtmlEmail();
        email.setCharset("utf-8");
        email.setHostName(conf.getHost());
        email.setFrom(conf.getFrom(), "");
        email.setSubject(conf.getSubject());
        String cc = conf.getCc();
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)cc)) {
            email.addCc(org.apache.commons.lang3.StringUtils.split((String)cc, (String)EMAIL_SEPARATOR));
        }
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)(bcc = conf.getBcc()))) {
            email.addBcc(org.apache.commons.lang3.StringUtils.split((String)bcc, (String)EMAIL_SEPARATOR));
        }
        email.addTo(conf.getTos());
        email.setSubject(conf.getSubject());
        email.setSocketConnectionTimeout(600000);
        email.setSocketTimeout(600000);
        email.setAuthenticator((Authenticator)new DefaultAuthenticator(conf.getUsername(), conf.getPassword()));
        switch (conf.getSecurityProtocol()) {
            case None: {
                email.setSmtpPort(Integer.parseInt(conf.getPort()));
                break;
            }
            case SSL: {
                email.setSSLOnConnect(true);
                email.setSslSmtpPort(conf.getPort());
                break;
            }
            case TLS: {
                email.setStartTLSEnabled(true);
                email.setSmtpPort(Integer.parseInt(conf.getPort()));
                break;
            }
        }
        return email;
    }

    public static void sendSummaryMailForTestSuite(EmailConfig conf, TestSuiteLogRecord suiteLogRecord, Map<String, Object> variables, ExecutionProfileEntity executionProfile) throws Exception {
        if (conf == null || !conf.canSend()) {
            return;
        }
        HtmlEmail email = MailUtil.initEmail(conf);
        EmailAttachment attachment = null;
        File attachedFile = null;
        if (conf.isSendAttachmentEnable() && (attachment = MailUtil.attach(conf.getAttachmentOptions(), suiteLogRecord)) != null) {
            attachedFile = new File(attachment.getURL().toURI());
            email.attach((DataSource)new FileDataSource(attachedFile), attachment.getName(), attachment.getDescription(), attachment.getDisposition());
        }
        String htmlBody = MailUtil.overrideGlobalVariableEmailBody(conf, variables, conf.getHtmlTemplateForTestSuite(), executionProfile);
        email.setHtmlMsg("<html>" + GroovyStringUtil.evaluate((String)htmlBody, variables) + "</html>");
        try {
            MailUtil.sendEmail(email);
        }
        finally {
            if (attachment != null) {
                try {
                    FileUtils.forceDelete((File)attachedFile);
                }
                catch (IOException e) {
                    LogUtil.logError((Throwable)e);
                }
            }
        }
    }

    private static EmailAttachment attach(List<ReportFormatType> attachmentOptions, TestSuiteLogRecord suiteLogRecord) throws Exception {
        File logFolder = new File(suiteLogRecord.getLogFolder());
        File tmpReportDir = new File(System.getProperty("java.io.tmpdir"), String.valueOf(logFolder.getName()) + "_" + System.currentTimeMillis());
        if (tmpReportDir.exists()) {
            tmpReportDir.delete();
        }
        tmpReportDir.mkdir();
        File[] fileArray = logFolder.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            String fileName = f.getName();
            if (fileName.endsWith(".html") && attachmentOptions.contains(ReportFormatType.HTML) || fileName.endsWith(".csv") && attachmentOptions.contains(ReportFormatType.CSV) || MailUtil.isLogFile(fileName) && attachmentOptions.contains(ReportFormatType.LOG) || fileName.endsWith(".pdf") && attachmentOptions.contains(ReportFormatType.PDF) || fileName.endsWith(".png") && attachmentOptions.contains(ReportFormatType.PNG)) {
                FileUtils.copyFileToDirectory((File)f, (File)tmpReportDir);
            }
            ++n2;
        }
        if (tmpReportDir.listFiles() != null && tmpReportDir.listFiles().length > 0) {
            File zipFile = MailUtil.zip(tmpReportDir.getAbsolutePath(), tmpReportDir.getName());
            if (zipFile.length() > 0xA00000L) {
                LogUtil.printOutputLine((String)ExecutionMessageConstants.MSG_EMAIL_ATTACHMENT_EXCEEDS_SIZE);
            }
            EmailAttachment attachment = new EmailAttachment();
            attachment.setName(zipFile.getName());
            attachment.setURL(zipFile.toURI().toURL());
            attachment.setDisposition("attachment");
            return attachment;
        }
        return null;
    }

    public static void sendSummaryMailForTestSuiteCollection(EmailConfig conf, ReportCollectionEntity reportEntity, Map<String, Object> variables) throws Exception {
        if (conf == null || !conf.canSend()) {
            return;
        }
        HtmlEmail email = MailUtil.initEmail(conf);
        EmailAttachment attachment = MailUtil.addAttachment(email, conf, reportEntity);
        String htmlBody = MailUtil.overrideGlobalVariableEmailBody(conf, variables, conf.getHtmlTemplateForTestSuiteCollection(), GlobalVariableController.getInstance().getDefaultExecutionProfile(ProjectController.getInstance().getCurrentProject()));
        email.setHtmlMsg("<html>" + GroovyStringUtil.evaluate((String)htmlBody, variables) + "</html>");
        try {
            MailUtil.sendEmail(email);
        }
        finally {
            if (attachment != null) {
                try {
                    FileUtils.forceDelete((File)new File(attachment.getURL().toURI()));
                }
                catch (IOException e) {
                    LogUtil.logError((Throwable)e);
                }
            }
        }
    }

    private static EmailAttachment addAttachment(HtmlEmail email, EmailConfig conf, ReportCollectionEntity reportEntity) throws Exception {
        EmailAttachment attachment = null;
        if (conf.isSendAttachmentEnable()) {
            File tmpReportDir = MailUtil.prepareAttachmentFiles(reportEntity, conf.getAttachmentOptions());
            if (tmpReportDir != null && tmpReportDir.listFiles() != null && tmpReportDir.listFiles().length > 0) {
                File zipFile = MailUtil.zip(tmpReportDir.getAbsolutePath(), tmpReportDir.getName());
                if (zipFile.length() > 0xA00000L) {
                    LogUtil.printOutputLine((String)ExecutionMessageConstants.MSG_EMAIL_ATTACHMENT_EXCEEDS_SIZE);
                }
                attachment = new EmailAttachment();
                attachment.setName(zipFile.getName());
                attachment.setURL(zipFile.toURI().toURL());
                attachment.setDisposition("attachment");
                try {
                    FileUtils.forceDelete((File)tmpReportDir);
                }
                catch (IOException e) {
                    LogUtil.logError((Throwable)e);
                }
            }
            if (attachment != null) {
                File attachedFile = new File(attachment.getURL().toURI());
                email.attach((DataSource)new FileDataSource(attachedFile), attachment.getName(), attachment.getDescription(), attachment.getDisposition());
            }
        }
        return attachment;
    }

    private static File prepareAttachmentFiles(ReportCollectionEntity reportEntity, List<ReportFormatType> attachmentOptions) throws IOException {
        File tmpReportDir = Files.createTempDirectory("", new FileAttribute[0]).toFile();
        String projectFolder = reportEntity.getProject().getFolderLocation();
        List reportItemDescriptions = reportEntity.getReportItemDescriptions();
        HashSet<String> copiedPaths = new HashSet<String>();
        for (ReportItemDescription desc : reportItemDescriptions) {
            File copied = new File(projectFolder, desc.getReportLocation()).getParentFile().getParentFile();
            if (copiedPaths.contains(copied.getAbsolutePath())) continue;
            FileUtils.copyDirectoryToDirectory((File)copied, (File)tmpReportDir);
            copiedPaths.add(copied.getAbsolutePath());
        }
        Files.walk(Paths.get(tmpReportDir.toURI()), new FileVisitOption[0]).filter(path -> Files.isRegularFile(path, new LinkOption[0])).filter(p -> !MailUtil.attachmentIncludes(attachmentOptions, p.toFile())).map(Path::toFile).forEach(FileUtils::deleteQuietly);
        return tmpReportDir;
    }

    private static boolean attachmentIncludes(List<ReportFormatType> attachmentOptions, File file) {
        String fileName = file.getName();
        return fileName.endsWith(".html") && attachmentOptions.contains(ReportFormatType.HTML) || fileName.endsWith(".csv") && attachmentOptions.contains(ReportFormatType.CSV) || MailUtil.isLogFile(fileName) && attachmentOptions.contains(ReportFormatType.LOG) || fileName.endsWith(".pdf") && attachmentOptions.contains(ReportFormatType.PDF) || fileName.endsWith(".png") && attachmentOptions.contains(ReportFormatType.PNG) || "JUnit_Report.xml".equals(fileName);
    }

    private static boolean isLogFile(String fileName) {
        return fileName.endsWith(".log") || fileName.endsWith(".meta") || fileName.endsWith("execution.properties");
    }

    private static File zip(String directory, String zipName) throws Exception {
        File folder = new File(directory);
        if (folder.isDirectory()) {
            File file = new File(String.valueOf(folder.getParent()) + File.separator + zipName + ".zip");
            if (file.exists()) {
                file.delete();
            }
            ZipFile zipFile = new ZipFile(String.valueOf(folder.getParent()) + File.separator + zipName + ".zip");
            ZipParameters parameters = new ZipParameters();
            parameters.setCompressionMethod(8);
            parameters.setCompressionLevel(5);
            zipFile.addFolder(directory, parameters);
            return new File(String.valueOf(folder.getParent()) + File.separator + zipName + ".zip");
        }
        return null;
    }

    public static List<String> splitRecipientsString(String recipients) {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)recipients)) {
            return Collections.emptyList();
        }
        return Arrays.asList(StringUtils.split((String)org.apache.commons.lang3.StringUtils.deleteWhitespace((String)recipients), (String)EMAIL_SEPARATOR));
    }

    public static Set<String> getDistinctRecipients(String ... recipientsList) {
        if (recipientsList == null) {
            return Collections.emptySet();
        }
        LinkedHashSet<String> recipientCollector = new LinkedHashSet<String>();
        String[] stringArray = recipientsList;
        int n = recipientsList.length;
        int n2 = 0;
        while (n2 < n) {
            String recipients = stringArray[n2];
            recipientCollector.addAll(MailUtil.splitRecipientsString(recipients));
            ++n2;
        }
        return recipientCollector;
    }

    public static EmailConfig getDefaultEmailConfig(ProjectEntity project) {
        if (project == null) {
            return null;
        }
        EmailSettingStore store = new EmailSettingStore(project);
        try {
            boolean encryptionEnabled = store.isEncryptionEnabled();
            EmailConfig conf = new EmailConfig();
            conf.setHost(store.getHost(encryptionEnabled));
            conf.setPort(store.getPort(encryptionEnabled));
            String sender = store.getSender();
            if (store.useUsernameAsSender()) {
                sender = store.getUsername(encryptionEnabled);
            }
            conf.setFrom(sender);
            conf.setSecurityProtocol(MailSecurityProtocolType.valueOf(store.getProtocol(encryptionEnabled)));
            conf.setUsername(store.getUsername(encryptionEnabled));
            conf.setPassword(store.getPassword(encryptionEnabled));
            conf.setSignature(store.getSignature());
            conf.setSendAttachment(store.isAddAttachment());
            conf.setCc(store.getEmailCc());
            conf.setBcc(store.getEmailBcc());
            conf.addRecipients(MailUtil.splitRecipientsString(store.getRecipients(encryptionEnabled)));
            conf.setSubject(store.getEmailSubject());
            conf.setHtmTemplateForTestSuite(store.getEmailHTMLTemplateForTestSuite());
            conf.setAttachmentOptions(store.getReportFormatOptions());
            conf.setSendTestSuiteReportEnabled(store.isSendTestSuiteReportEnabled());
            conf.setSendReportTestFailedOnly(store.isSendEmailTestFailedOnly());
            conf.setHtmlTemplateForTestSuiteCollection(store.getEmailHTMLTemplateForTestSuiteCollection());
            conf.setSendTestSuiteCollectionReportEnabled(store.isSendTestSuiteCollectionReportEnabled());
            conf.setSkipInvidiualTestSuiteReport(store.isSkipInvidualTestSuiteReport());
            return conf;
        }
        catch (IOException | URISyntaxException | GeneralSecurityException e) {
            LogUtil.logError((Throwable)e);
            return null;
        }
    }

    private static String overrideGlobalVariableEmailBody(EmailConfig emailConfig, Map<String, Object> overridingGlobalVariables, String emailBody, ExecutionProfileEntity executionProfile) {
        StrSubstitutor substitutor = MailUtil.getStrSubstitutor(emailConfig, overridingGlobalVariables, executionProfile);
        BufferedReader bufReader = new BufferedReader(new StringReader(emailBody));
        StringBuilder stringBuilder = new StringBuilder();
        String line = null;
        try {
            while ((line = bufReader.readLine()) != null) {
                stringBuilder.append(String.valueOf(substitutor.replace(line)) + "\n");
            }
        }
        catch (IOException e) {
            LogUtil.printAndLogError((Throwable)e);
        }
        return stringBuilder.toString();
    }

    private static StrSubstitutor getStrSubstitutor(EmailConfig emailConfig, Map<String, Object> overridingGlobalVariables, ExecutionProfileEntity executionProfile) {
        VariableEvaluator evaluator = new VariableEvaluator();
        Map<Object, Object> evaluatedVariables = new HashMap();
        try {
            evaluatedVariables = evaluator.evaluate(new HashMap<String, String>(), executionProfile, overridingGlobalVariables);
        }
        catch (Exception e) {
            LogUtil.printAndLogError((Throwable)e);
        }
        return new StrSubstitutor(Collections.unmodifiableMap(evaluatedVariables));
    }

    public static EmailConfig overrideEmailSettings(EmailConfig emailConfig, ExecutionProfileEntity executionProfile, Map<String, Object> overridingGlobalVariables) {
        Map<String, Object> evaluatedVariables;
        VariableEvaluator evaluator = new VariableEvaluator();
        try {
            evaluatedVariables = evaluator.evaluate(Maps.newHashMap(), executionProfile, overridingGlobalVariables);
        }
        catch (Exception exception) {
            evaluatedVariables = new HashMap<String, Object>();
        }
        evaluatedVariables.putAll(overridingGlobalVariables);
        StrSubstitutor substitutor = new StrSubstitutor(Collections.unmodifiableMap(evaluatedVariables));
        emailConfig.setFrom(substitutor.replace(emailConfig.getFrom()));
        Set<String> tos = Stream.of(emailConfig.getTos()).map(arg_0 -> ((StrSubstitutor)substitutor).replace(arg_0)).collect(Collectors.toSet());
        emailConfig.setTos(tos);
        emailConfig.setCc(substitutor.replace(emailConfig.getCc()));
        emailConfig.setBcc(substitutor.replace(emailConfig.getBcc()));
        emailConfig.setSubject(substitutor.replace(emailConfig.getSubject()));
        return emailConfig;
    }

    public static int getNumberOfEmailsSentForTestSuite(boolean areEmailsSent, TestSuiteExecutedEntity tsExecutedEntity, TestSuiteLogRecord tsLogRecord) {
        int numberOfEmailsSent = 0;
        EmailConfig emailConfig = tsExecutedEntity.getEmailSettings().getEmailConfig();
        if (tsExecutedEntity.isInCollection() && emailConfig.isSendTestSuiteReportEnabled()) {
            if (!emailConfig.isSendTestSuiteCollectionReportEnabled() || !emailConfig.isSkipInvidiualTestSuiteReport()) {
                numberOfEmailsSent = MailUtil.getNumberOfEmailsSent(areEmailsSent, emailConfig);
            }
        } else if (emailConfig.isSendTestSuiteReportEnabled() && (!emailConfig.isSendReportTestFailedOnly() || tsLogRecord.getStatus() == null || tsLogRecord.getTotalFailedTestCases() > 0)) {
            numberOfEmailsSent = MailUtil.getNumberOfEmailsSent(areEmailsSent, emailConfig);
        }
        return numberOfEmailsSent;
    }

    public static int getNumberOfEmailsSentForTestSuiteCollection(boolean areEmailsSent, EmailConfig emailConfig) {
        int numberOfEmailsSent = 0;
        if (emailConfig.isSendTestSuiteCollectionReportEnabled()) {
            numberOfEmailsSent = MailUtil.getNumberOfEmailsSent(areEmailsSent, emailConfig);
        }
        return numberOfEmailsSent;
    }

    public static int getNumberOfEmailsSent(boolean areEmailsSent, EmailConfig emailConfig) {
        if (!areEmailsSent) {
            return 0;
        }
        ArrayList allEmails = new ArrayList();
        if (emailConfig.getTos().length != 0) {
            Collections.addAll(allEmails, emailConfig.getTos());
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)emailConfig.getCc())) {
            Collections.addAll(allEmails, emailConfig.getCc().split(EMAIL_SEPARATOR));
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)emailConfig.getBcc())) {
            Collections.addAll(allEmails, emailConfig.getBcc().split(EMAIL_SEPARATOR));
        }
        HashSet allUniqueEmails = new HashSet(allEmails);
        return allUniqueEmails.size();
    }

    public static enum MailSecurityProtocolType {
        None,
        SSL,
        TLS;


        public static String[] getStringValues() {
            MailSecurityProtocolType[] allSecurityProtocolTypes = MailSecurityProtocolType.values();
            String[] stringValues = new String[allSecurityProtocolTypes.length];
            int index = 0;
            while (index < allSecurityProtocolTypes.length) {
                stringValues[index] = allSecurityProtocolTypes[index].toString();
                ++index;
            }
            return stringValues;
        }
    }
}

