/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.execution.util;

import com.kms.katalon.core.network.ProxyInformation;
import com.kms.katalon.execution.preferences.ProxyPreferences;
import com.kms.katalon.execution.util.ExecutionProxyUtil;
import com.kms.katalon.logging.LogUtil;

public class ProxyInformationUtil {
    public static void printCurrentProxyInformation() {
        boolean isUseNewProxyConfig;
        if (!ExecutionProxyUtil.isConfigProxy()) {
            return;
        }
        LogUtil.logInfo((String)"INFO: [Proxy Configurations]");
        boolean isUseAuthProxy = ProxyPreferences.isAuthProxyPreferencesSet();
        boolean isUseSystemProxy = ProxyPreferences.isSystemProxyPreferencesSet();
        boolean bl = isUseNewProxyConfig = isUseAuthProxy || isUseSystemProxy;
        if (isUseNewProxyConfig) {
            ProxyInformationUtil.printAuthProxyInfo();
            ProxyInformationUtil.printSystemProxyInfo();
        } else {
            ProxyInformationUtil.printLegacyProxyInfo();
        }
        LogUtil.logInfo((String)"\n");
    }

    public static void printLegacyProxyInfo() {
        String rawLegacyProxyInfo = ProxyInformationUtil.getRawProxyInfo(ExecutionProxyUtil.getProxyInformation());
        LogUtil.logInfo((String)("INFO: > Legacy Proxy: " + rawLegacyProxyInfo));
    }

    public static void printAuthProxyInfo() {
        String rawAuthProxyInfo = ProxyInformationUtil.getRawProxyInfo(ExecutionProxyUtil.getAuthProxyInformation());
        LogUtil.logInfo((String)("INFO: > Authentication Proxy: " + rawAuthProxyInfo));
    }

    public static void printSystemProxyInfo() {
        String rawSystemProxyInfo = ProxyInformationUtil.getRawProxyInfo(ExecutionProxyUtil.getSystemProxyInformation(), true);
        LogUtil.logInfo((String)("INFO: > System Proxy: " + rawSystemProxyInfo));
    }

    public static String getRawProxyInfo(ProxyInformation proxyInfo) {
        return ProxyInformationUtil.getRawProxyInfo(proxyInfo, false);
    }

    public static String getRawProxyInfo(ProxyInformation proxyInfo, boolean isSystemProxy) {
        String rawProxyInfo = "{ proxyOption=" + proxyInfo.getProxyOption() + ", " + "proxyServerType=" + proxyInfo.getProxyServerType() + ", " + "proxyServerAddress=" + proxyInfo.getProxyServerAddress() + ", " + "proxyServerPort=" + proxyInfo.getProxyServerPort() + ", " + "username=" + proxyInfo.getUsername() + ", " + "password=" + "********" + ", " + "executionList=\"" + proxyInfo.getExceptionList() + "\"" + (isSystemProxy ? ", isApplyToDesiredCapabilities=" + proxyInfo.isApplyToDesiredCapabilities() : "") + " }";
        return rawProxyInfo;
    }
}

