/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.keyword.handlers;

import com.kms.katalon.composer.components.impl.tree.FolderTreeEntity;
import com.kms.katalon.composer.components.impl.tree.KeywordTreeEntity;
import com.kms.katalon.composer.components.impl.tree.PackageTreeEntity;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.composer.explorer.parts.ExplorerPart;
import com.kms.katalon.composer.keyword.constants.StringConstants;
import com.kms.katalon.composer.keyword.dialogs.NewJavaClassDialog;
import com.kms.katalon.composer.keyword.handlers.NewStepDefinitionHandler;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.groovy.util.GroovyUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.HashMap;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.text.StrSubstitutor;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class NewJavaClassHandler {
    @Inject
    private IEventBroker eventBroker;

    @Execute
    public boolean canExecute() {
        return ProjectController.getInstance().getCurrentProject() != null;
    }

    @Execute
    public void execute(@Named(value="activeShell") @Named(value="activeShell") Shell parentShell) {
        try {
            Object[] selectedObjects = ExplorerPart.getInstance().getSelectedTreeEntities().toArray();
            ITreeEntity parentTreeEntity = NewStepDefinitionHandler.findParentTreeEntity(selectedObjects);
            IPackageFragment packageFragment = null;
            IPackageFragmentRoot rootPackage = null;
            IProject groovyProject = GroovyUtil.getGroovyProject((ProjectEntity)ProjectController.getInstance().getCurrentProject());
            if (parentTreeEntity instanceof FolderTreeEntity) {
                FolderEntity folder = (FolderEntity)parentTreeEntity.getObject();
                rootPackage = JavaCore.create((IProject)groovyProject).getPackageFragmentRoot((IResource)groovyProject.getFolder(folder.getRelativePath()));
                String packagePath = groovyProject.getFolder(folder.getRelativePath()).getFullPath().toString().replaceFirst(rootPackage.getPath().toString(), "");
                packageFragment = rootPackage.getPackageFragment(packagePath);
                FolderTreeEntity cfr_ignored_0 = (FolderTreeEntity)parentTreeEntity;
            } else if (parentTreeEntity instanceof PackageTreeEntity) {
                packageFragment = (IPackageFragment)parentTreeEntity.getObject();
                rootPackage = (IPackageFragmentRoot)packageFragment.getParent();
                FolderTreeEntity cfr_ignored_1 = (FolderTreeEntity)parentTreeEntity.getParent();
            }
            NewJavaClassDialog dialog = new NewJavaClassDialog(parentShell, rootPackage, packageFragment);
            dialog.open();
            if (dialog.getReturnCode() == 0) {
                int kwFilePathLength = dialog.getParentPackage().getElementName().length() + dialog.getName().length();
                if (kwFilePathLength > 255) {
                    MessageDialog.openError((Shell)parentShell, (String)StringConstants.ERROR_TITLE, (String)MessageFormat.format(StringConstants.HAND_ERROR_MSG_EXCEED_CLASS_NAME_LENGTH, kwFilePathLength, 255));
                    return;
                }
                packageFragment = dialog.getParentPackage();
                NullProgressMonitor monitor = new NullProgressMonitor();
                monitor.setTaskName("Create Java Class");
                if (!packageFragment.exists()) {
                    monitor.subTask("Create Package");
                    packageFragment = rootPackage.createPackageFragment(packageFragment.getElementName(), true, (IProgressMonitor)monitor);
                    ICompilationUnit[] iCompilationUnitArray = packageFragment.getCompilationUnits();
                    int n = iCompilationUnitArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ICompilationUnit compicationUnit = iCompilationUnitArray[n2];
                        compicationUnit.discardWorkingCopy();
                        ++n2;
                    }
                }
                ICompilationUnit createdCompilationUnit = this.createJavaClass(packageFragment, dialog.getName());
                this.eventBroker.send("EXPLORER/REFRESH_TREE_ENTITY", (Object)parentTreeEntity);
                KeywordTreeEntity keywordEntity = new KeywordTreeEntity(createdCompilationUnit, parentTreeEntity);
                this.eventBroker.post("EXPLORER/SET_SELECTED_ITEM", (Object)keywordEntity);
                this.eventBroker.post("EXPLORER/OPEN_SELECTED_ITEM", (Object)createdCompilationUnit);
            }
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    private ICompilationUnit createJavaClass(IPackageFragment parentPackage, String typeName) throws IOException {
        String packageName = "";
        if (!parentPackage.getElementName().equals("")) {
            packageName = "package " + parentPackage.getElementName() + ";";
        }
        String javaTemplateContent = this.getFileContent("resources/template/java_class.tpl");
        HashMap<String, String> valuePlaceholder = new HashMap<String, String>();
        valuePlaceholder.put("package", packageName);
        valuePlaceholder.put("class", typeName);
        String javaFileContent = StrSubstitutor.replace((Object)javaTemplateContent, valuePlaceholder);
        File newJavaFile = new File(parentPackage.getResource().getRawLocation().toFile(), String.valueOf(typeName) + ".java");
        FileUtils.write((File)newJavaFile, (CharSequence)javaFileContent, (Charset)StandardCharsets.UTF_8);
        return parentPackage.getCompilationUnit(String.valueOf(typeName) + ".java");
    }

    private String getFileContent(String filePath) {
        URL url = FileLocator.find((Bundle)FrameworkUtil.getBundle(NewJavaClassHandler.class), (IPath)new Path(filePath), null);
        try {
            return StringUtils.join((Iterable)IOUtils.readLines((InputStream)new BufferedInputStream(url.openStream()), (String)"UTF-8"), (String)"\n");
        }
        catch (IOException e) {
            LoggerSingleton.logError((Throwable)e);
            return "";
        }
    }
}

