/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.keyword.handlers;

import com.kms.katalon.composer.components.impl.handler.KSEFeatureAccessHandler;
import com.kms.katalon.composer.components.impl.tree.FolderTreeEntity;
import com.kms.katalon.composer.components.impl.tree.KeywordTreeEntity;
import com.kms.katalon.composer.components.impl.tree.PackageTreeEntity;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.composer.keyword.constants.StringConstants;
import com.kms.katalon.composer.keyword.dialogs.NewKeywordDialog;
import com.kms.katalon.composer.util.groovy.GroovyGuiUtil;
import com.kms.katalon.controller.FolderController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.feature.FeatureServiceConsumer;
import com.kms.katalon.feature.IFeatureService;
import com.kms.katalon.feature.KSEFeature;
import com.kms.katalon.groovy.util.GroovyUtil;
import com.kms.katalon.tracking.service.Trackings;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.MessageFormat;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.jdt.groovy.model.GroovyCompilationUnit;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.services.internal.events.EventBroker;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class NewKeywordHandler {
    @Inject
    private EventBroker eventBroker;
    @Inject
    private ESelectionService selectionService;
    private FolderTreeEntity keywordTreeRoot;
    private IFeatureService featureService = FeatureServiceConsumer.getServiceInstance();

    @CanExecute
    private boolean canExecute() {
        return ProjectController.getInstance().getCurrentProject() != null;
    }

    @Execute
    public void execute(@Named(value="activeShell") @Named(value="activeShell") Shell parentShell) {
        try {
            if (!this.featureService.canUse(KSEFeature.CUSTOM_KEYWORD)) {
                KSEFeatureAccessHandler.handleUnauthorizedAccess((KSEFeature)KSEFeature.CUSTOM_KEYWORD);
                return;
            }
            Object[] selectedObjects = (Object[])this.selectionService.getSelection("com.kms.katalon.composer.part.explorer");
            ITreeEntity parentTreeEntity = NewKeywordHandler.findParentTreeEntity(selectedObjects);
            if (parentTreeEntity == null) {
                parentTreeEntity = this.keywordTreeRoot;
            }
            IPackageFragment packageFragment = null;
            packageFragment = parentTreeEntity != null && parentTreeEntity instanceof PackageTreeEntity ? (IPackageFragment)parentTreeEntity.getObject() : GroovyUtil.getDefaultPackageForKeyword((ProjectEntity)ProjectController.getInstance().getCurrentProject());
            if (packageFragment != null) {
                IProject groovyProject = GroovyUtil.getGroovyProject((ProjectEntity)ProjectController.getInstance().getCurrentProject());
                IPackageFragmentRoot rootPackage = JavaCore.create((IProject)groovyProject).getPackageFragmentRoot((IResource)groovyProject.getFolder(StringConstants.ROOT_FOLDER_NAME_KEYWORD));
                packageFragment.getResource().refreshLocal(1, null);
                NewKeywordDialog dialog = new NewKeywordDialog(parentShell, rootPackage, packageFragment);
                dialog.open();
                if (dialog.getReturnCode() == 0) {
                    ICompilationUnit createdCompilationUnit;
                    int kwFilePathLength = dialog.getParentPackage().getElementName().length() + dialog.getName().length();
                    if (kwFilePathLength > 255) {
                        MessageDialog.openError((Shell)parentShell, (String)StringConstants.ERROR_TITLE, (String)MessageFormat.format(StringConstants.HAND_ERROR_MSG_EXCEED_CLASS_NAME_LENGTH, kwFilePathLength, 255));
                        return;
                    }
                    packageFragment = dialog.getParentPackage();
                    NullProgressMonitor monitor = new NullProgressMonitor();
                    monitor.setTaskName("Create Keyword");
                    if (!packageFragment.exists()) {
                        monitor.subTask("Create Package");
                        packageFragment = rootPackage.createPackageFragment(packageFragment.getElementName(), true, (IProgressMonitor)monitor);
                        ICompilationUnit[] iCompilationUnitArray = packageFragment.getCompilationUnits();
                        int n = iCompilationUnitArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            ICompilationUnit compicationUnit = iCompilationUnitArray[n2];
                            compicationUnit.discardWorkingCopy();
                            ++n2;
                        }
                    }
                    if (dialog.getSampleKeywordType() != 0) {
                        SampleCustomKeywordScriptBuilder sampleScriptBuilder = new SampleCustomKeywordScriptBuilder(dialog);
                        String sampleScript = sampleScriptBuilder.build();
                        createdCompilationUnit = GroovyGuiUtil.createGroovyScriptForCustomKeywordFromTemplate((IPackageFragment)packageFragment, (String)dialog.getName(), (String)sampleScript);
                    } else {
                        createdCompilationUnit = GroovyGuiUtil.createGroovyScriptForCustomKeyword((IPackageFragment)packageFragment, (String)dialog.getName());
                    }
                    Trackings.trackCreatingObject((String)"keyword");
                    if (createdCompilationUnit instanceof GroovyCompilationUnit && createdCompilationUnit.getParent() instanceof IPackageFragment) {
                        FolderTreeEntity keywordRootFolder = new FolderTreeEntity(FolderController.getInstance().getKeywordRoot(ProjectController.getInstance().getCurrentProject()), null);
                        PackageTreeEntity newPackageTreeEntity = new PackageTreeEntity(packageFragment, (ITreeEntity)keywordRootFolder);
                        KeywordTreeEntity keywordTreeEntity = new KeywordTreeEntity(createdCompilationUnit, (ITreeEntity)newPackageTreeEntity);
                        this.eventBroker.send("EXPLORER/REFRESH_TREE_ENTITY", (Object)keywordRootFolder);
                        this.eventBroker.send("EXPLORER/SET_SELECTED_ITEM", (Object)keywordTreeEntity);
                        this.eventBroker.post("EXPLORER/OPEN_SELECTED_ITEM", (Object)createdCompilationUnit);
                        this.eventBroker.post("EXPLORER/REFRESH_SELECTED_ITEM", (Object)keywordTreeEntity);
                    }
                    if (monitor.isCanceled()) {
                        throw new InterruptedException();
                    }
                }
            }
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
            MessageDialog.openError((Shell)parentShell, (String)StringConstants.ERROR_TITLE, (String)StringConstants.HAND_ERROR_MSG_UNABLE_TO_CREATE_KEYWORD);
        }
    }

    public static ITreeEntity findParentTreeEntity(Object[] selectedObjects) throws Exception {
        if (selectedObjects == null) {
            return null;
        }
        Object[] objectArray = selectedObjects;
        int n = selectedObjects.length;
        int n2 = 0;
        while (n2 < n) {
            Object entity = objectArray[n2];
            if (entity instanceof ITreeEntity) {
                Object entityObject = ((ITreeEntity)entity).getObject();
                if (entityObject instanceof IPackageFragment) {
                    PackageTreeEntity treeEntity = (PackageTreeEntity)entity;
                    FolderEntity parent = (FolderEntity)treeEntity.getParent().getObject();
                    if (parent.getFolderType() == FolderEntity.FolderType.KEYWORD) {
                        return (ITreeEntity)entity;
                    }
                    return null;
                }
                if (entityObject instanceof ICompilationUnit && ((ICompilationUnit)entityObject).getElementName().endsWith(".groovy")) {
                    PackageTreeEntity packageTreeEntity = (PackageTreeEntity)((ITreeEntity)entity).getParent();
                    FolderEntity parentFolder = (FolderEntity)packageTreeEntity.getParent().getObject();
                    if (parentFolder.getFolderType() == FolderEntity.FolderType.KEYWORD) {
                        return packageTreeEntity;
                    }
                    return null;
                }
                if (entityObject instanceof FolderEntity && ((FolderEntity)entityObject).getFolderType() == FolderEntity.FolderType.KEYWORD) {
                    return (ITreeEntity)entity;
                }
            }
            ++n2;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Inject
    @Optional
    private void catchKeywordFolderTreeEntitiesRoot(@UIEventTopic(value="EXPLORER/RELOAD_INPUT") List<Object> treeEntities) {
        try {
            for (Object o : treeEntities) {
                void folder;
                FolderEntity folderEntity;
                Object entityObject = ((ITreeEntity)o).getObject();
                Object object = entityObject;
                if (!(object instanceof FolderEntity) || (folderEntity = (FolderEntity)object) != (FolderEntity)object || folder.getFolderType() != FolderEntity.FolderType.KEYWORD) continue;
                this.keywordTreeRoot = (FolderTreeEntity)o;
                return;
            }
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    @Inject
    @Optional
    private void execute(@UIEventTopic(value="KEYWORD/NEW") Object eventData) {
        if (!this.canExecute()) {
            return;
        }
        this.execute(Display.getCurrent().getActiveShell());
    }

    private class SampleCustomKeywordScriptBuilder {
        private static final String COMMON_IMPORTS_FILE = "resources/template/common_imports.tpl";
        private static final String SAMPLE_WEB_KEYWORD_FILE = "resources/template/web_keyword.tpl";
        private static final String SAMPLE_MOBILE_KEYWORD_FILE = "resources/template/mobile_keyword.tpl";
        private static final String SAMPLE_API_KEYWORD_FILE = "resources/template/api_keyword.tpl";
        private final NewKeywordDialog dialog;

        public SampleCustomKeywordScriptBuilder(NewKeywordDialog dialog) {
            this.dialog = dialog;
        }

        public String build() {
            String imports = this.getFileContent(COMMON_IMPORTS_FILE);
            String keywords = this.buildKeywordScript();
            StringBuilder scriptBuilder = new StringBuilder();
            if (this.dialog.getParentPackage().getElementName().equals("")) {
                scriptBuilder.append(imports).append("\n\n").append(String.format("class %s {\n %s \n}", this.dialog.getName(), keywords));
            } else {
                scriptBuilder.append(String.format("package %s\n", this.dialog.getParentPackage().getElementName())).append(imports).append("\n\n").append(String.format("class %s {\n %s \n}", this.dialog.getName(), keywords));
            }
            return scriptBuilder.toString();
        }

        private String buildKeywordScript() {
            StringBuilder keywordScriptBuilder = new StringBuilder();
            int sampleKeywordType = this.dialog.getSampleKeywordType();
            if ((sampleKeywordType & 1) != 0) {
                String webCustomKeywordScript = this.getFileContent(SAMPLE_WEB_KEYWORD_FILE);
                keywordScriptBuilder.append(webCustomKeywordScript).append("\n\n");
            }
            if ((sampleKeywordType & 2) != 0) {
                String mobileCustomKeywordScript = this.getFileContent(SAMPLE_MOBILE_KEYWORD_FILE);
                keywordScriptBuilder.append(mobileCustomKeywordScript).append("\n\n");
            }
            if ((sampleKeywordType & 4) != 0) {
                String APICustomKeywordScript = this.getFileContent(SAMPLE_API_KEYWORD_FILE);
                keywordScriptBuilder.append(APICustomKeywordScript).append("\n\n");
            }
            return keywordScriptBuilder.toString();
        }

        private String getFileContent(String filePath) {
            URL url = FileLocator.find((Bundle)FrameworkUtil.getBundle(NewKeywordHandler.class), (IPath)new Path(filePath), null);
            try {
                return StringUtils.join((Iterable)IOUtils.readLines((InputStream)new BufferedInputStream(url.openStream()), (String)"UTF-8"), (String)"\n");
            }
            catch (IOException e) {
                LoggerSingleton.logError((Throwable)e);
                return "";
            }
        }
    }
}

