/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.keyword.handlers;

import com.kms.katalon.composer.components.impl.constants.ImageConstants;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.explorer.util.TransferTypeCollection;
import com.kms.katalon.composer.keyword.constants.StringConstants;
import com.kms.katalon.composer.testcase.providers.TestObjectScriptDropListener;
import com.kms.katalon.composer.util.groovy.GroovyEditorUtil;
import com.kms.katalon.controller.FolderController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.tracking.service.Trackings;
import java.util.Arrays;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.codehaus.groovy.eclipse.editor.GroovyEditor;
import org.codehaus.groovy.eclipse.refactoring.actions.FormatGroovyAction;
import org.codehaus.jdt.groovy.model.GroovyCompilationUnit;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class OpenKeywordHandler {
    @Inject
    private IEventBroker eventBroker;

    @PostConstruct
    public void registerEventHandler() {
        this.eventBroker.subscribe("EXPLORER/OPEN_SELECTED_ITEM", new EventHandler(){

            public void handleEvent(Event event) {
                Object object = event.getProperty("org.eclipse.e4.data");
                if (object != null && object instanceof ICompilationUnit && (((ICompilationUnit)object).getElementName().endsWith(".groovy") || ((ICompilationUnit)object).getElementName().endsWith(".java"))) {
                    OpenKeywordHandler.this.excute((ICompilationUnit)object);
                }
            }
        });
    }

    private void excute(ICompilationUnit keywordFile) {
        if (keywordFile != null && keywordFile.exists()) {
            try {
                IFile iFile = (IFile)keywordFile.getResource();
                if (!keywordFile.isWorkingCopy()) {
                    keywordFile.becomeWorkingCopy(null);
                }
                IEditorDescriptor desc = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(iFile.getName());
                desc.getImageDescriptor();
                ImageDescriptor.createFromImage((Image)ImageConstants.IMG_16_KEYWORD);
                ITextEditor editor = (ITextEditor)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)new FileEditorInput(iFile), desc.getId());
                if (keywordFile instanceof GroovyCompilationUnit && editor != null) {
                    this.formatEditor(editor);
                    GroovyEditorUtil.addImportActions((GroovyEditor)((GroovyEditor)editor));
                }
                if (this.isKeywordFile(iFile)) {
                    Trackings.trackOpenObject((String)"keyword");
                } else {
                    Trackings.trackOpenObject((String)"groovyScriptFile");
                }
            }
            catch (Exception e) {
                LoggerSingleton.logError((Throwable)e);
                MessageDialog.openError(null, (String)StringConstants.ERROR_TITLE, (String)StringConstants.HAND_ERROR_MSG_CANNOT_OPEN_KEYWORD_FILE);
            }
        }
    }

    private boolean isKeywordFile(IFile scriptFile) throws Exception {
        ProjectEntity project = ProjectController.getInstance().getCurrentProject();
        FolderEntity keywordFolder = FolderController.getInstance().getKeywordRoot(project);
        String keywordFolderPath = keywordFolder.getLocation();
        String scriptFilePath = scriptFile.getLocation().toFile().getAbsolutePath();
        return scriptFilePath.startsWith(keywordFolderPath);
    }

    private void formatEditor(ITextEditor editor) {
        FormatGroovyAction formatAction = (FormatGroovyAction)editor.getAction("Format");
        IDocument document = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
        formatAction.run((ITextSelection)new TextSelection(0, document.getLength()));
        this.addTestObjectDropListener(editor);
        editor.doSave((IProgressMonitor)new NullProgressMonitor());
    }

    private void addTestObjectDropListener(ITextEditor editor) {
        Control control = (Control)editor.getAdapter(Control.class);
        if (!(control instanceof StyledText)) {
            return;
        }
        DropTarget dropTarget = null;
        Object existingDropTarget = control.getData("DropTarget");
        dropTarget = existingDropTarget != null ? (DropTarget)existingDropTarget : new DropTarget(control, 1);
        Transfer[] transfers = dropTarget.getTransfer();
        List treeEntityTransfers = TransferTypeCollection.getInstance().getTreeEntityTransfer();
        if (transfers.length != 0) {
            treeEntityTransfers.addAll(Arrays.asList(transfers));
        }
        dropTarget.setTransfer(treeEntityTransfers.toArray(new Transfer[treeEntityTransfers.size()]));
        dropTarget.addDropListener((DropTargetListener)new TestObjectScriptDropListener((StyledText)editor.getAdapter(Control.class)));
    }
}

