/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.keyword.handlers;

import com.kms.katalon.composer.components.impl.tree.FolderTreeEntity;
import com.kms.katalon.composer.components.impl.tree.KeywordTreeEntity;
import com.kms.katalon.composer.components.impl.tree.PackageTreeEntity;
import com.kms.katalon.composer.components.impl.util.TreeEntityUtil;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.transfer.TransferMoveFlag;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.composer.keyword.constants.StringConstants;
import com.kms.katalon.composer.keyword.dialogs.RenameKeywordDialog;
import com.kms.katalon.composer.util.groovy.GroovyGuiUtil;
import com.kms.katalon.controller.FolderController;
import com.kms.katalon.controller.KeywordController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.dal.fileservice.manager.FolderFileServiceManager;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import com.kms.katalon.groovy.util.GroovyUtil;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class PastePackageHandler {
    @Named(value="activeShell")
    private Shell parentShell;
    @Inject
    private IEventBroker eventBroker;

    @PostConstruct
    private void registerEventHandler() {
        this.eventBroker.subscribe("EXPLORER/PASTE_SELECTED_ITEM", new EventHandler(){

            public void handleEvent(Event event) {
                try {
                    Object targetObject = event.getProperty("org.eclipse.e4.data");
                    if (targetObject != null) {
                        Clipboard clipboard;
                        String[] treeEntityPaths;
                        ITreeEntity targetTreeEntity = null;
                        IPackageFragment targetPackageFragment = null;
                        if (targetObject instanceof PackageTreeEntity) {
                            targetPackageFragment = (IPackageFragment)((PackageTreeEntity)targetObject).getObject();
                            targetTreeEntity = (ITreeEntity)targetObject;
                        } else if (targetObject instanceof ITreeEntity && ((ITreeEntity)targetObject).getParent() instanceof PackageTreeEntity) {
                            targetPackageFragment = (IPackageFragment)((PackageTreeEntity)((ITreeEntity)targetObject).getParent()).getObject();
                            targetTreeEntity = ((ITreeEntity)targetObject).getParent();
                        }
                        if (targetPackageFragment != null && (treeEntityPaths = (String[])(clipboard = new Clipboard(Display.getCurrent())).getContents((Transfer)FileTransfer.getInstance())) != null) {
                            if (TransferMoveFlag.isMove()) {
                                PastePackageHandler.this.move(treeEntityPaths, targetPackageFragment);
                                GroovyUtil.getGroovyProject((ProjectEntity)ProjectController.getInstance().getCurrentProject()).refreshLocal(2, null);
                            } else {
                                PastePackageHandler.this.copy(treeEntityPaths, targetPackageFragment);
                                GroovyUtil.getGroovyProject((ProjectEntity)ProjectController.getInstance().getCurrentProject()).refreshLocal(2, null);
                            }
                            PastePackageHandler.this.eventBroker.send("EXPLORER/REFRESH_TREE_ENTITY", (Object)targetTreeEntity);
                            PastePackageHandler.this.eventBroker.post("EXPLORER/SET_SELECTED_ITEM", (Object)targetTreeEntity);
                            PastePackageHandler.this.eventBroker.post("CUSTOMKEYWORD/REFRESH", null);
                        }
                    }
                }
                catch (Exception ex) {
                    LoggerSingleton.logError((Throwable)ex);
                    MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)StringConstants.ERROR_TITLE, (String)StringConstants.HAND_ERROR_MSG_UNABLE_TO_PASTE_DATA);
                }
            }
        });
    }

    private void copy(String[] treeEntityPaths, IPackageFragment targetPackageFragment) throws Exception {
        try {
            IWorkspaceRoot workspaceRoot = targetPackageFragment.getResource().getWorkspace().getRoot();
            String[] stringArray = treeEntityPaths;
            int n = treeEntityPaths.length;
            int n2 = 0;
            while (n2 < n) {
                String treeEntityPath = stringArray[n2];
                this.copyKeyword(this.getKeywordFile(workspaceRoot, treeEntityPath), targetPackageFragment, null);
                ++n2;
            }
        }
        catch (OperationCanceledException operationCanceledException) {
            return;
        }
    }

    private void move(String[] treeEntityPaths, IPackageFragment targetPackageFragment) throws Exception {
        try {
            IWorkspaceRoot workspaceRoot = targetPackageFragment.getResource().getWorkspace().getRoot();
            String[] stringArray = treeEntityPaths;
            int n = treeEntityPaths.length;
            int n2 = 0;
            while (n2 < n) {
                String treeEntityPath = stringArray[n2];
                IFile file = this.getKeywordFile(workspaceRoot, treeEntityPath);
                this.moveKeyword(file, targetPackageFragment, null);
                ++n2;
            }
            FolderEntity kwRootFolder = FolderController.getInstance().getKeywordRoot(ProjectController.getInstance().getCurrentProject());
            this.eventBroker.send("EXPLORER/REFRESH_TREE_ENTITY", (Object)new FolderTreeEntity(kwRootFolder, null));
        }
        catch (OperationCanceledException operationCanceledException) {
            return;
        }
    }

    private void copyKeyword(IFile keywordFile, IPackageFragment targetPackageFragment, String newName) throws Exception {
        block2: {
            try {
                String extension = keywordFile.getFileExtension();
                GroovyUtil.copyKeyword((IFile)keywordFile, (IPackageFragment)targetPackageFragment, (String)newName, (String)extension);
                String copiedKeywordFilePath = this.getPastedFilePath(keywordFile, targetPackageFragment, newName, extension);
                KeywordTreeEntity keywordTreeEntity = TreeEntityUtil.getKeywordTreeEntity((String)copiedKeywordFilePath, (ProjectEntity)ProjectController.getInstance().getCurrentProject());
                this.eventBroker.post("EXPLORER/REFRESH_SELECTED_ITEM", (Object)keywordTreeEntity);
                this.eventBroker.post("EXPLORER/COPY_PASTED_SELECTED_ITEM", (Object)new Object[]{keywordFile.getProjectRelativePath().toString(), copiedKeywordFilePath});
                KeywordController.getInstance().parseCustomKeywordFile(keywordFile, ProjectController.getInstance().getCurrentProject());
            }
            catch (JavaModelException javaModelException) {
                if (javaModelException.getJavaModelStatus().getCode() != 977) break block2;
                this.openRenameDialog(keywordFile, targetPackageFragment, false);
            }
        }
    }

    private void moveKeyword(IFile keywordFile, IPackageFragment targetPackageFragment, String newName) throws Exception {
        block2: {
            try {
                String extension = keywordFile.getFileExtension();
                GroovyUtil.moveKeyword((IFile)keywordFile, (IPackageFragment)targetPackageFragment, (String)newName, (String)extension);
                String cutKeywordFilePath = this.getPastedFilePath(keywordFile, targetPackageFragment, newName, extension);
                KeywordTreeEntity keywordTreeEntity = TreeEntityUtil.getKeywordTreeEntity((String)cutKeywordFilePath, (ProjectEntity)ProjectController.getInstance().getCurrentProject());
                PastePackageHandler.refactorReferencingTestSuites(ProjectController.getInstance().getCurrentProject(), keywordFile, keywordFile.getLocation().toString(), cutKeywordFilePath);
                this.eventBroker.post("EXPLORER/REFRESH_SELECTED_ITEM", (Object)keywordTreeEntity);
                this.eventBroker.post("EXPLORER/CUT_PASTED_SELECTED_ITEM", (Object)new Object[]{keywordFile.getProjectRelativePath().toString(), cutKeywordFilePath});
                KeywordController.getInstance().parseCustomKeywordFile(keywordFile, ProjectController.getInstance().getCurrentProject());
            }
            catch (JavaModelException javaModelException) {
                if (javaModelException.getJavaModelStatus().getCode() != 977) break block2;
                this.openRenameDialog(keywordFile, targetPackageFragment, true);
            }
        }
    }

    private String getPastedFilePath(IFile keywordFile, IPackageFragment targetPackageFragment, String newName, String extension) {
        String keywordRootPath = String.valueOf(targetPackageFragment.getParent().getElementName()) + '/';
        String packageName = targetPackageFragment.getElementName();
        String packagePath = String.valueOf(keywordRootPath) + (packageName.isEmpty() ? packageName : String.valueOf(packageName.replaceAll("[.]", String.valueOf('/'))) + '/');
        String kwFileName = newName != null ? String.valueOf(newName) + "." + extension : keywordFile.getName();
        String copiedKeywordFilePath = String.valueOf(packagePath) + kwFileName;
        return copiedKeywordFilePath;
    }

    private IFile getKeywordFile(IWorkspaceRoot workspaceRoot, String filePath) throws Exception {
        String fileName = filePath.substring(filePath.lastIndexOf(47) + 1);
        String parentContainer = filePath.substring(0, filePath.lastIndexOf(47));
        IResource resource = workspaceRoot.findMember((IPath)new Path(parentContainer));
        if (!resource.exists() || !(resource instanceof IContainer)) {
            throw new Exception(StringConstants.HAND_ERROR_MSG_FILE_NOT_EXIST);
        }
        IContainer container = (IContainer)resource;
        return container.getFile((IPath)new Path(fileName));
    }

    private void openRenameDialog(IFile keywordFile, IPackageFragment parentPackage, boolean isMoving) throws Exception {
        RenameKeywordDialog dialog = new RenameKeywordDialog(this.parentShell, parentPackage);
        String kwName = StringUtils.removeEndIgnoreCase((String)keywordFile.getName(), (String)".groovy");
        kwName = StringUtils.removeEndIgnoreCase((String)kwName, (String)".java");
        dialog.setName(kwName);
        dialog.setWindowTitle(StringConstants.HAND_TITLE_NAME_CONFLICT);
        dialog.setDialogMsg(MessageFormat.format(StringConstants.HAND_MSG_KW_NAME_ALREADY_EXISTS, kwName));
        dialog.open();
        if (dialog.getReturnCode() == 0) {
            if (isMoving) {
                this.moveKeyword(keywordFile, parentPackage, dialog.getName());
            } else {
                this.copyKeyword(keywordFile, parentPackage, dialog.getName());
            }
        }
    }

    private static void refactorReferencingTestSuites(ProjectEntity project, IFile keyword, String oldKeywordLocation, String newKeywordLocation) throws Exception {
        List lstTestCases = FolderFileServiceManager.getDescendantTestCasesOfFolder((FolderEntity)FolderFileServiceManager.getTestCaseRoot((ProjectEntity)project));
        String constant = "keywords";
        String packageName = String.valueOf(project.getFolderLocation()) + File.separator + constant + File.separator;
        File projectFile = new File(packageName);
        String oldRelativeKwLocation = oldKeywordLocation.substring(projectFile.getAbsolutePath().length() + 1);
        String oldRelativeTcId = FilenameUtils.removeExtension((String)oldRelativeKwLocation).replace("/", ".");
        String newRelativeKwLocation = newKeywordLocation.substring(constant.length() + 1);
        String newRelativeTcId = FilenameUtils.removeExtension((String)newRelativeKwLocation).replace("/", ".");
        for (TestCaseEntity testCase : lstTestCases) {
            ICompilationUnit script = GroovyUtil.getOrCreateGroovyScriptForTestCaseFromPlugin((TestCaseEntity)testCase);
            String str = "";
            File file = new File(script.getResource().getLocation().toString());
            str = FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8);
            if (!str.contains("CustomKeywords")) continue;
            String newString = str.replace(oldRelativeTcId, newRelativeTcId);
            GroovyGuiUtil.addContentToTestCase((TestCaseEntity)testCase, (String)newString);
        }
    }
}

