/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.keyword.menu;

import com.kms.katalon.composer.components.impl.tree.FolderTreeEntity;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.menu.MenuFactory;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.composer.keyword.handlers.NewFolderHandler;
import com.kms.katalon.constants.helper.ConstantsHelper;
import com.kms.katalon.controller.FolderController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.entity.folder.FolderEntity;
import java.util.List;
import javax.inject.Inject;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.ui.di.AboutToShow;
import org.eclipse.e4.ui.model.application.ui.menu.MHandledMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuElement;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;

public class CustomKeywordPluginMenuContribution
extends NewFolderHandler {
    private static final String CUSTOM_KEYWORD_PLUGIN_COMMAND_ID = "com.kms.katalon.composer.keyword.command.customKeywordPlugin";
    @Inject
    private ESelectionService selectionService;
    @Inject
    private ECommandService commandService;

    @AboutToShow
    public void aboutToShow(List<MMenuElement> menuItems) {
        Object[] selectedObjects = (Object[])this.selectionService.getSelection("com.kms.katalon.composer.part.explorer");
        FolderTreeEntity selectedEntity = this.getSelectedTreeEntity(selectedObjects);
        if (selectedEntity == null) {
            return;
        }
        try {
            FolderEntity folder = selectedEntity.getObject();
            if (FolderController.getInstance().isSourceFolder(ProjectController.getInstance().getCurrentProject(), folder)) {
                return;
            }
            MHandledMenuItem customKeywordPluginMenuItem = MenuFactory.createPopupMenuItem((ParameterizedCommand)this.commandService.createCommand(CUSTOM_KEYWORD_PLUGIN_COMMAND_ID, null), (String)"Custom Keyword Plugin", (String)ConstantsHelper.getApplicationURI());
            if (customKeywordPluginMenuItem != null) {
                menuItems.add((MMenuElement)customKeywordPluginMenuItem);
            }
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    @Override
    protected FolderTreeEntity getSelectedTreeEntity(Object[] selectedObjects) {
        ITreeEntity parent;
        block5: {
            if (selectedObjects == null || selectedObjects.length != 1 || !(selectedObjects[0] instanceof ITreeEntity)) {
                return null;
            }
            if (selectedObjects[0] instanceof FolderTreeEntity) {
                FolderTreeEntity parentFolder = (FolderTreeEntity)selectedObjects[0];
                return this.isKeywordFolder(parentFolder) ? parentFolder : null;
            }
            ITreeEntity treeEntity = (ITreeEntity)selectedObjects[0];
            try {
                parent = treeEntity.getParent();
                if (parent instanceof FolderTreeEntity) break block5;
                return null;
            }
            catch (Exception e) {
                LoggerSingleton.logError((Throwable)e);
                return null;
            }
        }
        FolderTreeEntity parentFolder = (FolderTreeEntity)parent;
        return this.isKeywordFolder(parentFolder) ? parentFolder : null;
    }

    private boolean isKeywordFolder(FolderTreeEntity folderTree) {
        try {
            return folderTree.getObject().getFolderType() == FolderEntity.FolderType.KEYWORD;
        }
        catch (Exception exception) {
            return false;
        }
    }
}

