/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.entity.testcase;

import com.kms.katalon.entity.file.IntegratedFileEntity;
import com.kms.katalon.entity.integration.IntegratedEntity;
import com.kms.katalon.entity.link.TestCaseTestDataLink;
import com.kms.katalon.entity.link.VariableLink;
import com.kms.katalon.entity.testdata.DataFileEntity;
import com.kms.katalon.entity.util.Util;
import com.kms.katalon.entity.variable.VariableEntity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.bind.annotation.XmlTransient;

public class TestCaseEntity
extends IntegratedFileEntity {
    private static final long serialVersionUID = 1L;
    private String comment = "";
    @XmlTransient
    private List<DataFileEntity> dataFiles;
    private List<String> dataFileLocations;
    private List<VariableEntity> variables = new ArrayList<VariableEntity>();
    private String testCaseGuid;
    private byte[] scriptContents;
    private List<VariableLink> variableLinks;
    private List<TestCaseTestDataLink> testDataLinks;

    public TestCaseEntity() {
        this.dataFiles = new ArrayList<DataFileEntity>();
        this.dataFileLocations = new ArrayList<String>();
        this.variableLinks = new ArrayList<VariableLink>();
        this.testDataLinks = new ArrayList<TestCaseTestDataLink>();
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getTestCaseGuid() {
        return this.testCaseGuid;
    }

    public void setTestCaseGuid(String testCaseGuid) {
        this.testCaseGuid = testCaseGuid;
    }

    @Override
    public TestCaseEntity clone() {
        TestCaseEntity newTestCase = new TestCaseEntity();
        newTestCase.setParentFolder(this.getParentFolder());
        newTestCase.setProject(this.getProject());
        newTestCase.setName(this.getName());
        newTestCase.setComment(this.getComment());
        newTestCase.setTag(this.getTag());
        newTestCase.setDescription(this.getDescription());
        newTestCase.getDataFileLocations().clear();
        newTestCase.getDataFiles().clear();
        for (DataFileEntity dataFile : this.getDataFiles()) {
            newTestCase.getDataFiles().add(dataFile);
            newTestCase.getDataFileLocations().add(dataFile.getRelativePath());
        }
        newTestCase.getVariables().clear();
        HashMap<String, String> variablesIdCollection = new HashMap<String, String>();
        for (VariableEntity variable : this.getVariables()) {
            VariableEntity variableClone = variable.clone();
            newTestCase.getVariables().add(variableClone);
            variablesIdCollection.put(variable.getId(), variableClone.getId());
        }
        newTestCase.getIntegratedEntities().clear();
        for (IntegratedEntity integratedEntity : this.getIntegratedEntities()) {
            newTestCase.getIntegratedEntities().add(integratedEntity);
        }
        newTestCase.setScriptContents(this.getScriptContents());
        newTestCase.setTestCaseGuid(Util.generateGuid());
        newTestCase.getVariableLinks().clear();
        for (VariableLink variableLink : this.getVariableLinks()) {
            VariableLink variableLinkClone = variableLink.clone();
            String oldVariableId = variableLink.getVariableId();
            if (variablesIdCollection.containsKey(oldVariableId)) {
                variableLinkClone.setVariableId((String)variablesIdCollection.get(oldVariableId));
            }
            newTestCase.getVariableLinks().add(variableLinkClone);
        }
        newTestCase.getTestDataLinks().clear();
        for (TestCaseTestDataLink testDataLink : this.getTestDataLinks()) {
            newTestCase.getTestDataLinks().add(testDataLink.clone());
        }
        return newTestCase;
    }

    public List<String> getDataFileLocations() {
        return this.dataFileLocations;
    }

    public void setDataFileLocations(List<String> dataFileLocations) {
        this.dataFileLocations = dataFileLocations;
    }

    @Override
    public String getFileExtension() {
        return TestCaseEntity.getTestCaseFileExtension();
    }

    public static String getTestCaseFileExtension() {
        return ".tc";
    }

    public List<DataFileEntity> getDataFiles() {
        return this.dataFiles;
    }

    public void setDataFiles(List<DataFileEntity> dataFiles) {
        this.dataFiles = dataFiles;
    }

    public byte[] getScriptContents() {
        return this.scriptContents;
    }

    public void setScriptContents(byte[] scriptContents) {
        this.scriptContents = scriptContents;
    }

    public List<VariableEntity> getVariables() {
        return this.variables;
    }

    public void setVariables(List<VariableEntity> variables) {
        this.variables = variables;
    }

    public void addVariables(List<VariableEntity> variablesToAdd) {
        this.variables.addAll(variablesToAdd);
    }

    public List<VariableLink> getVariableLinks() {
        return this.variableLinks;
    }

    public void setVariableLinks(List<VariableLink> variableLinks) {
        this.variableLinks = variableLinks;
    }

    public List<TestCaseTestDataLink> getTestDataLinks() {
        return this.testDataLinks;
    }

    public void setTestDataLinks(List<TestCaseTestDataLink> testDataLinks) {
        this.testDataLinks = testDataLinks;
    }

    public List<VariableLink> convertVariableEntityToVariableLink() {
        ArrayList<VariableLink> list = new ArrayList<VariableLink>();
        for (VariableEntity var : this.variables) {
            list.add(new VariableLink(var.getId()));
        }
        return list;
    }
}

