/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.integration.azure.model;

import com.kms.katalon.core.logging.model.TestCaseLogRecord;
import com.kms.katalon.integration.azure.model.AzureTestPoint;
import com.kms.katalon.integration.azure.model.TestPointMapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class TestPointMappers {
    private List<TestPointMapper> mappers = new ArrayList<TestPointMapper>();

    public TestPointMappers() {
    }

    public TestPointMappers(List<TestPointMapper> mappers) {
        this.mappers = mappers;
    }

    public void add(TestPointMapper mapper) {
        this.mappers.add(mapper);
    }

    public void remove(TestPointMapper mapper) {
        if (mapper == null) {
            return;
        }
        this.mappers.remove(mapper);
    }

    public TestPointMapper getMapper(int testPoint) {
        Optional<TestPointMapper> mapper = this.mappers.stream().filter(element -> element.getAzureTestPoint().getId() == testPoint).findFirst();
        if (mapper.isPresent()) {
            return mapper.get();
        }
        return null;
    }

    public void add(AzureTestPoint testPoint, TestCaseLogRecord testCaseLog) {
        this.mappers.add(new TestPointMapper(testPoint, testCaseLog));
    }

    public int[] getTestPointIds() {
        int[] testPointIds = new int[this.mappers.size()];
        int i = 0;
        while (i < this.mappers.size()) {
            TestPointMapper mapper = this.mappers.get(i);
            testPointIds[i] = mapper.getAzureTestPoint().getId();
            ++i;
        }
        return testPointIds;
    }

    public boolean isEmpty() {
        return this.mappers.isEmpty();
    }

    public List<TestPointMapper> get() {
        return this.mappers;
    }

    public void addAll(TestPointMappers testPointMappers) {
        this.mappers.addAll(testPointMappers.get());
    }

    public TestPointMappers copy() {
        List<TestPointMapper> mapperList = this.mappers.stream().collect(Collectors.toList());
        return new TestPointMappers(mapperList);
    }
}

