/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.integration.azure.provider;

import com.kms.katalon.integration.azure.model.AzureCredential;
import java.text.MessageFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AzureAPIProvider {
    protected static final String HEADER_AUTHORIZATION_PREFIX = "Basic";
    private static final String URI_SEPARATOR = "/";

    private static String getApiURI(String host, String path) {
        if (host.endsWith(URI_SEPARATOR)) {
            host = host.substring(0, host.length() - 1);
        }
        if (!path.startsWith(URI_SEPARATOR)) {
            path = URI_SEPARATOR + path;
        }
        return String.valueOf(host) + path;
    }

    public static String getOrganizationAPIUrl(AzureCredential credential) {
        return credential.getServerUrl();
    }

    public static String getProjectsAPIUrl(AzureCredential credential) {
        String getProjectsAPI = MessageFormat.format("/_apis/projects?$top={0,number,#}&api-version=6.0", 5000);
        return AzureAPIProvider.getApiURI(credential.getServerUrl(), getProjectsAPI);
    }

    public static String getTestSuitesByTestCaseIdAPIUrl(AzureCredential credential, int testCaseId) {
        String getProjectsAPI = MessageFormat.format("/_apis/testplan/suites?testCaseId={0,number,#}&api-version=6.0", testCaseId);
        return AzureAPIProvider.getApiURI(credential.getServerUrl(), getProjectsAPI);
    }

    public static String getAllTestConfigurationsAPIUrl(AzureCredential credential, String projectId, int startId) {
        String getAllTestConfigurationAPI = MessageFormat.format("/{0}/_apis/testplan/configurations?continuationToken={1,number,#};{2,number,#}&api-version=6.0-preview.1", projectId, startId, 5000);
        return AzureAPIProvider.getApiURI(credential.getServerUrl(), getAllTestConfigurationAPI);
    }

    public static String getPointsAPIUrl(AzureCredential credential, String projectId, int testPlanId, int testSuiteId, int testCaseId) {
        String path = MessageFormat.format("/{0}/_apis/testplan/Plans/{1,number,#}/Suites/{2,number,#}/TestPoint?testCaseId={3,number,#}&api-version=6.0-preview.2", projectId, testPlanId, testSuiteId, testCaseId);
        return AzureAPIProvider.getApiURI(credential.getServerUrl(), path);
    }

    public static String getCreateTestRunAPIUrl(AzureCredential credential, String projectId) {
        String path = MessageFormat.format("/{0}/_apis/test/runs?api-version=6.0", projectId);
        return AzureAPIProvider.getApiURI(credential.getServerUrl(), path);
    }

    public static String getUpdateTestRunAPIUrl(AzureCredential credential, String projectId, int testRunId) {
        String path = MessageFormat.format("/{0}/_apis/test/runs/{1,number,#}?api-version=6.0", projectId, testRunId);
        return AzureAPIProvider.getApiURI(credential.getServerUrl(), path);
    }

    public static String getUpdateTestCaseResultsAPIUrl(AzureCredential credential, String projectId, int testRunId) {
        String path = MessageFormat.format("/{0}/_apis/test/Runs/{1,number,#}/results?api-version=6.0", projectId, testRunId);
        return AzureAPIProvider.getApiURI(credential.getServerUrl(), path);
    }

    public static String getUploadAttachmentAPIUrl(AzureCredential credential, String projectId, int testRunId) {
        String path = MessageFormat.format("/{0}/_apis/test/Runs/{1,number,#}/attachments?api-version=6.0-preview.1", projectId, testRunId);
        return AzureAPIProvider.getApiURI(credential.getServerUrl(), path);
    }

    public static String getAllTestPlansAPIUrl(AzureCredential credential, String projectId) {
        String getAllTestPlansAPI = MessageFormat.format("/{0}/_apis/test/plans?$top={1,number,#}&api-version=5.0", projectId, 5000);
        return AzureAPIProvider.getApiURI(credential.getServerUrl(), getAllTestPlansAPI);
    }

    public static String getBuildDefinitionAPIUrl(AzureCredential credential, String projectId, int buildDefinitionId) {
        String getDefinitionAPI = MessageFormat.format("/{0}/_apis/build/definitions/{1,number,#}?api-version=6.0", projectId, buildDefinitionId);
        return AzureAPIProvider.getApiURI(credential.getServerUrl(), getDefinitionAPI);
    }

    public static String getLatestBuildByDefinitionIdAPIUrl(AzureCredential credential, String projectId, int buildDefinitionId) {
        String getDefinitionAPI = MessageFormat.format("{0}/_apis/build/builds?definitions={1,number,#}&includeLatestBuild=true&statusFilter=completed&api-version=6.0", projectId, buildDefinitionId);
        return AzureAPIProvider.getApiURI(credential.getServerUrl(), getDefinitionAPI);
    }

    public static String getReleaseDefinitionAPIUrl(AzureCredential credential, String projectId, int releaseDefinitionId) {
        String organizationName = AzureAPIProvider.getOrganizationName(credential.getServerUrl());
        String getReleaseDefinitionAPI = MessageFormat.format("https://vsrm.dev.azure.com/{0}/{1}/_apis/release/definitions/{2,number,#}?api-version=6.0", organizationName, projectId, releaseDefinitionId);
        return getReleaseDefinitionAPI;
    }

    public static String getReleaseAPIUrl(AzureCredential credential, String projectId, int releaseId) {
        String organizationName = AzureAPIProvider.getOrganizationName(credential.getServerUrl());
        String getReleaseAPI = MessageFormat.format("https://vsrm.dev.azure.com/{0}/{1}/_apis/release/releases/{2,number,#}?api-version=6.0", organizationName, projectId, releaseId);
        return getReleaseAPI;
    }

    private static String getOrganizationName(String serverUrl) {
        Pattern pattern = Pattern.compile("https?://dev.azure.com/(\\w+)");
        Matcher matcher = pattern.matcher(serverUrl);
        if (matcher.find()) {
            return matcher.group(1);
        }
        pattern = Pattern.compile("https?://(\\w+).visualstudio.com");
        matcher = pattern.matcher(serverUrl);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }
}

