/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.integration.azure.setting;

import com.google.gson.reflect.TypeToken;
import com.kms.katalon.controller.ReportController;
import com.kms.katalon.core.appium.driver.AppiumDriverManager;
import com.kms.katalon.core.logging.model.TestSuiteLogRecord;
import com.kms.katalon.core.util.internal.JsonUtil;
import com.kms.katalon.core.webui.driver.WebUIDriverType;
import com.kms.katalon.integration.azure.setting.TestConfigurationMapping;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

public class ExecutionMappingUtil {
    public static final String ANY_OS = "--Any--";
    public static final String ANY_PLATFORM = "--Any--";
    public static final String[] EXECUTION_OSES = new String[]{"--Any--", "Windows", "macOS", "Linux", "Android", "iOS"};
    public static final String[] EXECUTION_PLATFORMS = new String[]{"--Any--", "Chrome", "Firefox", "IE", "Safari", "Edge", "Edge Chromium", "Native App"};

    public static List<Integer> getSuitableConfigurations(TestSuiteLogRecord suiteRecord, List<TestConfigurationMapping> mappings) {
        ArrayList<Integer> configurationIdList = new ArrayList<Integer>();
        if (mappings == null || mappings.isEmpty()) {
            return configurationIdList;
        }
        for (TestConfigurationMapping m : mappings) {
            if (!ExecutionMappingUtil.isMatched(suiteRecord, m)) continue;
            configurationIdList.add(m.getAzureTestConfigurationId());
        }
        return configurationIdList;
    }

    private static boolean compareOs(String os, String mappingOs) {
        if (os.toLowerCase().contains(mappingOs.toLowerCase())) {
            return true;
        }
        if ("macOS".equals(mappingOs)) {
            return os.toLowerCase().contains("mac");
        }
        return false;
    }

    private static boolean isMatched(TestSuiteLogRecord suiteRecord, TestConfigurationMapping mapping) {
        String os = ExecutionMappingUtil.getOs(suiteRecord);
        String browser = ExecutionMappingUtil.getBrowser(suiteRecord);
        String mappingOs = mapping.getOs();
        String mappingPlatform = mapping.getPlatform();
        if ("--Any--".equals(mappingOs) || ExecutionMappingUtil.compareOs(os, mappingOs)) {
            return "--Any--".equals(mappingPlatform) || browser.toLowerCase().contains(mappingPlatform.toLowerCase());
        }
        return false;
    }

    public static String getOs(TestSuiteLogRecord suiteRecord) {
        Type typeToken;
        Map desiredCapabilities;
        String platformName;
        Map runData = suiteRecord.getRunData();
        if (runData == null) {
            return "";
        }
        String remoteServerUrl = runData.getOrDefault("remoteDriverUrl", "");
        String desiredCapabilitiesString = runData.getOrDefault("desiredCapabilities", "");
        if (StringUtils.isNotEmpty((CharSequence)remoteServerUrl) && StringUtils.isNotEmpty((CharSequence)desiredCapabilitiesString) && StringUtils.isNotEmpty((CharSequence)(platformName = (desiredCapabilities = (Map)JsonUtil.fromJson((String)desiredCapabilitiesString, (Type)(typeToken = new TypeToken<Map<String, Object>>(){}.getType()))).getOrDefault("platformName", "").toString()))) {
            return platformName;
        }
        String mobileOs = runData.getOrDefault(AppiumDriverManager.EXECUTED_DEVICE_OS, "");
        if (StringUtils.isEmpty((CharSequence)mobileOs)) {
            mobileOs = ExecutionMappingUtil.getMobileOSInExecutionProperties(suiteRecord);
        }
        return StringUtils.isNotEmpty((CharSequence)mobileOs) ? mobileOs : suiteRecord.getOs();
    }

    private static String getBrowser(TestSuiteLogRecord suiteRecord) {
        String browser = ExecutionMappingUtil.getBrowserFromRunData(suiteRecord);
        if (StringUtils.isEmpty((CharSequence)browser)) {
            browser = ExecutionMappingUtil.getBrowserInExecutionProperties(suiteRecord);
        }
        return StringUtils.isNotEmpty((CharSequence)browser) ? browser : "Native App";
    }

    public static String getBrowserFromRunData(TestSuiteLogRecord suiteRecord) {
        Map runData = suiteRecord.getRunData();
        if (runData == null) {
            return "";
        }
        String browser = suiteRecord.getBrowser();
        return StringUtils.isNotEmpty((CharSequence)browser) ? browser : "";
    }

    public static String getMobileOSInExecutionProperties(TestSuiteLogRecord suiteRecord) {
        Map systemProperties;
        block6: {
            Map executionProperties;
            block5: {
                File executionSettingFile = ReportController.getInstance().getExecutionSettingFile(suiteRecord.getLogFolder());
                if (!executionSettingFile.exists()) {
                    return "";
                }
                try {
                    Type type = new TypeToken<Map<String, Object>>(){}.getType();
                    Map properties = (Map)JsonUtil.fromJson((String)FileUtils.readFileToString((File)executionSettingFile), (Type)type);
                    executionProperties = properties.getOrDefault("execution", new HashMap());
                    if (executionProperties.containsKey("drivers")) break block5;
                    return "";
                }
                catch (IOException iOException) {
                    return "";
                }
            }
            Map driverExecutionProperties = (Map)executionProperties.get("drivers");
            systemProperties = driverExecutionProperties.getOrDefault("system", new HashMap());
            if (systemProperties.containsKey("Mobile")) break block6;
            return "";
        }
        Map mobileProperties = (Map)systemProperties.get("Mobile");
        return mobileProperties.getOrDefault(AppiumDriverManager.EXECUTED_DEVICE_OS, "");
    }

    public static String getBrowserInExecutionProperties(TestSuiteLogRecord suiteRecord) {
        Map systemProperties;
        block10: {
            Map executionProperties;
            block9: {
                File executionSettingFile = ReportController.getInstance().getExecutionSettingFile(suiteRecord.getLogFolder());
                if (!executionSettingFile.exists()) {
                    return "";
                }
                try {
                    Type type = new TypeToken<Map<String, Object>>(){}.getType();
                    Map properties = (Map)JsonUtil.fromJson((String)FileUtils.readFileToString((File)executionSettingFile), (Type)type);
                    executionProperties = properties.getOrDefault("execution", new HashMap());
                    if (executionProperties.containsKey("drivers")) break block9;
                    return "";
                }
                catch (IOException iOException) {
                    return "";
                }
            }
            Map driverExecutionProperties = (Map)executionProperties.get("drivers");
            systemProperties = driverExecutionProperties.getOrDefault("system", new HashMap());
            if (systemProperties.containsKey("WebUI")) break block10;
            return "";
        }
        Map webUiProperties = (Map)systemProperties.get("WebUI");
        String driverTypeString = webUiProperties.getOrDefault("browserType", "");
        WebUIDriverType driverType = WebUIDriverType.valueOf((String)driverTypeString);
        switch (driverType) {
            case REMOTE_WEB_DRIVER: 
            case REMOTE_FIREFOX_DRIVER: 
            case REMOTE_CHROME_DRIVER: 
            case KOBITON_WEB_DRIVER: {
                return "";
            }
        }
        return driverType.toString();
    }
}

