/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.console.application;

import com.kms.katalon.application.utils.ActivationInfoCollector;
import com.kms.katalon.application.utils.ApplicationInfo;
import com.kms.katalon.console.constants.ConsoleMessageConstants;
import com.kms.katalon.console.entity.ConsoleLauncherEntity;
import com.kms.katalon.console.handlers.ActivationHandler;
import com.kms.katalon.console.handlers.ArgumentOptionsHandler;
import com.kms.katalon.console.handlers.FileReader;
import com.kms.katalon.console.handlers.PluginHandler;
import com.kms.katalon.console.handlers.ProjectHandler;
import com.kms.katalon.console.handlers.ProxyHandler;
import com.kms.katalon.constants.GlobalMessageConstants;
import com.kms.katalon.core.configuration.RunConfiguration;
import com.kms.katalon.core.util.Strings;
import com.kms.katalon.entity.integration.analytics.AnalyticsOrganization;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.execution.console.entity.OverridingParametersConsoleOptionContributor;
import com.kms.katalon.execution.constants.ExecutionMessageConstants;
import com.kms.katalon.execution.constants.StringConstants;
import com.kms.katalon.execution.exception.ExecutionException;
import com.kms.katalon.execution.exception.InvalidConsoleArgumentException;
import com.kms.katalon.execution.launcher.ILauncher;
import com.kms.katalon.execution.launcher.manager.LauncherManager;
import com.kms.katalon.execution.util.ApiKey;
import com.kms.katalon.execution.util.ApiKeyOnPremise;
import com.kms.katalon.execution.util.ExecutionUtil;
import com.kms.katalon.execution.util.LocalInformationUtil;
import com.kms.katalon.feature.FeatureServiceConsumer;
import com.kms.katalon.integration.analytics.providers.TestOpsService;
import com.kms.katalon.integration.analytics.setting.AnalyticsSettingStore;
import com.kms.katalon.license.ConsoleLicenseService;
import com.kms.katalon.logging.LogUtil;
import java.io.IOException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import joptsimple.OptionSet;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public class ConsoleMain {
    private ConsoleMain() {
    }

    private static int checkingEnviroment() {
        boolean isDevelopmentMode = Platform.inDevelopmentMode();
        boolean isRunningInKatalonC = ExecutionUtil.isRunningInKatalonC();
        if (!isDevelopmentMode && !isRunningInKatalonC) {
            LogUtil.printErrorLine((String)ExecutionMessageConstants.ACTIVATE_MOVE_TO_KATALONC);
            return 4;
        }
        return 200;
    }

    public static int launch(String[] arguments) {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            LogUtil.logInfo((String)ExecutionMessageConstants.ACTIVATE_MSG_INTERRUPT_CONSOLE);
            try {
                ActivationInfoCollector.releaseLicense();
            }
            catch (Exception e) {
                LogUtil.printErrorLine((String)e.getMessage());
            }
        }));
        int code = 0;
        try {
            code = ConsoleMain.checkingEnviroment();
            if (code != 200) {
                int n = code;
                return n;
            }
            ConsoleMain.registerTestopsCommand(Arrays.asList(arguments));
            ConsoleLauncherEntity consoleLauncherEntity = new ConsoleLauncherEntity(arguments);
            ArgumentOptionsHandler.getInstance().setOptions(consoleLauncherEntity.getOptions());
            ArgumentOptionsHandler.getInstance().prepareApplicationConfiguration(consoleLauncherEntity.getApplicationConfigOptions());
            code = ProxyHandler.checkingProxyInfo(consoleLauncherEntity.getOptions());
            if (code != 200) {
                int n = code;
                return n;
            }
            ArgumentOptionsHandler.getInstance().getTestOpsServerUrl();
            ((TestOpsService)((TestOpsService)TestOpsService.getInstance().setAdminServer(ApplicationInfo.getAdminServer())).setTestOpsServer(ApplicationInfo.getTestOpsServer())).setFreezeTestOpsServer(ArgumentOptionsHandler.getInstance().useTestOpsServerUrlArgument());
            ProxyHandler.printProxyInfo();
            ArgumentOptionsHandler.getInstance().validateOption();
            ArgumentOptionsHandler.getInstance().getApiKeyOnpremiseValue();
            LogUtil.logInfo((String)ExecutionMessageConstants.ACTIVATE_IN_ACTIVATING);
            ConsoleMain.loadArgumentsFromFile(consoleLauncherEntity);
            ActivationHandler activator = new ActivationHandler();
            code = activator.activate();
            code = ConsoleMain.checkLicenseWithBrowserType();
            if (code != 200) {
                int n = code;
                return n;
            }
            LocalInformationUtil.printSystemInformation();
            if (!ConsoleMain.isCliEnable()) {
                return 4;
            }
            ProjectEntity project = ProjectHandler.findProject(consoleLauncherEntity.getOptions());
            ProjectHandler.setDefaultExecutionPropertiesOfProject(project, consoleLauncherEntity.getConsoleOptionValueMap());
            ConsoleMain.loadProjectTestOpsSettings();
            PluginHandler.loadPluginsToConsole(consoleLauncherEntity);
            consoleLauncherEntity.acceptConsoleOptionList(new OverridingParametersConsoleOptionContributor(project).getConsoleOptionList());
            PluginHandler.checkPluginLicense(ApiKey.get(), ConsoleMain.parseOrganizationId(ArgumentOptionsHandler.getInstance().getOrganizationId()));
            if (consoleLauncherEntity.getOptions().has("appiumDirectory")) {
                RunConfiguration.getInstance().setAppiumDirectoryDefinedWithArgument(String.valueOf(consoleLauncherEntity.getOptions().valueOf("appiumDirectory")));
            }
            consoleLauncherEntity.getConsoleExecutor().execute(project, consoleLauncherEntity.getOptions());
            ConsoleMain.waitForExecutionToFinish(consoleLauncherEntity.getOptions());
            List consoleLaunchers = LauncherManager.getInstance().getSortedLaunchers();
            int exitCode = ((ILauncher)consoleLaunchers.get(consoleLaunchers.size() - 1)).getResult().getReturnCode();
            LogUtil.logInfo((String)MessageFormat.format(ExecutionMessageConstants.RE_EXECUTE_COMPLETED, exitCode));
            int n = exitCode;
            return n;
        }
        catch (InvalidConsoleArgumentException e) {
            LogUtil.printErrorLine((String)e.getMessage());
            return 4;
        }
        catch (ExecutionException e) {
            if (e.getMessage().contains("Cannot execute this test suite collection")) {
                LogUtil.printErrorLine((String)e.getMessage());
            } else {
                LogUtil.printErrorLine((String)ExceptionUtils.getStackTrace((Throwable)e));
            }
            return 2;
        }
        catch (Throwable e) {
            LogUtil.printErrorLine((String)ExceptionUtils.getStackTrace((Throwable)e));
            return 2;
        }
        finally {
            ActivationInfoCollector.postEndSession();
            try {
                ActivationInfoCollector.releaseLicense();
            }
            catch (Exception ex) {
                LogUtil.printErrorLine((String)ex.getMessage());
            }
            LauncherManager.getInstance().removeAllTerminated();
        }
    }

    private static void loadProjectTestOpsSettings() {
        AnalyticsSettingStore analyticsSettingStore = AnalyticsSettingStore.getStore();
        AnalyticsOrganization org = analyticsSettingStore.getOrganizationCloud();
        if (Objects.nonNull(org) && org.isSamlSSO()) {
            try {
                analyticsSettingStore.setOverrideAuthentication(false);
            }
            catch (IOException e) {
                LogUtil.printErrorLine((String)e.getMessage());
            }
        }
        TestOpsService overridingTestOpsService = TestOpsService.getOverridingInstance();
        String onPremiseServer = analyticsSettingStore.getServerEndpointOnPremise();
        String onPremiseApiKey = (String)Strings.firstNonBlank((CharSequence[])new String[]{ApiKeyOnPremise.get(), ApiKey.get()});
        ((TestOpsService)((TestOpsService)overridingTestOpsService.setAdminServer(onPremiseServer)).setTestOpsServer(onPremiseServer)).setCredential(onPremiseApiKey);
        if (analyticsSettingStore.isOverrideAuthentication()) {
            TestOpsService.switchToOverridingInstance();
        }
    }

    private static int checkLicenseWithBrowserType() {
        boolean isBrowserTypeTestCloud = ArgumentOptionsHandler.getInstance().isRunWithTestCloudBrowser();
        String runningType = "test suite";
        if (!ArgumentOptionsHandler.getInstance().isRunningTestSuite()) {
            runningType = String.valueOf(runningType) + " collection";
        }
        int code = 200;
        if (isBrowserTypeTestCloud && !ConsoleLicenseService.getInstance().isValidTestCloudLicense()) {
            code = 3;
            LogUtil.printOutputLine((String)MessageFormat.format(ConsoleMessageConstants.MSG_CANNOT_ACTIVATE_WITH_BROWSER_TYPE, runningType, GlobalMessageConstants.TESTCLOUD_NAME));
        } else if (!isBrowserTypeTestCloud && !ConsoleLicenseService.getInstance().isValidKRELicense()) {
            code = 3;
            LogUtil.printOutputLine((String)MessageFormat.format(ConsoleMessageConstants.MSG_CANNOT_ACTIVATE_WITH_BROWSER_TYPE, runningType, GlobalMessageConstants.KATALON_RUNTIME_ENGINE_NAME));
        }
        return code;
    }

    private static void waitForExecutionToFinish(OptionSet options) {
        int progressDelay = 15;
        if (options.has("statusDelay")) {
            String progressDelayString = String.valueOf(options.valueOf("statusDelay"));
            try {
                progressDelay = Integer.valueOf(progressDelayString);
            }
            catch (NumberFormatException numberFormatException) {
                LogUtil.printErrorLine((String)MessageFormat.format(StringConstants.MNG_PRT_INVALID_ARG_CANNOT_PARSE_X_FOR_Y_TO_INTEGER, progressDelayString, "statusDelay"));
            }
        }
        ConsoleMain.waitForExecutionToFinish(progressDelay);
    }

    private static void waitForExecutionToFinish(int showProgressDelay) {
        int progressDelayTimeInMiliseconds = (showProgressDelay < 0 ? 15 : showProgressDelay) * 1000;
        do {
            ConsoleMain.printStatus();
            try {
                Thread.sleep(progressDelayTimeInMiliseconds);
            }
            catch (InterruptedException interruptedException) {}
        } while (LauncherManager.getInstance().isAnyLauncherRunning());
        ConsoleMain.printStatus();
    }

    private static void printStatus() {
        int consoleWidth = 80;
        LogUtil.printOutputLine((String)LauncherManager.getInstance().getStatus(consoleWidth));
    }

    private static Long parseOrganizationId(String organizationId) throws InvalidConsoleArgumentException {
        Long orgIdValue = null;
        try {
            if (organizationId != null) {
                orgIdValue = Long.valueOf(organizationId);
            }
            return orgIdValue;
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidConsoleArgumentException(String.format(StringConstants.MNG_PRT_ORGANIZATION_ID_IS_INVALID, new Object[0]));
        }
    }

    private static void loadArgumentsFromFile(ConsoleLauncherEntity consoleLauncherEntity) throws Exception {
        FileReader.readArgumentFromFile(consoleLauncherEntity);
        consoleLauncherEntity.updateOptions();
        ArgumentOptionsHandler.getInstance().setOptions(consoleLauncherEntity.getOptions());
    }

    private static boolean isCliEnable() {
        boolean isCliEnabled = FeatureServiceConsumer.getServiceInstance().canUse("cli");
        if (!isCliEnabled && ConsoleLicenseService.getInstance().getLicenseType() == null) {
            LogUtil.printErrorLine((String)ExecutionMessageConstants.RE_DONT_PERMISSION_TO_USE);
            return false;
        }
        return true;
    }

    private static void registerTestopsCommand(List<String> arguments) throws Exception {
        Bundle katalonBundle = Platform.getBundle((String)"com.kms.katalon.integration.analytics");
        Class analyticsCommandFactory = katalonBundle.loadClass("com.kms.katalon.integration.analytics.AnalyticsCommandFactory");
        Object factory = analyticsCommandFactory.newInstance();
        Method registerTestopsMethod = Arrays.asList(analyticsCommandFactory.getMethods()).stream().filter(method -> method.getName().equals("registerTestopsCommand")).findAny().orElse(null);
        if (registerTestopsMethod != null) {
            registerTestopsMethod.invoke(factory, arguments);
        }
    }
}

