/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.console.entity;

import com.kms.katalon.execution.console.ApplicationConfigOptions;
import com.kms.katalon.execution.console.ConsoleExecutor;
import com.kms.katalon.execution.console.entity.ConsoleMainOptionContributor;
import com.kms.katalon.execution.console.entity.ConsoleOption;
import com.kms.katalon.execution.console.entity.InfoOptionContributor;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;

public class ConsoleLauncherEntity {
    private ConsoleExecutor consoleExecutor;
    private ApplicationConfigOptions applicationConfigOptions;
    private List<String> addedArguments;
    private OptionParser parser;
    private Map<String, String> consoleOptionValueMap;
    private OptionSet options;
    private String[] arguments;

    public ConsoleLauncherEntity(String[] arguments) {
        this.arguments = arguments;
        this.consoleExecutor = new ConsoleExecutor();
        this.applicationConfigOptions = new ApplicationConfigOptions();
        this.addedArguments = Arrays.asList(arguments);
        this.consoleOptionValueMap = new HashMap<String, String>();
        this.initialParser();
        this.initOptions();
    }

    private void initOptions() {
        this.options = this.parser.parse(this.arguments);
    }

    public void updateOptions() {
        this.options = this.parser.parse((String[])this.addedArguments.stream().toArray(String[]::new));
    }

    private void initialParser() {
        this.parser = new OptionParser(false);
        this.parser.allowsUnrecognizedOptions();
        this.parser.accepts("propertiesFile").withRequiredArg().ofType(String.class);
        this.acceptConsoleOptionList(new ConsoleMainOptionContributor().getConsoleOptionList());
        this.acceptConsoleOptionList(this.consoleExecutor.getAllConsoleOptions());
        OptionSpecBuilder configSpec = this.parser.accepts(this.applicationConfigOptions.getConfigOption());
        this.applicationConfigOptions.getConsoleOptionList().stream().forEach(consoleOption -> {
            OptionSpecBuilder optionSpecBuilder2 = this.parser.accepts(consoleOption.getOption()).availableIf((OptionSpec)configSpec, new OptionSpec[0]);
            if (consoleOption.hasArgument()) {
                optionSpecBuilder2.withRequiredArg().ofType(consoleOption.getArgumentType());
            }
        });
        InfoOptionContributor infoOptionContributor = new InfoOptionContributor();
        OptionSpecBuilder infoConfigSpec = this.parser.accepts(infoOptionContributor.getConfigOption());
        infoOptionContributor.getConsoleOptionList().stream().forEach(consoleOption -> {
            OptionSpecBuilder optionSpecBuilder2 = this.parser.accepts(consoleOption.getOption()).availableIf((OptionSpec)infoConfigSpec, new OptionSpec[0]);
            if (consoleOption.hasArgument()) {
                optionSpecBuilder2.withRequiredArg().ofType(consoleOption.getArgumentType());
            }
        });
    }

    public void acceptConsoleOptionList(List<ConsoleOption<?>> consoleOptionList) {
        for (ConsoleOption<?> consoleOption : consoleOptionList) {
            OptionSpecBuilder optionSpecBuilder = this.parser.accepts(consoleOption.getOption());
            if (!consoleOption.hasArgument()) continue;
            optionSpecBuilder.withRequiredArg().ofType(consoleOption.getArgumentType());
        }
    }

    public ConsoleExecutor getConsoleExecutor() {
        return this.consoleExecutor;
    }

    public ApplicationConfigOptions getApplicationConfigOptions() {
        return this.applicationConfigOptions;
    }

    public List<String> getAddedArguments() {
        return this.addedArguments;
    }

    public void setAddedArguments(List<String> addedArguments) {
        this.addedArguments = addedArguments;
    }

    public OptionParser getParser() {
        return this.parser;
    }

    public Map<String, String> getConsoleOptionValueMap() {
        return this.consoleOptionValueMap;
    }

    public OptionSet getOptions() {
        return this.options;
    }

    public String[] getArguments() {
        return this.arguments;
    }
}

