/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.console.handlers;

import com.kms.katalon.application.KatalonApplicationActivator;
import com.kms.katalon.application.utils.ActivationInfoCollector;
import com.kms.katalon.application.utils.ApplicationContext;
import com.kms.katalon.application.utils.ApplicationInfo;
import com.kms.katalon.application.utils.LicenseInfo;
import com.kms.katalon.application.utils.MachineUtil;
import com.kms.katalon.console.constants.ConsoleMessageConstants;
import com.kms.katalon.console.entity.OnlineActivationInfo;
import com.kms.katalon.console.handlers.ArgumentOptionsHandler;
import com.kms.katalon.constants.GlobalMessageConstants;
import com.kms.katalon.constants.GlobalStringConstants;
import com.kms.katalon.execution.constants.ExecutionMessageConstants;
import com.kms.katalon.execution.constants.StringConstants;
import com.kms.katalon.execution.exception.InvalidConsoleArgumentException;
import com.kms.katalon.execution.handler.ApiKeyHandler;
import com.kms.katalon.execution.util.LocalInformationUtil;
import com.kms.katalon.feature.TestOpsMessageError;
import com.kms.katalon.integration.analytics.providers.TestOpsService;
import com.kms.katalon.license.ConsoleLicenseService;
import com.kms.katalon.license.models.ConsoleLicenseType;
import com.kms.katalon.logging.LogUtil;
import java.text.MessageFormat;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;

public class ActivationHandler {
    private OnlineActivationInfo activationInfo;
    private String apiKey;
    private String adminServerUrl;
    private String machineId;
    private String orgId;

    public ActivationHandler() {
        this.initialAdminServerUrl();
        this.initialApiKey();
        this.machineId = MachineUtil.getMachineId();
        this.orgId = ArgumentOptionsHandler.getInstance().getOrganizationId();
    }

    private void initialApiKey() {
        this.apiKey = ArgumentOptionsHandler.getInstance().getApiKeyValue();
        if (StringUtils.isNotEmpty((CharSequence)this.apiKey)) {
            ApiKeyHandler.setApiKeyToProject((String)this.apiKey);
        }
    }

    private void initialAdminServerUrl() {
        ArgumentOptionsHandler.getInstance().getAdminServerUrl();
        this.adminServerUrl = ApplicationInfo.getAdminServer();
    }

    private int activateOffline() throws Exception {
        boolean isActivated = false;
        LogUtil.logInfo((String)ExecutionMessageConstants.ACTIVATE_START_ACTIVATE_OFFLINE);
        StringBuilder errorMessage = new StringBuilder();
        if (ActivationInfoCollector.activateOfflineForEngineAmiMachine((StringBuilder)errorMessage)) {
            isActivated = true;
            LogUtil.logInfo((String)ExecutionMessageConstants.ACTIVATE_SUCCESS_BY_AMI);
        } else {
            isActivated = ActivationInfoCollector.activateOfflineForEngine((StringBuilder)errorMessage);
            String error = errorMessage.toString();
            if (StringUtils.isNotBlank((CharSequence)error)) {
                LogUtil.printErrorLine((String)(String.valueOf(error) + "\n"));
            }
            int validOfflineLicenseSessionNumber = ActivationInfoCollector.getValidOfflineLicenseNumber();
            if (!isActivated && validOfflineLicenseSessionNumber != 0) {
                LogUtil.printErrorLine((String)ExecutionMessageConstants.ACTIVATE_FAIL_OFFLINE);
            }
        }
        return isActivated ? 200 : -1;
    }

    private int testInternetConnection() throws Exception {
        StringBuilder testConnectionStatusCode = new StringBuilder();
        boolean flagPrintErrorOnce = false;
        int retryCount = this.activationInfo.getRetryCount();
        do {
            if (retryCount > 0) {
                long waitTime = (long)Math.pow(2.0, retryCount - 1);
                try {
                    TimeUnit.SECONDS.sleep(waitTime);
                }
                catch (InterruptedException interruptedException) {}
                this.activationInfo.setServerError(false);
                this.activationInfo.getTrackingErrorMessage().setLength(0);
                testConnectionStatusCode.setLength(0);
            }
            boolean testConnection = KatalonApplicationActivator.getFeatureActivator().testConnection(this.adminServerUrl, testConnectionStatusCode);
            if (StringUtils.isNotEmpty((CharSequence)testConnectionStatusCode)) {
                String statusCode;
                int statusCodeInt;
                if (!flagPrintErrorOnce) {
                    flagPrintErrorOnce = true;
                    LogUtil.printErrorLine((String)ExecutionMessageConstants.ACTIVATE_FAIL_ONLINE);
                }
                if (500 <= (statusCodeInt = Integer.parseInt(statusCode = testConnectionStatusCode.toString())) && statusCodeInt <= 599) {
                    this.activationInfo.setServerError(true);
                    this.activationInfo.setTrackingErrorMessage(this.activationInfo.getTrackingErrorMessage().append(ExecutionMessageConstants.ACTIVATE_MSG_TESTOP_UNAVAILABLE));
                    this.activationInfo.setUserName(ApplicationContext.getInstance().getUserId());
                    if (StringUtils.isEmpty((CharSequence)this.activationInfo.getUserName())) {
                        this.activationInfo.setUserName(GlobalStringConstants.USERNAME_ANONYMOUS);
                    }
                    ActivationInfoCollector.sendTrackingForActivate((String)this.activationInfo.getUserName(), (String)this.machineId, (boolean)false, (StringBuilder)this.activationInfo.getTrackingErrorMessage(), (boolean)true, (Integer)retryCount);
                    int retryingWaitTimeInfo = (int)Math.pow(2.0, retryCount);
                    if (++retryCount <= 3) {
                        LogUtil.printOutputLine((String)MessageFormat.format(ExecutionMessageConstants.ACTIVATE_RETRYING, retryingWaitTimeInfo));
                    }
                }
            }
            if (testConnection || this.activationInfo.isServerError()) continue;
            LogUtil.logError((String)ExecutionMessageConstants.ACTIVATE_CANNOT_CONNECT_TO_SERVER);
            return 3;
        } while (this.activationInfo.isServerError() && retryCount <= 3);
        this.activationInfo.setRetryCount(retryCount);
        return 200;
    }

    private void handleErrorMsg(TestOpsMessageError errorMessage, boolean isPrintLogError) throws Exception {
        String error = errorMessage.getMessage();
        if (StringUtils.isNotBlank((CharSequence)error)) {
            if (isPrintLogError) {
                LogUtil.printErrorLine((String)(String.valueOf(error) + "\n"));
            }
            this.activationInfo.appendTrackingErrorMessage(error);
            String errorType = errorMessage.getError();
            if (StringUtils.isNotBlank((CharSequence)errorType)) {
                this.activationInfo.setUserName(this.setUsernameByErrorMessageType(errorType, this.adminServerUrl, this.apiKey));
            }
        }
    }

    private void activateWithLicenseInfo(OnlineActivationInfo info) throws Exception {
        String server = LicenseInfo.getServerURL();
        String apiKey = LicenseInfo.getApiKey();
        if (!StringUtils.isEmpty((CharSequence)server) && !StringUtils.isEmpty((CharSequence)apiKey)) {
            server = server.trim();
            apiKey = apiKey.trim();
            LogUtil.logInfo((String)ExecutionMessageConstants.ACTIVATE_START_ACTIVATE_ONLINE_WITH_LICENSE_SERVER);
            ApplicationInfo.setTestOpsServer((String)server);
            ApplicationInfo.setAdminServer((String)server);
            LocalInformationUtil.printLicenseServerInfo((String)server, (String)apiKey);
            TestOpsMessageError errorMessage = new TestOpsMessageError();
            info.setActivated(ActivationInfoCollector.checkAndMarkActivatedForConsoleMode((String)apiKey, (Long)this.parseOrganizationId(), (TestOpsMessageError)errorMessage));
            info.setTestOpsMsgErr(errorMessage);
            this.handleErrorMsg(errorMessage, true);
        }
    }

    private void activateWithConsoleArgOptions(OnlineActivationInfo info) throws Exception {
        TestOpsMessageError errorMessage = new TestOpsMessageError();
        info.setActivated(ActivationInfoCollector.checkAndMarkActivatedForConsoleMode((String)this.apiKey, (Long)this.parseOrganizationId(), (TestOpsMessageError)errorMessage));
        info.setTestOpsMsgErr(errorMessage);
        this.handleErrorMsg(errorMessage, false);
    }

    private void releaseLicense() throws Exception {
        boolean licenseReleaseValue = ArgumentOptionsHandler.getInstance().getKatalonLicense();
        if (licenseReleaseValue) {
            if (StringUtils.isNotBlank((CharSequence)this.orgId)) {
                ActivationInfoCollector.releaseLicense((Long)this.parseOrganizationId());
            } else {
                LogUtil.printErrorLine((String)ExecutionMessageConstants.RELEASE_FAIL_ONLINE_NO_ORGID);
            }
        }
    }

    private int activationWithTestOps() throws Exception {
        LogUtil.logInfo((String)ExecutionMessageConstants.ACTIVATE_START_ACTIVATE_ONLINE);
        TestOpsService.getInstance().setAdminServer(this.adminServerUrl);
        if (this.activationInfo.isServerError() || this.activationInfo.getRetryCount() > 3) {
            LogUtil.printErrorLine((String)ExecutionMessageConstants.ACTIVATE_FAIL_ONLINE);
            LogUtil.printErrorLine((String)ExecutionMessageConstants.ACTIVATE_SERVER_ERROR);
            return 3;
        }
        if (!this.activationInfo.isActivated()) {
            this.releaseLicense();
        }
        this.activateWithConsoleArgOptions(this.activationInfo);
        if (!this.activationInfo.isActivated()) {
            this.activateWithLicenseInfo(this.activationInfo);
        }
        if (StringUtils.isBlank((CharSequence)this.activationInfo.getUserName())) {
            this.activationInfo.setUserName(KatalonApplicationActivator.getFeatureActivator().getCurrentUserEmail());
        }
        int code = this.trackingAndReturnCode();
        return code;
    }

    private int trackingAndReturnCode() {
        if (!this.activationInfo.isActivated()) {
            this.activationInfo.appendTrackingErrorMessage(ExecutionMessageConstants.ACTIVATE_FAIL_RUNTIME_ENGINE);
            if (this.activationInfo.getRetryCount() > 3) {
                this.activationInfo.setRetryCount(3);
            }
            ActivationInfoCollector.sendTrackingForActivate((String)this.activationInfo.getUserName(), (String)this.machineId, (boolean)false, (StringBuilder)this.activationInfo.getTrackingErrorMessage(), (boolean)true, (Integer)this.activationInfo.getRetryCount());
        } else {
            ActivationInfoCollector.sendTrackingForActivate((String)this.activationInfo.getUserName(), (String)this.machineId, (boolean)true, (StringBuilder)this.activationInfo.getTrackingErrorMessage(), (boolean)false, (Integer)this.activationInfo.getRetryCount());
        }
        return this.activationInfo.isActivated() ? 200 : 3;
    }

    public int activate() throws Exception {
        int code = 0;
        TestOpsService.getInstance().setCredential(this.apiKey);
        if (!ActivationInfoCollector.isActivated() && ConsoleLicenseService.getInstance().getLicenseType() == null) {
            ConsoleLicenseType licenseType;
            int internetCode;
            code = this.activateOffline();
            this.activationInfo = new OnlineActivationInfo();
            if (code != 200 && (internetCode = this.testInternetConnection()) == 200) {
                code = this.activationWithTestOps();
            }
            if ((licenseType = this.grantConsoleLicenseType(code)) != null) {
                code = 200;
                ConsoleLicenseService.getInstance().setLicenseType(licenseType);
            } else {
                code = 3;
            }
            this.printConsoleLicenseInfo(licenseType);
        }
        return code;
    }

    private void logActivateWithKRE(boolean success) {
        if (success) {
            LogUtil.logInfo((String)MessageFormat.format(ConsoleMessageConstants.ACTIVATE_SUCCESS, GlobalMessageConstants.KATALON_RUNTIME_ENGINE_NAME));
        } else {
            String testOpsErr = this.activationInfo.getTestOpsMsgErr() != null ? String.valueOf(this.activationInfo.getTestOpsMsgErr().getMessage()) + " " + this.activationInfo.getTestOpsMsgErr().getException().getMessage() : "";
            LogUtil.logInfo((String)MessageFormat.format(ConsoleMessageConstants.ACTIVATE_FAILED, GlobalMessageConstants.KATALON_RUNTIME_ENGINE_NAME, testOpsErr));
        }
    }

    private void logActivateWithTestCloud(boolean success) {
        if (success) {
            LogUtil.logInfo((String)MessageFormat.format(ConsoleMessageConstants.ACTIVATE_SUCCESS, GlobalMessageConstants.TESTCLOUD_NAME));
        } else {
            String testCloudErr = this.activationInfo.getTestCloudErr() != null ? this.activationInfo.getTestCloudErr().getMessage() : "";
            LogUtil.logInfo((String)MessageFormat.format(ConsoleMessageConstants.ACTIVATE_FAILED, GlobalMessageConstants.TESTCLOUD_NAME, testCloudErr));
        }
    }

    private void logActivate(boolean KRESuccess, boolean TCSuccess) {
        this.logActivateWithKRE(KRESuccess);
        this.logActivateWithTestCloud(TCSuccess);
    }

    private void printConsoleLicenseInfo(ConsoleLicenseType licenseType) {
        if (licenseType != null) {
            switch (licenseType) {
                case ALL: {
                    this.logActivate(true, true);
                    break;
                }
                case KRE_LICENSE: {
                    this.logActivate(true, false);
                    break;
                }
                case TESTCLOUD_LICENSE: {
                    this.logActivate(false, true);
                    break;
                }
            }
        } else {
            this.logActivate(false, false);
        }
    }

    private ConsoleLicenseType grantConsoleLicenseType(int KREcode) {
        boolean isValidTC = this.activateWithTestCloud();
        boolean isValidKRE = KREcode == 200;
        return ActivationHandler.getConsoleLicenseType(isValidTC, isValidKRE);
    }

    private static ConsoleLicenseType getConsoleLicenseType(boolean isValidTC, boolean isValidKRE) {
        if (isValidKRE && isValidTC) {
            return ConsoleLicenseType.ALL;
        }
        if (!isValidKRE && isValidTC) {
            return ConsoleLicenseType.TESTCLOUD_LICENSE;
        }
        if (isValidKRE && !isValidTC) {
            return ConsoleLicenseType.KRE_LICENSE;
        }
        return null;
    }

    private boolean activateWithTestCloud() {
        boolean checkActivated = false;
        try {
            checkActivated = ActivationInfoCollector.checkTestCloudActivated((String)this.orgId);
        }
        catch (Exception e) {
            this.activationInfo.setTestCloudErr(e);
        }
        return checkActivated;
    }

    private String setUsernameByErrorMessageType(String errorType, String serverUrl, String apiKey) throws Exception {
        String userName = "";
        if (errorType == null) {
            errorType = "";
        }
        switch (errorType.toLowerCase()) {
            case "invalid_grant": {
                userName = GlobalStringConstants.USERNAME_ANONYMOUS;
                break;
            }
            default: {
                userName = KatalonApplicationActivator.getFeatureActivator().getCurrentUserEmail();
                if (userName != null) break;
                userName = GlobalStringConstants.USERNAME_ANONYMOUS;
            }
        }
        return userName;
    }

    private Long parseOrganizationId() throws InvalidConsoleArgumentException {
        Long orgIdValue = null;
        try {
            if (this.orgId != null) {
                orgIdValue = Long.valueOf(this.orgId);
            }
            return orgIdValue;
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidConsoleArgumentException(String.format(StringConstants.MNG_PRT_ORGANIZATION_ID_IS_INVALID, new Object[0]));
        }
    }
}

