/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.console.handlers;

import com.katalon.platform.internal.api.PluginInstaller;
import com.kms.katalon.application.constants.ApplicationMessageConstants;
import com.kms.katalon.application.utils.ActivationInfoCollector;
import com.kms.katalon.console.entity.ConsoleLauncherEntity;
import com.kms.katalon.execution.console.LauncherOptionParserFactory;
import com.kms.katalon.execution.launcher.manager.LauncherManager;
import com.kms.katalon.execution.util.ApiKey;
import com.kms.katalon.feature.TestOpsMessageError;
import com.kms.katalon.license.ConsoleLicenseService;
import com.kms.katalon.logging.LogUtil;
import java.io.File;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;

public class PluginHandler {
    private static void reloadPlugins(String apiKey) throws Exception {
        Bundle katalonBundle = Platform.getBundle((String)"com.kms.katalon.activation");
        Class reloadPluginsHandlerClass = katalonBundle.loadClass("com.kms.katalon.activation.plugin.handler.ConsoleModeReloadPluginsHandler");
        Object handler = reloadPluginsHandlerClass.newInstance();
        Method reloadMethod = Arrays.asList(reloadPluginsHandlerClass.getMethods()).stream().filter(method -> method.getName().equals("reload")).findAny().orElse(null);
        if (reloadMethod != null) {
            reloadMethod.invoke(handler, apiKey);
        }
    }

    private static void installPlugin(String filePath) throws InterruptedException, BundleException {
        BundleContext context = Platform.getBundle((String)"com.katalon.platform").getBundleContext();
        ServiceReference serviceReference = context.getServiceReference(PluginInstaller.class);
        PluginInstaller pluginInstaller = (PluginInstaller)context.getService(serviceReference);
        if (!filePath.equals("")) {
            pluginInstaller.installPlugin(context, new File(filePath).toURI().toString());
        }
    }

    public static void loadPluginsToConsole(ConsoleLauncherEntity consoleLauncherEntity) throws Exception {
        PluginHandler.reloadPlugins(ApiKey.get());
        consoleLauncherEntity.getConsoleExecutor().addAndPrioritizeLauncherOptionParser(LauncherOptionParserFactory.getInstance().getBuilders().stream().map(a -> a.getPluginLauncherOptionParser()).collect(Collectors.toList()));
        consoleLauncherEntity.acceptConsoleOptionList(consoleLauncherEntity.getConsoleExecutor().getAllConsoleOptions());
        if (consoleLauncherEntity.getOptions().has("installPlugin")) {
            PluginHandler.installPlugin(String.valueOf(consoleLauncherEntity.getOptions().valueOf("installPlugin")));
            consoleLauncherEntity.getConsoleExecutor().addAndPrioritizeLauncherOptionParser(LauncherOptionParserFactory.getInstance().getBuilders().stream().map(a -> a.getPluginLauncherOptionParser()).collect(Collectors.toList()));
            consoleLauncherEntity.acceptConsoleOptionList(consoleLauncherEntity.getConsoleExecutor().getAllConsoleOptions());
        }
        consoleLauncherEntity.updateOptions();
    }

    public static void checkPluginLicense(String apiKey, Long orgId) {
        HashMap<String, String> localStore = new HashMap<String, String>();
        localStore.put("apiKey", apiKey);
        localStore.put("lastActivateErrorMessage", ActivationInfoCollector.DEFAULT_REASON);
        ActivationInfoCollector.scheduleCheckLicense(() -> {
            String lastActivateErrorMessage = (String)localStore.get("lastActivateErrorMessage");
            if (ConsoleLicenseService.getInstance().getLicenseType() == null) {
                LogUtil.printErrorLine((String)MessageFormat.format(ApplicationMessageConstants.LICENSE_EXPIRED_MESSAGE, lastActivateErrorMessage));
                LauncherManager.getInstance().stopAllLauncher();
            }
        }, () -> {
            TestOpsMessageError errorMessage = new TestOpsMessageError();
            String apiKeyStore = (String)localStore.get("apiKey");
            ActivationInfoCollector.checkAndMarkActivatedForConsoleMode((String)apiKeyStore, (Long)orgId, (TestOpsMessageError)errorMessage);
            String error = errorMessage.getMessage();
            if (StringUtils.isNotBlank((CharSequence)error)) {
                LogUtil.printErrorLine((String)error);
                localStore.put("lastActivateErrorMessage", error);
            }
        });
    }
}

