/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.selenium.firefox;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import org.openqa.selenium.Beta;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.firefox.FirefoxProfile;
import org.openqa.selenium.firefox.UnableToCreateProfileException;
import org.openqa.selenium.io.FileHandler;

public class CFirefoxProfile
extends FirefoxProfile {
    private File model;

    public CFirefoxProfile() {
        this(null);
    }

    public CFirefoxProfile(File profileDir) {
        this(null, profileDir);
    }

    @Beta
    @VisibleForTesting
    protected CFirefoxProfile(Reader defaultsReader, File profileDir) {
        super(defaultsReader, profileDir);
        this.model = profileDir;
    }

    protected void cleanTemporaryModel() {
        this.clean(this.model);
    }

    public File layoutOnDisk() {
        try {
            File profileDir = this.createTempDir("anonymous", "webdriver-profile");
            File userPrefs = new File(profileDir, "user.js");
            this.copyModel(this.model, profileDir);
            this.installExtensions(profileDir);
            this.deleteLockFiles(profileDir);
            this.deleteExtensionsCacheIfItExists(profileDir);
            this.updateUserPrefs(userPrefs);
            return profileDir;
        }
        catch (IOException e) {
            throw new UnableToCreateProfileException((Throwable)e);
        }
    }

    private File createTempDir(String prefix, String suffix) {
        File baseDir = new File(System.getProperty("java.io.tmpdir"));
        try {
            File dir = new File(baseDir, String.valueOf(prefix) + System.currentTimeMillis() + suffix);
            if (!dir.mkdirs()) {
                throw new WebDriverException("Cannot create profile directory at " + dir.getAbsolutePath());
            }
            FileHandler.createDir((File)dir);
            return dir;
        }
        catch (IOException iOException) {
            throw new WebDriverException("Unable to create temporary file at " + baseDir.getAbsolutePath());
        }
    }
}

