/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.selenium.firefox;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.FilenameUtils;
import org.openqa.selenium.firefox.internal.Extension;
import org.openqa.selenium.io.FileHandler;
import org.openqa.selenium.io.TemporaryFilesystem;
import org.openqa.selenium.io.Zip;

public class FirefoxWebExtension
implements Extension {
    private final File toInstall;
    private String uuid;

    public FirefoxWebExtension(File toInstall, String uuid) {
        this.toInstall = toInstall;
        this.uuid = uuid;
    }

    public void writeTo(File extensionsDir) throws IOException {
        if (!(this.toInstall.isDirectory() || FileHandler.isZipped((String)this.toInstall.getAbsolutePath()) || "xpi".equals(FilenameUtils.getExtension((String)this.toInstall.getName())))) {
            throw new IOException(String.format("Can only install from a zip file, an XPI or a directory: %s", this.toInstall.getAbsolutePath()));
        }
        File root = this.obtainRootDirectory(this.toInstall);
        String id = this.uuid;
        File extensionDirectory = new File(extensionsDir, id);
        if (extensionDirectory.exists() && !FileHandler.delete((File)extensionDirectory)) {
            throw new IOException("Unable to delete existing extension directory: " + extensionDirectory);
        }
        FileHandler.createDir((File)extensionDirectory);
        FileHandler.makeWritable((File)extensionDirectory);
        FileHandler.copy((File)root, (File)extensionDirectory);
        TemporaryFilesystem.getDefaultTmpFS().deleteTempDir(root);
    }

    private File obtainRootDirectory(File extensionToInstall) throws IOException {
        File root = extensionToInstall;
        if (!extensionToInstall.isDirectory()) {
            root = TemporaryFilesystem.getDefaultTmpFS().createTempDir("katalon_addon", "firefox");
            try (BufferedInputStream bis = new BufferedInputStream(new FileInputStream(extensionToInstall));){
                Zip.unzip((InputStream)bis, (File)root);
            }
        }
        return root;
    }
}

