/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.codeassist.completions;

import java.util.Map;
import org.codehaus.groovy.eclipse.codeassist.GroovyContentAssist;
import org.codehaus.groovy.eclipse.codeassist.ProposalUtils;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.groovy.core.util.ArrayUtils;
import org.eclipse.jdt.groovy.search.VariableScope;
import org.eclipse.jdt.internal.codeassist.impl.AssistOptions;
import org.eclipse.jdt.internal.ui.text.java.FieldProposalInfo;
import org.eclipse.jdt.internal.ui.text.java.JavaCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.ParameterGuesser;
import org.eclipse.jdt.internal.ui.text.java.ProposalInfo;
import org.eclipse.jdt.internal.ui.text.template.contentassist.PositionBasedCompletionProposal;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.swt.graphics.Image;

public class ParameterGuesserDelegate {
    private final ParameterGuesser guesser;
    private final JavaContentAssistInvocationContext invocationContext;

    public ParameterGuesserDelegate(IJavaElement enclosingElement, JavaContentAssistInvocationContext invocationContext) {
        this.guesser = new ParameterGuesser(enclosingElement);
        this.invocationContext = invocationContext;
    }

    public ICompletionProposal[] parameterProposals(String parameterType, String paramName, Position position, IJavaElement[] suggestions, boolean fillBestGuess) {
        try {
            IType declaring;
            ICompletionProposal[] completions = this.guesser.parameterProposals(parameterType, paramName, position, suggestions, fillBestGuess, false);
            if (completions != null && completions.length > 0 && suggestions != null && suggestions.length > 0 && (declaring = (IType)suggestions[suggestions.length - 1].getAncestor(7)) != null && declaring.isEnum()) {
                boolean preferStaticImport = this.isStaticImportPreferred();
                int i = 0;
                while (i < completions.length) {
                    ICompletionProposal completion = completions[i];
                    IJavaElement suggestion = null;
                    int j = suggestions.length - 1;
                    while (j >= 0) {
                        if (suggestions[j].getElementType() == 8 && suggestions[j].getElementName().equals(completion.getDisplayString())) {
                            suggestion = suggestions[j];
                            break;
                        }
                        --j;
                    }
                    if (suggestion != null) {
                        CompletionProposal supporting;
                        String replacement = completion.getDisplayString();
                        if (preferStaticImport) {
                            supporting = CompletionProposal.create((int)21, (int)0);
                            supporting.setAdditionalFlags(1);
                            supporting.setDeclarationSignature(Signature.createTypeSignature((String)declaring.getFullyQualifiedName(), (boolean)true).toCharArray());
                            supporting.setName(replacement.toCharArray());
                        } else {
                            supporting = CompletionProposal.create((int)23, (int)0);
                            supporting.setSignature(Signature.createTypeSignature((String)declaring.getFullyQualifiedName(), (boolean)true).toCharArray());
                        }
                        completions[i] = this.newEnumProposal(position, replacement, supporting, completion.getImage(), ((PositionBasedCompletionProposal)completion).getTriggerCharacters());
                    }
                    ++i;
                }
            }
            return this.addExtras(completions, parameterType, position);
        }
        catch (Exception e) {
            GroovyContentAssist.logError(e);
            return ProposalUtils.NO_COMPLETIONS;
        }
    }

    private ICompletionProposal[] addExtras(ICompletionProposal[] parameterProposals, String expectedType, Position position) {
        PositionBasedCompletionProposal proposal = null;
        if (VariableScope.BYTE_CLASS_NODE.getName().equals(expectedType) || VariableScope.CHARACTER_CLASS_NODE.getName().equals(expectedType) || VariableScope.DOUBLE_CLASS_NODE.getName().equals(expectedType) || VariableScope.FLOAT_CLASS_NODE.getName().equals(expectedType) || VariableScope.INTEGER_CLASS_NODE.getName().equals(expectedType) || VariableScope.LONG_CLASS_NODE.getName().equals(expectedType) || VariableScope.SHORT_CLASS_NODE.getName().equals(expectedType)) {
            proposal = new PositionBasedCompletionProposal("0", position, 1);
        } else if (VariableScope.BOOLEAN_CLASS_NODE.getName().equals(expectedType)) {
            proposal = new PositionBasedCompletionProposal("false", position, 5);
            parameterProposals = (ICompletionProposal[])ArrayUtils.add((Object[])parameterProposals, (int)(parameterProposals.length - 1), (Object)proposal);
            proposal = new PositionBasedCompletionProposal("true", position, 4);
        } else if (VariableScope.STRING_CLASS_NODE.getName().equals(expectedType)) {
            proposal = new PositionBasedCompletionProposal("\"\"", position, 1);
        } else if (VariableScope.CLOSURE_CLASS_NODE.getName().equals(expectedType)) {
            proposal = new PositionBasedCompletionProposal("{  }", position, 2);
        }
        if (proposal != null) {
            if (parameterProposals[parameterProposals.length - 1].getDisplayString().equals("null")) {
                if (VariableScope.CLOSURE_CLASS_NODE.getName().equals(expectedType) && GroovyContentAssist.getDefault().getPreferenceStore().getBoolean("org.codehaus.groovy.eclipse.codeassist.closures.literals")) {
                    int i = parameterProposals.length - 1;
                    while (i > 0) {
                        parameterProposals[i] = parameterProposals[i - 1];
                        --i;
                    }
                    parameterProposals[0] = proposal;
                } else {
                    parameterProposals[parameterProposals.length - 1] = proposal;
                }
            } else {
                parameterProposals = (ICompletionProposal[])ArrayUtils.add((Object[])parameterProposals, (Object)proposal);
            }
        }
        return parameterProposals;
    }

    private boolean isStaticImportPreferred() {
        if (PreferenceConstants.getPreferenceStore().getBoolean("content_assist_add_import")) {
            return new AssistOptions((Map)this.invocationContext.getProject().getOptions((boolean)true)).suggestStaticImport;
        }
        return false;
    }

    private ICompletionProposal newEnumProposal(final Position position, String replacement, CompletionProposal supporting, Image image, char[] triggers) {
        CompletionProposal groovyProposal = CompletionProposal.create((int)6, (int)0);
        groovyProposal.setRequiredProposals(new CompletionProposal[]{supporting});
        JavaCompletionProposal javaProposal = new JavaCompletionProposal(replacement, 0, 0, image, null, 1, false, this.invocationContext){

            private int getInitialGuessLength() {
                return this.fInvocationContext.getViewer().getSelectedRange().y;
            }

            public int getReplacementLength() {
                return position.getLength();
            }

            public int getReplacementOffset() {
                return position.getOffset();
            }

            public void setReplacementOffset(int offset) {
                if (offset > position.getOffset() && position.getLength() > this.getInitialGuessLength()) {
                    offset = position.getOffset() + (position.getLength() - this.getInitialGuessLength());
                    position.setOffset(offset);
                    position.setLength(this.getInitialGuessLength());
                }
            }
        };
        javaProposal.setProposalInfo((ProposalInfo)new FieldProposalInfo(this.invocationContext.getProject(), groovyProposal));
        javaProposal.setTriggerCharacters(triggers);
        return javaProposal;
    }
}

