/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.codeassist.processors;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.eclipse.codeassist.GroovyContentAssist;
import org.codehaus.groovy.eclipse.codeassist.ProposalUtils;
import org.codehaus.groovy.eclipse.codeassist.processors.AbstractGroovyCompletionProcessor;
import org.codehaus.groovy.eclipse.codeassist.processors.GroovyCompletionProposal;
import org.codehaus.groovy.eclipse.codeassist.processors.IProposalProvider;
import org.codehaus.groovy.eclipse.codeassist.processors.ProposalProviderRegistry;
import org.codehaus.groovy.eclipse.codeassist.relevance.Relevance;
import org.codehaus.groovy.eclipse.codeassist.requestor.ContentAssistContext;
import org.codehaus.groovy.transform.trait.Traits;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.core.CompletionRequestor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.groovy.core.util.GroovyUtils;
import org.eclipse.jdt.groovy.search.GenericsMapper;
import org.eclipse.jdt.groovy.search.VariableScope;
import org.eclipse.jdt.internal.codeassist.CompletionEngine;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.core.SearchableEnvironment;
import org.eclipse.jdt.internal.ui.text.java.OverrideCompletionProposal;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.jface.text.contentassist.ICompletionProposal;

public class NewMethodCompletionProcessor
extends AbstractGroovyCompletionProcessor {
    private final Map<ClassNode, GenericsMapper> mappers = new HashMap<ClassNode, GenericsMapper>();

    public NewMethodCompletionProcessor(ContentAssistContext context, JavaContentAssistInvocationContext javaContext, SearchableEnvironment nameEnvironment) {
        super(context, javaContext, nameEnvironment);
    }

    @Override
    public List<ICompletionProposal> generateProposals(IProgressMonitor progressMonitor) {
        ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
        ContentAssistContext context = this.getContext();
        if (context.getEnclosingType() != null) {
            for (MethodNode method : NewMethodCompletionProcessor.collectUnimplementedMethods(context.completionExpression, context.getEnclosingGroovyType())) {
                proposals.add(this.createProposal(method, progressMonitor));
            }
        }
        try {
            for (IProposalProvider provider : ProposalProviderRegistry.getRegistry().getProvidersFor(context.unit)) {
                List<MethodNode> methods = provider.getNewMethodProposals(context);
                if (methods == null) continue;
                for (MethodNode method : methods) {
                    proposals.add(this.createProposal(method, progressMonitor));
                }
            }
        }
        catch (CoreException e) {
            GroovyContentAssist.logError("Exception looking for proposal providers in " + context.unit.getElementName(), e);
        }
        return proposals;
    }

    private ICompletionProposal createProposal(MethodNode method, IProgressMonitor progressMonitor) {
        ContentAssistContext context = this.getContext();
        IJavaProject project = this.getJavaContext().getProject();
        ClassNode declaringClass = method.getDeclaringClass();
        GroovyCompletionProposal proposal = this.createProposal(7, context.completionLocation);
        proposal.setDeclarationSignature(ProposalUtils.createTypeSignature(declaringClass));
        proposal.setSignature(ProposalUtils.createMethodSignature(method));
        proposal.setName(method.getName().toCharArray());
        proposal.setFlags(method.getModifiers());
        char[][] parameterNames = ProposalUtils.getParameterNames(method.getParameters());
        if (parameterNames.length > 0 && CharOperation.equals((char[])parameterNames[0], (char[])ProposalUtils.ARG0)) {
            proposal.setCompletionEngine(new CompletionEngine(this.getNameEnvironment(), new CompletionRequestor(){

                public void accept(CompletionProposal proposal) {
                }
            }, null, project, null, null));
            proposal.setDeclarationPackageName(Optional.ofNullable(declaringClass.getPackageName()).map(String::toCharArray).orElse(CharOperation.NO_CHAR));
            proposal.setDeclarationTypeName(ProposalUtils.createSimpleTypeName(declaringClass));
            int i = 0;
            while (i < parameterNames.length) {
                parameterNames[i] = ProposalUtils.ARG_;
                ++i;
            }
            proposal.findParameterNames(progressMonitor);
        } else {
            proposal.setParameterNames(parameterNames);
        }
        if (declaringClass.isUsingGenerics()) {
            GenericsMapper mapper = this.mappers.computeIfAbsent(declaringClass, x -> {
                ClassNode enclosingClass = NewMethodCompletionProcessor.findResolvedType(context.getEnclosingGroovyType(), declaringClass);
                return GenericsMapper.gatherGenerics((ClassNode)enclosingClass, (ClassNode)declaringClass);
            });
            method = VariableScope.resolveTypeParameterization((GenericsMapper)mapper, (MethodNode)method);
            proposal.setSignature(ProposalUtils.createMethodSignature(method));
        }
        proposal.setCompletion(NewMethodCompletionProcessor.createMethodCompletion(method, parameterNames));
        int length = context.completionExpression.length();
        int offset = context.completionLocation - length;
        String[] parameterTypeNames = CharOperation.toStrings((char[][])ProposalUtils.getParameterTypeNames(method.getParameters()));
        OverrideCompletionProposal override = new OverrideCompletionProposal(project, (ICompilationUnit)context.unit, method.getName(), parameterTypeNames, offset, length, ProposalUtils.createDisplayString((CompletionProposal)proposal), String.valueOf(proposal.getCompletion()));
        override.setImage(ProposalUtils.getImage((CompletionProposal)proposal));
        override.setRelevance(Relevance.VERY_HIGH.getRelevance(VariableScope.OBJECT_CLASS_NODE.equals((Object)declaringClass) ? 0.99f : 1.0f));
        return override;
    }

    private static List<MethodNode> collectUnimplementedMethods(String completionExpression, ClassNode declaringType) {
        LinkedHashMap<String, MethodNode> methods = new LinkedHashMap<String, MethodNode>();
        LinkedList<ClassNode> types = new LinkedList<ClassNode>();
        types.add(declaringType);
        do {
            ClassNode type = (ClassNode)types.remove();
            Collections.addAll(types, type.getInterfaces());
            if (type.getSuperClass() != null) {
                types.add(type.getSuperClass());
            }
            for (MethodNode meth2 : type.getMethods()) {
                String name = meth2.getName();
                if (!name.startsWith(completionExpression) || name.indexOf(36) >= 0 || name.indexOf(60) >= 0 || NewMethodCompletionProcessor.isTraitBridge(meth2)) continue;
                methods.putIfAbsent(meth2.getTypeDescriptor(), meth2);
            }
        } while (!types.isEmpty());
        for (MethodNode meth3 : declaringType.getMethods()) {
            if (NewMethodCompletionProcessor.isTraitBridge(meth3)) continue;
            methods.remove(meth3.getTypeDescriptor());
        }
        return methods.values().stream().filter(meth -> !meth.isFinal() && !meth.isPrivate() && !meth.isStatic()).collect(Collectors.toList());
    }

    private static char[] createMethodCompletion(MethodNode method, char[][] parameterNames) {
        StringBuffer completion = new StringBuffer();
        ASTNode.printModifiers((int)(method.getModifiers() & 0xFFFFFAFE), (StringBuffer)completion);
        completion.append(ProposalUtils.createSimpleTypeName(method.getReturnType()));
        completion.append(' ');
        completion.append(method.getName());
        completion.append('(');
        Parameter[] parameters = method.getParameters();
        int i = 0;
        while (i < parameters.length) {
            if (i != 0) {
                completion.append(',');
                completion.append(' ');
            }
            completion.append(ProposalUtils.createSimpleTypeName(parameters[i].getType()));
            completion.append(' ').append(parameterNames[i]);
            ++i;
        }
        completion.append(')');
        ClassNode[] exceptions = method.getExceptions();
        if (exceptions != null && exceptions.length > 0) {
            completion.append(' ');
            completion.append("throws");
            completion.append(' ');
            int i2 = 0;
            while (i2 < exceptions.length) {
                if (i2 != 0) {
                    completion.append(' ');
                    completion.append(',');
                }
                completion.append(ProposalUtils.createSimpleTypeName(exceptions[i2]));
                ++i2;
            }
        }
        char[] chars = new char[completion.length()];
        completion.getChars(0, chars.length, chars, 0);
        return chars;
    }

    private static ClassNode findResolvedType(ClassNode target, ClassNode toResolve) {
        if (target != null) {
            if (target.equals((Object)toResolve)) {
                return target;
            }
            ClassNode result = NewMethodCompletionProcessor.findResolvedType(target.getUnresolvedSuperClass(false), toResolve);
            if (result != null) {
                return result;
            }
            ClassNode[] interfaces = target.getUnresolvedInterfaces(false);
            if (interfaces != null) {
                ClassNode[] classNodeArray = interfaces;
                int n = interfaces.length;
                int n2 = 0;
                while (n2 < n) {
                    ClassNode cn = classNodeArray[n2];
                    result = NewMethodCompletionProcessor.findResolvedType(cn, toResolve);
                    if (result != null) {
                        return result;
                    }
                    ++n2;
                }
            }
            if (target.isRedirectNode()) {
                return NewMethodCompletionProcessor.findResolvedType(target.redirect(), toResolve);
            }
        }
        return null;
    }

    private static boolean isTraitBridge(MethodNode method) {
        return GroovyUtils.getAnnotations((AnnotatedNode)method, (String)Traits.TraitBridge.class.getName()).anyMatch(x -> true);
    }
}

