/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testdata.dialog;

import com.kms.katalon.composer.components.impl.dialogs.DatabaseConnectionAbstractDialog;
import com.kms.katalon.core.util.internal.Base64;
import com.kms.katalon.entity.testdata.DataFileEntity;
import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.widgets.Shell;

public class EditTestDataQueryDialog
extends DatabaseConnectionAbstractDialog {
    private DataFileEntity testData;

    public EditTestDataQueryDialog(Shell parentShell, DataFileEntity testData) {
        super(parentShell);
        this.testData = testData;
    }

    public DataFileEntity getTestData() {
        return this.testData;
    }

    protected void setInput() {
        this.chkGlobalDBSetting.setSelection(this.testData.isUsingGlobalDBSetting());
        this.chkSecureUserPassword.setSelection(this.testData.isSecureUserAccount());
        this.enableCustomDBConnection(!this.testData.isUsingGlobalDBSetting());
        this.txtUser.setText(StringUtils.defaultString((String)this.testData.getUser()));
        String plainPassword = Base64.decode((String)this.testData.getPassword());
        if (plainPassword != null) {
            this.txtPassword.setText(plainPassword);
        }
        this.txtConnectionURL.setText(this.testData.getDataSourceUrl());
        this.txtQuery.setText(this.testData.getQuery());
        if (this.testData.getDriverClassName() != null) {
            this.txtDriverClassName.setText(this.testData.getDriverClassName());
        }
        this.initialInputConnectionProperies(this.testData.getConnectionProperties());
    }

    protected void updateChanges() {
        if (!this.isChanged()) {
            return;
        }
        this.testData.setUsingGlobalDBSetting(this.chkGlobalDBSetting.getSelection());
        this.testData.setSecureUserAccount(this.chkSecureUserPassword.getSelection());
        this.testData.setUser(StringUtils.trimToEmpty((String)this.txtUser.getText()));
        this.testData.setPassword(Base64.encode((String)this.txtPassword.getText()));
        this.testData.setDataSourceUrl(StringUtils.trimToEmpty((String)this.txtConnectionURL.getText()));
        this.testData.setQuery(StringUtils.trimToEmpty((String)this.txtQuery.getText()));
        this.testData.setDriverClassName(StringUtils.trimToEmpty((String)this.txtDriverClassName.getText()));
        this.updateConnectionProperties();
    }

    protected void updateConnectionProperties() {
        this.DBConnectionProperties.setConnectionProperty(this.connectionPropertyTable.getListConnectionPropeties());
        this.testData.setConnectionProperties(this.DBConnectionProperties);
    }
}

